/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamesValidator
implements NamesValidator {
    public boolean isKeyword(@NotNull String name, Project project) {
        return OCNamesValidator.isKeyword(name);
    }

    public static boolean isKeyword(@NotNull String name) {
        return OCNamesValidator.isKeyword(name, (OCLanguageKind)CLanguageKind.OBJ_CPP);
    }

    public static boolean isKeyword(@NotNull String name, @NotNull OCLanguageKind kind) {
        IElementType tokenType = CidrLangUtil.getTokenType((String)name, (OCLanguageKind)kind, null);
        return OCTokenTypes.KEYWORDS.contains(tokenType);
    }

    public boolean isIdentifier(@NotNull String name, Project project) {
        return OCNamesValidator.isIdentifier(name);
    }

    public static boolean isIdentifier(String name) {
        return OCNamesValidator.isIdentifier(name, (OCLanguageKind)CLanguageKind.OBJ_CPP);
    }

    public static boolean isIdentifier(@NotNull String name, @NotNull OCLanguageKind kind) {
        return OCNamesValidator.isIdentifier(name, kind, null);
    }

    public static boolean isIdentifier(@NotNull String name, @NotNull OCLanguageKind kind, @Nullable OCFile file) {
        OCLanguageStandard languageStandard = file != null ? OCCompilerFeaturesHelper.getLanguageStandard(null, file) : null;
        return CidrLangUtil.isIdentifier((String)name, (OCLanguageKind)kind, (OCLanguageStandard)languageStandard);
    }
}

