/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNoexceptExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNoexceptEvaluatorHelper;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCExpressionEvaluator {
    private static final Logger LOG = Logger.getInstance(OCExpressionEvaluator.class);
    public static final Map<String, BiFunction<OCType, OCResolveContext, Boolean>> BUILT_IN_TRAITS;

    private OCExpressionEvaluator() {
    }

    @Nullable
    public static Number evaluate(@Nullable OCExpression psi) {
        return psi != null ? (Number)OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evaluate((OCTypeOwner)psi, new ValueEvaluator(psi))) : (Number)null;
    }

    private static Long getBooleanValue(boolean value) {
        return value ? 1L : 0L;
    }

    private static Number getNumber(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof Boolean) {
            return OCExpressionEvaluator.getBooleanValue((Boolean)o);
        }
        return null;
    }

    @Nullable
    public static Object evaluateToIntOrBoolean(@Nullable OCExpression psi) {
        return psi != null ? OCExpressionEvaluator.evaluate((OCTypeOwner)psi, new ValueEvaluator(psi)) : null;
    }

    public static boolean isPositive(@Nullable OCTypeOwner expression, @NotNull OCResolveContext context) {
        Pair<Boolean, Number> result = OCExpressionEvaluator.evaluate(expression, new PositiveEvaluator(context));
        return result != null ? (Boolean)result.getFirst() : false;
    }

    @Nullable
    public static OCType getPointerType(@Nullable OCTypeOwner expression, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.evaluate(expression, new PointerTypeEvaluator(context));
    }

    public static boolean isLikeNil(@Nullable OCTypeOwner expression, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.getPointerType(expression, context) instanceof OCUnknownType;
    }

    @Nullable
    public static Number evaluate(@NotNull OCExpression expression, @NotNull OCType targetType) {
        return OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evaluate(expression, targetType, new ValueEvaluator(expression)));
    }

    @Nullable
    private static <T> T evaluate(@Nullable OCExpression expression, @NotNull OCType targetType, CachingEvaluator<T> evaluator) {
        T value = OCExpressionEvaluator.evaluate((OCTypeOwner)expression, evaluator);
        if (!(value instanceof Number)) {
            return value;
        }
        if (OCIntType.isBool(targetType, evaluator.myContext)) {
            value = evaluator.evalBool(OCExpressionEvaluator.singAsInC(value) != 0);
        } else if (targetType instanceof OCIntType) {
            value = evaluator.evalInteger(OCNumber.convert(OCNumber.valueOf(value), targetType.getSizeInBytes(expression.getContainingFile(), null, expression.getProject()), ((OCIntType)targetType).isSigned()));
        }
        return value;
    }

    @Nullable
    public static <T> T evaluate(@Nullable OCTypeOwner expression, CachingEvaluator<T> evaluator) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof OCExpression) {
            EvaluationVisitor<T> visitor = new EvaluationVisitor<T>(evaluator);
            ((OCExpression)expression).accept(visitor);
            return visitor.getResult();
        }
        if (expression instanceof OCExpressionSymbol) {
            return ((OCExpressionSymbol)expression).evaluate(evaluator);
        }
        return null;
    }

    @Nullable
    public static Number evaluate(@Nullable OCTypeOwner expression, @NotNull OCResolveContext context) {
        if (expression instanceof OCExpression) {
            return OCExpressionEvaluator.evaluate((OCExpression)expression);
        }
        if (expression instanceof OCExpressionSymbol) {
            return OCExpressionEvaluator.evaluate((OCExpressionSymbol)expression, context);
        }
        return null;
    }

    @Nullable
    public static Object evaluate(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.evaluate(symbol, context.getEvaluator());
    }

    @Nullable
    public static Number evaluate(@NotNull OCExpressionSymbol symbol, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.getNumber(symbol.evaluate(context.getEvaluator()));
    }

    @Nullable
    public static Object evaluate(@NotNull OCExpression psi, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.evaluate((OCTypeOwner)psi, context.getEvaluator());
    }

    @Nullable
    public static <T> T evaluate(@Nullable OCSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        if (!(symbol instanceof OCDeclaratorSymbol)) {
            return null;
        }
        if (evaluator.contains(symbol)) {
            return evaluator.get(symbol);
        }
        evaluator.cache(symbol, null);
        T result = null;
        if (symbol.getKind() == OCSymbolKind.ENUM_CONST) {
            result = evaluator.evalEnumConst(symbol);
        } else if (symbol instanceof OCTypeParameterValueSymbol) {
            OCTypeArgument type = ((OCDeclaratorSymbol)symbol).getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)symbol);
            if (type == null) {
                type = evaluator.getContext().getSubstitution().getSubstitutionFor((OCTypeParameterValueSymbol)symbol);
            }
            if (type == null) {
                evaluator.getContext().addTypeDependency((OCTypeParameterSymbol)symbol);
            }
            if (type instanceof OCExpressionTypeArgument) {
                result = ((OCExpressionTypeArgument)type).getSymbol().evaluate(evaluator);
            }
        } else {
            result = OCExpressionEvaluator.evaluateConstDeclarator((OCDeclaratorSymbol)symbol, evaluator);
        }
        if (symbol instanceof OCTypeParameterValueSymbol) {
            evaluator.remove(symbol);
        } else {
            evaluator.cache(symbol, result);
        }
        return result;
    }

    @Nullable
    private static <T> T evaluateConstDeclarator(@NotNull OCDeclaratorSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        OCExpressionSymbol initializer;
        if (symbol.isConst() && symbol.getKind() != OCSymbolKind.PARAMETER && (symbol.getKind() != OCSymbolKind.STRUCT_FIELD || symbol.isFriendOrStatic()) && (initializer = symbol.getInitializerExpression()) != null) {
            OCResolveContext oldContext = evaluator.myContext;
            evaluator.myContext = oldContext.substituteFirst(symbol.getSubstitution());
            T result = initializer.evaluate(evaluator);
            evaluator.myContext = oldContext;
            return result;
        }
        return null;
    }

    @Nullable
    public static Integer evaluateEnumConst(@Nullable OCSymbol symbol, @NotNull PsiFile file) {
        return OCExpressionEvaluator.evaluateEnumConst(symbol, new ValueEvaluator(OCResolveContext.forPsi((PsiElement)file)));
    }

    @Nullable
    private static <T> Integer evaluateEnumConst(@Nullable OCSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        Number initializer;
        if (symbol == null || symbol.getKind() != OCSymbolKind.ENUM_CONST || !(symbol instanceof OCDeclaratorSymbol)) {
            return null;
        }
        OCType type = symbol.getType();
        OCDeclaratorSymbol declarator = (OCDeclaratorSymbol)symbol;
        if (type instanceof OCStructType) {
            OCStructType structType = (OCStructType)type;
            List<OCDeclaratorSymbol> fields = structType.getFields();
            int index = fields.indexOf(declarator);
            int base = 0;
            int baseIndex = 0;
            assert (index != -1);
            for (int i = index; i >= 0; --i) {
                OCDeclaratorSymbol field = fields.get(i);
                Number initializer2 = OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evaluateConstDeclarator(field, evaluator));
                if (initializer2 == null) continue;
                base = initializer2.intValue();
                baseIndex = i;
                break;
            }
            return base + index - baseIndex;
        }
        if (type instanceof OCIntType && (initializer = OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evaluateConstDeclarator((OCDeclaratorSymbol)symbol, evaluator))) != null) {
            return initializer.intValue();
        }
        return null;
    }

    @Nullable
    public static OCSymbol findMatchingEnumConst(OCStructType enumType, int value, @NotNull OCResolveContext context) {
        OCStructSymbol enumSymbol = enumType.getSymbol();
        if (enumSymbol.getKind() != OCSymbolKind.ENUM) {
            return null;
        }
        int curValue = -1;
        for (OCDeclaratorSymbol field : enumType.getFields()) {
            Object initializer = OCExpressionEvaluator.evaluateConstDeclarator(field, context.getEvaluator());
            curValue = initializer instanceof Number ? ((Number)initializer).intValue() : ++curValue;
            if (curValue != value) continue;
            return field;
        }
        return null;
    }

    @Nullable
    private static Object evalConstexprFunction(OCSymbol callee, OCResolveContext context, List<Object> arguments) {
        if (callee instanceof OCFunctionSymbol && ((OCFunctionSymbol)callee).isConstexpr()) {
            List returnExpressions;
            OCType returnType = ((OCFunctionType)callee.getType()).getReturnType();
            OCExpressionSymbol lambda2 = returnType instanceof OCAutoType ? ((OCAutoType)returnType).getExpressionSymbol() : null;
            List<Object> list = returnExpressions = lambda2 instanceof OCLambdaExpressionSymbol ? ((OCLambdaExpressionSymbol)lambda2).getReturnExpressions() : Collections.emptyList();
            if (returnExpressions.size() == 1) {
                List<OCDeclaratorSymbol> parameters = ((OCLambdaExpressionSymbol)lambda2).getParameters();
                if ((context = context.substitute(((OCFunctionSymbol)callee).getSubstitution())).getNestingDepth() > 256) {
                    return null;
                }
                if (parameters.size() >= arguments.size()) {
                    HashMap<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
                    HashMap<OCDeclaratorSymbol, OCTypeParameterValueSymbol> parametersMap = new HashMap<OCDeclaratorSymbol, OCTypeParameterValueSymbol>();
                    for (int i = 0; i < parameters.size(); ++i) {
                        OCExpressionSymbol argument;
                        OCDeclaratorSymbol parameter = parameters.get(i);
                        if (i < arguments.size()) {
                            Object argumentValue = arguments.get(i);
                            argument = argumentValue != null ? new OCLiteralExpressionSymbol(argumentValue, null, null) : null;
                        } else if (parameter.hasInitializerExpression()) {
                            argument = parameter.getInitializerExpression();
                        } else {
                            return null;
                        }
                        if (argument == null) continue;
                        OCTypeParameterValueSymbol paramSymbol = new OCTypeParameterValueSymbol(null, 0L, null, parameter.getQualifiedName(), null, Collections.emptyList(), parameter.getType(), OCSymbolKind.TEMPLATE_VALUE_PARAMETER, Collections.emptyList(), null, OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null);
                        substitutionMap.put(paramSymbol, new OCExpressionTypeArgument(argument));
                        parametersMap.put(parameter, paramSymbol);
                    }
                    context = context.substitute(OCSimpleTypeSubstitution.create(substitutionMap), true, true);
                    context.setAutoParamsValueMapping(parametersMap);
                }
                return OCExpressionEvaluator.evaluate((OCExpressionSymbol)returnExpressions.get(0), context);
            }
        }
        return null;
    }

    @Nullable
    public static Boolean evaluateGNUBuiltInTrait(OCCallExpression expression, @NotNull OCResolveContext context) {
        OCExpression function = expression.getFunctionReferenceExpression();
        List<OCExpression> arguments = expression.getArguments();
        if (!(function instanceof OCReferenceExpression) || arguments.size() != 1 || !(arguments.get(0) instanceof OCReferenceExpression)) {
            return null;
        }
        OCReferenceElement funElement = ((OCReferenceExpression)function).getReferenceElement();
        OCReferenceElement argElement = ((OCReferenceExpression)arguments.get(0)).getReferenceElement();
        String funName = funElement != null ? funElement.getName() : null;
        String argName = argElement != null ? argElement.getName() : null;
        OCSymbolReference argRef = new OCReferenceTypeBuilder(OCQualifiedName.interned(argName), expression, OCElementUtil.getVirtualFile(expression)).build().getReference(context.getFile());
        return OCExpressionEvaluator.evaluateGNUBuiltInTrait(context, funName, argRef);
    }

    @Nullable
    public static Boolean evaluateGNUBuiltInTrait(@NotNull OCResolveContext context, String funName, OCSymbolReference argRef) {
        if (funName == null || argRef == null || !funName.startsWith("__")) {
            return null;
        }
        OCReferenceType referenceType = new OCReferenceTypeBuilder(argRef).setSubstitution(context.getSubstitution()).build();
        OCType type = referenceType.resolve(context);
        BiFunction<OCType, OCResolveContext, Boolean> function = BUILT_IN_TRAITS.get(funName);
        return function == null ? null : function.apply(type, context);
    }

    public static int singAsInC(@NotNull Object o) {
        if (o instanceof Boolean) {
            return ((Boolean)o).compareTo(Boolean.FALSE);
        }
        if (o instanceof OCNumber) {
            return ((OCNumber)o).compareTo(BigInteger.ZERO);
        }
        if (o instanceof Long) {
            return ((Long)o).compareTo(0L);
        }
        if (o instanceof Integer) {
            return ((Integer)o).compareTo(0);
        }
        if (o instanceof Float) {
            return ((Float)o).compareTo(Float.valueOf(0.0f));
        }
        if (o instanceof Double) {
            return ((Double)o).compareTo(0.0);
        }
        OCLog.LOG.warn("Unknown type in evaluation:" + o.getClass());
        return 0;
    }

    @Contract(value="null -> false")
    public static boolean isIntValue(@Nullable Object o) {
        return o instanceof BigInteger || o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte;
    }

    @Contract(value="null -> false")
    public static boolean isNullCompatible(@Nullable Object o) {
        return OCExpressionEvaluator.isIntValue(o) && OCExpressionEvaluator.singAsInC(o) == 0;
    }

    static {
        HashMap<String, BiFunction<OCType, OCResolveContext, Boolean>> traits = new HashMap<String, BiFunction<OCType, OCResolveContext, Boolean>>();
        traits.put("__is_class", (type, context) -> type.isMagicInside((OCResolveContext)context) ? null : Boolean.valueOf(type instanceof OCStructType && type.isCppStructType((OCCompilationContext)context)));
        traits.put("__is_enum", (type, context) -> type.isMagicInside((OCResolveContext)context) ? null : Boolean.valueOf(type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM));
        traits.put("__is_union", (type, context) -> type.isMagicInside((OCResolveContext)context) ? null : Boolean.valueOf(type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.UNION));
        traits.put("__is_pod", (type, context) -> type.isMagicInside((OCResolveContext)context) ? null : Boolean.valueOf(type instanceof OCStructType && ((OCStructType)type).isPOD(false, (OCResolveContext)context)));
        traits.put("__is_abstract", (type, context) -> type.isMagicInside((OCResolveContext)context) ? null : Boolean.valueOf(type instanceof OCStructType && ((OCStructType)type).isAbstract()));
        HashSet<String> featuresTraits = new HashSet<String>(Arrays.asList(ClangFeatures.SUPPORTED_BUILT_IN_TRAITS));
        HashSet evaluatorTraits = new HashSet(traits.keySet());
        LOG.assertTrue(evaluatorTraits.equals(featuresTraits));
        BUILT_IN_TRAITS = Collections.unmodifiableMap(traits);
    }

    public static class PointerTypeEvaluator
    extends CachingEvaluator<OCType> {
        protected PointerTypeEvaluator(@NotNull OCResolveContext context) {
            super(context);
        }

        @Override
        @Nullable
        public OCType evalEnumConst(OCSymbol symbol) {
            return null;
        }

        @Override
        public OCType evalDefault(OCExpression psi) {
            OCType type = psi.getResolvedType(this.myContext);
            return type instanceof OCPointerType ? type : null;
        }

        @Override
        @Nullable
        public OCType evalInteger(Number value) {
            return OCExpressionEvaluator.isNullCompatible(value) ? OCUnknownType.INSTANCE : null;
        }

        @Override
        public OCType evalBool(Boolean value) {
            return value == false ? OCUnknownType.INSTANCE : null;
        }

        @Override
        public OCType evalBinary(OCElementType t, OCType l, OCType r) {
            return null;
        }

        @Override
        public OCType evalUnary(OCElementType t, OCType arg) {
            return arg == OCUnknownType.INSTANCE && t == OCTokenTypes.PLUS ? arg : null;
        }

        @Override
        public OCType evalConditional(OCType condition, Supplier<OCType> l, Supplier<OCType> r) {
            OCType lType = l.get();
            OCType rType = r.get();
            if (lType == OCUnknownType.INSTANCE) {
                return r.get();
            }
            if (rType == OCUnknownType.INSTANCE) {
                return lType;
            }
            return null;
        }

        @Override
        @Nullable
        public OCType evalCast(OCType type, OCType operand) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalCall(OCCallExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalReference(OCReferenceExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalSizeof(OCSizeofExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalNoexcept(OCNoexceptExpressionSymbol noexceptExpr) {
            return null;
        }
    }

    public static class PositiveEvaluator
    extends CachingEvaluator<Pair<Boolean, Number>> {
        private ValueEvaluator valueEvaluator;

        public PositiveEvaluator(@NotNull OCResolveContext context) {
            super(context);
            this.valueEvaluator = new ValueEvaluator(context);
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalDefault(@NotNull OCExpression psi) {
            OCType type = psi.getResolvedType(this.valueEvaluator.getContext());
            if (type instanceof OCIntType && !((OCIntType)type).isSigned()) {
                return new Pair((Object)true, null);
            }
            return null;
        }

        @Override
        @NotNull
        public Pair<Boolean, Number> evalInteger(@NotNull Number value) {
            return new Pair((Object)(OCExpressionEvaluator.singAsInC(value) >= 0 ? 1 : 0), (Object)value);
        }

        @Override
        public Pair<Boolean, Number> evalBool(Boolean value) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalUnary(OCElementType t, Pair<Boolean, Number> arg) {
            if (arg == null) {
                return null;
            }
            Object value = this.valueEvaluator.evalUnary(t, arg.getSecond());
            return new Pair((Object)(value instanceof Number && ((Number)value).longValue() >= 0L ? 1 : 0), (Object)(value instanceof Number ? (Number)((Number)value) : (Number)null));
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalBinary(OCElementType t, Pair<Boolean, Number> l, Pair<Boolean, Number> r) {
            if (l == null || r == null) {
                return null;
            }
            Object value = this.valueEvaluator.evalBinary(t, l.getSecond(), r.getSecond());
            boolean isPositive = value instanceof Number && OCExpressionEvaluator.singAsInC(value) >= 0 || t == OCTokenTypes.PLUS && (Boolean)l.getFirst() != false && (Boolean)r.getFirst() != false;
            return new Pair((Object)isPositive, (Object)(value instanceof Number ? (Number)((Number)value) : (Number)null));
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalConditional(Pair<Boolean, Number> condition, Supplier<Pair<Boolean, Number>> l, Supplier<Pair<Boolean, Number>> r) {
            Pair<Boolean, Number> right;
            Pair<Boolean, Number> left = l != null ? l.get() : null;
            Pair<Boolean, Number> pair = right = r != null ? r.get() : null;
            return left != null && right != null ? new Pair((Object)((Boolean)left.getFirst() != false && (Boolean)right.getFirst() != false ? 1 : 0), null) : null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalCast(OCType type, Pair<Boolean, Number> operand) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalCall(OCCallExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalReference(OCReferenceExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalSizeof(OCSizeofExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalNoexcept(OCNoexceptExpressionSymbol noexceptExpr) {
            return null;
        }
    }

    public static class ValueEvaluator
    extends CachingEvaluator<Object> {
        public ValueEvaluator(@NotNull PsiElement element) {
            super(OCResolveContext.forPsi(element));
        }

        public ValueEvaluator(@NotNull OCResolveContext context) {
            super(context);
        }

        public ValueEvaluator(@NotNull ValueEvaluator clone, OCResolveContext context) {
            super(clone, context);
        }

        @Override
        public Number evalDefault(OCExpression psi) {
            return null;
        }

        @Override
        public Object evalConditional(Object condition, Supplier<Object> l, Supplier<Object> r) {
            if (condition instanceof Number || condition instanceof Boolean) {
                return OCExpressionEvaluator.singAsInC(condition) == 0 ? r.get() : l.get();
            }
            return null;
        }

        @Override
        public Object evalInteger(Number value) {
            return value;
        }

        @Override
        public Object evalBool(Boolean value) {
            return value;
        }

        @Override
        @Nullable
        public Object evalBinary(OCElementType t, Object l, Object r) {
            Number rInt;
            Number lInt;
            if (t == OCTokenTypes.OROR && l != null && OCExpressionEvaluator.singAsInC(l) != 0 || t == OCTokenTypes.ANDAND && l != null && OCExpressionEvaluator.singAsInC(l) == 0) {
                return OCExpressionEvaluator.singAsInC(l) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (t == OCTokenTypes.OROR && r != null && OCExpressionEvaluator.singAsInC(r) != 0 || t == OCTokenTypes.ANDAND && r != null && OCExpressionEvaluator.singAsInC(r) == 0) {
                return OCExpressionEvaluator.singAsInC(r) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (l == null || r == null) {
                return null;
            }
            if (l instanceof Boolean && r instanceof Boolean) {
                Boolean lBool = (Boolean)l;
                Boolean rBool = (Boolean)r;
                if (t == OCTokenTypes.OR) {
                    return lBool | rBool;
                }
                if (t == OCTokenTypes.XOR) {
                    return lBool ^ rBool;
                }
                if (t == OCTokenTypes.AND) {
                    return lBool & rBool;
                }
                if (t == OCTokenTypes.OROR) {
                    return lBool != false || rBool != false;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return lBool != false && rBool != false;
                }
            }
            if (l instanceof Boolean) {
                l = OCExpressionEvaluator.getBooleanValue((Boolean)l);
            }
            if (r instanceof Boolean) {
                r = OCExpressionEvaluator.getBooleanValue((Boolean)r);
            }
            if (l instanceof Integer) {
                l = ((Number)l).longValue();
            }
            if (r instanceof Integer) {
                r = ((Number)r).longValue();
            }
            if (l instanceof Long && r instanceof Long) {
                lInt = (Long)l;
                rInt = (Long)r;
                if (t == OCTokenTypes.PLUS) {
                    return (Long)lInt + (Long)rInt;
                }
                if (t == OCTokenTypes.MINUS) {
                    return (Long)lInt - (Long)rInt;
                }
                if (t == OCTokenTypes.MUL) {
                    return (Long)lInt * (Long)rInt;
                }
                if (t == OCTokenTypes.DIV) {
                    return (Long)rInt != 0L ? Long.valueOf((Long)lInt / (Long)rInt) : null;
                }
                if (t == OCTokenTypes.PERC) {
                    return (Long)rInt != 0L ? Long.valueOf((Long)lInt % (Long)rInt) : null;
                }
                if (t == OCTokenTypes.OR) {
                    return (Long)lInt | (Long)rInt;
                }
                if (t == OCTokenTypes.XOR) {
                    return (Long)lInt ^ (Long)rInt;
                }
                if (t == OCTokenTypes.AND) {
                    return (Long)lInt & (Long)rInt;
                }
                if (t == OCTokenTypes.LTLT) {
                    return (Long)lInt << (int)((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.GTGT) {
                    return (Long)lInt >> (int)((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.OROR) {
                    return (Long)lInt != 0L || (Long)rInt != 0L ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return (Long)lInt != 0L && (Long)rInt != 0L ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.LT) {
                    return (Long)lInt < (Long)rInt;
                }
                if (t == OCTokenTypes.LTEQ) {
                    return (Long)lInt <= (Long)rInt;
                }
                if (t == OCTokenTypes.GT) {
                    return (Long)lInt > (Long)rInt;
                }
                if (t == OCTokenTypes.GTEQ) {
                    return (Long)lInt >= (Long)rInt;
                }
                if (t == OCTokenTypes.EQEQ) {
                    return ((Long)lInt).longValue() == ((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.EXCLEQ) {
                    return ((Long)lInt).longValue() != ((Long)rInt).longValue();
                }
            }
            if (l instanceof Long) {
                l = OCNumber.valueOf(((Number)l).longValue());
            }
            if (r instanceof Long) {
                r = OCNumber.valueOf(((Number)r).longValue());
            }
            if (l instanceof OCNumber && r instanceof OCNumber) {
                lInt = (OCNumber)l;
                rInt = (OCNumber)r;
                if (t == OCTokenTypes.PLUS) {
                    return ((OCNumber)lInt).add((BigInteger)rInt);
                }
                if (t == OCTokenTypes.MINUS) {
                    return ((OCNumber)lInt).subtract((BigInteger)rInt);
                }
                if (t == OCTokenTypes.MUL) {
                    return ((OCNumber)lInt).multiply((BigInteger)rInt);
                }
                if (t == OCTokenTypes.DIV) {
                    return ((BigInteger)rInt).equals(BigInteger.ZERO) ? null : ((OCNumber)lInt).divide((BigInteger)rInt);
                }
                if (t == OCTokenTypes.PERC) {
                    if (((BigInteger)rInt).equals(BigInteger.ZERO)) {
                        return null;
                    }
                    boolean positiveSign = ((OCNumber)lInt).compareTo(BigInteger.ZERO) >= 0;
                    BigInteger mod = ((BigInteger)lInt).abs().mod(((BigInteger)rInt).abs());
                    return positiveSign ? mod : mod.negate();
                }
                if (t == OCTokenTypes.OR) {
                    return ((OCNumber)lInt).or((BigInteger)rInt);
                }
                if (t == OCTokenTypes.XOR) {
                    return ((OCNumber)lInt).xor((BigInteger)rInt);
                }
                if (t == OCTokenTypes.AND) {
                    return ((OCNumber)lInt).and((BigInteger)rInt);
                }
                if (t == OCTokenTypes.LTLT) {
                    return ((OCNumber)lInt).shiftLeft((BigInteger)rInt);
                }
                if (t == OCTokenTypes.GTGT) {
                    return ((OCNumber)lInt).shiftRight((BigInteger)rInt);
                }
                if (t == OCTokenTypes.OROR) {
                    return !((BigInteger)lInt).equals(BigInteger.ZERO) || !((BigInteger)rInt).equals(BigInteger.ZERO) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return !((BigInteger)lInt).equals(BigInteger.ZERO) && !((BigInteger)rInt).equals(BigInteger.ZERO) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.LT) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) < 0;
                }
                if (t == OCTokenTypes.LTEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) <= 0;
                }
                if (t == OCTokenTypes.GT) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) > 0;
                }
                if (t == OCTokenTypes.GTEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) >= 0;
                }
                if (t == OCTokenTypes.EQEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) == 0;
                }
                if (t == OCTokenTypes.EXCLEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) != 0;
                }
            }
            if (l instanceof Number && r instanceof Number) {
                return null;
            }
            LOG.error("Unexpected binary operation: " + t);
            return null;
        }

        @Override
        @Nullable
        public Object evalUnary(OCElementType t, Object arg) {
            if (arg == null) {
                return null;
            }
            if (arg instanceof Integer) {
                arg = ((Integer)arg).longValue();
            }
            if (t == OCTokenTypes.EXCL && (arg instanceof Number || arg instanceof Boolean)) {
                return OCExpressionEvaluator.getBooleanValue(OCExpressionEvaluator.singAsInC(arg) == 0);
            }
            if (t == OCTokenTypes.PLUS && arg instanceof Number) {
                return arg;
            }
            if (t == OCTokenTypes.MINUS) {
                if (arg instanceof Long) {
                    return -((Long)arg).longValue();
                }
                if (arg instanceof OCNumber) {
                    return ((OCNumber)arg).negate();
                }
            }
            if (t == OCTokenTypes.TILDE) {
                if (arg instanceof Long) {
                    return (Long)arg ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (arg instanceof OCNumber) {
                    return ((OCNumber)arg).inverse();
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Object evalCast(@NotNull OCType type, @Nullable Object operand) {
            if (OCIntType.isBool(type.resolve(this.getContext()), this.getContext()) && operand instanceof Number) {
                return this.evalBool(OCExpressionEvaluator.singAsInC(operand) != 0);
            }
            return operand;
        }

        @Override
        @Nullable
        public Object evalCall(@NotNull OCCallExpressionSymbol symbol) {
            OCExpressionSymbol calleeSymbol = symbol.getCalleeSymbol();
            List<OCExpressionSymbol> arguments = symbol.getArguments();
            if (calleeSymbol instanceof OCReferenceExpressionSymbol) {
                List<Object> argValues;
                Object result;
                OCSymbol callee = ((OCReferenceExpressionSymbol)calleeSymbol).resolveToSymbol(this.myContext);
                if (arguments.size() == 1) {
                    if (callee != null && (callee.getKind() == OCSymbolKind.TYPEDEF || callee.getKind() == OCSymbolKind.USING_SYMBOL_ALIAS)) {
                        return this.evalCast(callee.getType(), arguments.get(0).evaluate(this));
                    }
                    if (arguments.get(0) instanceof OCReferenceExpressionSymbol) {
                        return OCExpressionEvaluator.evaluateGNUBuiltInTrait(this.myContext, calleeSymbol.getName(), ((OCReferenceExpressionSymbol)arguments.get(0)).getReference());
                    }
                }
                if ((result = OCExpressionEvaluator.evalConstexprFunction(callee, this.myContext, argValues = arguments.stream().map(e -> e.evaluate(this)).collect(Collectors.toList()))) != null) {
                    return result;
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Object evalReference(@NotNull OCReferenceExpressionSymbol symbol) {
            OCTypeParameterValueSymbol mapping;
            if (OCResolveUtil.isDependentCode(symbol.getReference().getQualifiedName(), this.myContext)) {
                return null;
            }
            OCSymbol target = symbol.resolveToSymbol(this.myContext);
            if (target != null && target.getKind() == OCSymbolKind.PARAMETER && (mapping = this.myContext.getAutoParamValueMapping((OCDeclaratorSymbol)target)) != null) {
                target = mapping;
            }
            return target != null ? OCExpressionEvaluator.evaluate(target, this) : null;
        }

        @Override
        @Nullable
        public Object evalSizeof(@NotNull OCSizeofExpressionSymbol symbol) {
            OCType type;
            OCExpressionSymbol expression = symbol.getExpressionOperand();
            OCType oCType = type = expression != null ? expression.getResolvedType(this.myContext) : symbol.getTypeOperand().resolve(this.myContext);
            if (symbol.isVariadic()) {
                OCTypeArgument argument;
                OCSymbol exprSymbol;
                if (type instanceof OCExpansionPackType) {
                    return ((OCExpansionPackType)type).getExpansions().size();
                }
                if (expression instanceof OCReferenceExpressionSymbol && (exprSymbol = ((OCReferenceExpressionSymbol)expression).resolveToSymbol(this.myContext)) instanceof OCTypeParameterValueSymbol && (argument = this.myContext.getSubstitution().getSubstitutionFor((OCTypeParameterValueSymbol)exprSymbol)) instanceof OCExpansionPackType) {
                    return ((OCExpansionPackType)argument).getExpansions().size();
                }
                return null;
            }
            if ((type == null || type.isUnknown()) && expression instanceof OCReferenceExpressionSymbol) {
                OCReferenceType ref2Type = ((OCReferenceExpressionSymbol)expression).asTypeReference();
                type = ref2Type.resolve(this.myContext);
            }
            int bytes = type != null ? type.getSizeInBytes(this.myContext.getFile(), null, this.myContext.getProject()) : -1;
            return bytes != -1 ? this.evalInteger(bytes) : null;
        }

        @Override
        @Nullable
        public Object evalNoexcept(OCNoexceptExpressionSymbol noexceptExpr) {
            OCNoexceptEvaluatorHelper helper = new OCNoexceptEvaluatorHelper(this, this.myContext);
            OCExpressionSymbol expression = noexceptExpr.getExpressionOperand();
            if (helper.canThrow(expression) == OCNoexceptEvaluatorHelper.CanThrowResult.Cannot) {
                return true;
            }
            return false;
        }
    }

    private static class EvaluationVisitor<T>
    extends OCVisitor {
        private T myResult;
        private CachingEvaluator<T> myEvaluator;

        EvaluationVisitor(CachingEvaluator<T> evaluator) {
            this.myEvaluator = evaluator;
        }

        @Nullable
        private T getResult() {
            return this.myResult;
        }

        @Override
        public void visitLiteralExpression(OCLiteralExpression expression) {
            PsiElement argument = expression.getFirstChild();
            if (argument == null) {
                return;
            }
            ASTNode leaf = argument.getNode();
            IElementType type = leaf.getElementType();
            Object value = OCElementUtil.getConstValue(type, leaf.getText(), leaf.getPsi(), null, expression.getProject());
            if (value instanceof Number) {
                this.myResult = this.myEvaluator.evalInteger((Number)value);
            } else if (value instanceof Boolean) {
                this.myResult = this.myEvaluator.evalBool((Boolean)value);
            }
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression) {
            OCReferenceElement referenceElement = expression.getReferenceElement();
            OCResolveContext context = this.myEvaluator.getContext();
            OCSymbol symbol = null;
            if (referenceElement != null) {
                symbol = referenceElement.resolveToSymbol(null, context, false, false, false);
            }
            if (!OCResolveUtil.isDependentCode(expression, context)) {
                this.myResult = OCExpressionEvaluator.evaluate(symbol, this.myEvaluator);
            }
            if (this.myResult == null) {
                this.myResult = this.myEvaluator.evalDefault(expression);
            }
        }

        @Override
        public void visitCastExpression(OCCastExpression expression) {
            this.myResult = OCExpressionEvaluator.evaluate(expression.getOperand(), expression.getResolvedType(), this.myEvaluator);
        }

        @Override
        public void visitSizeofExpression(OCSizeofExpression expression) {
            OCType type;
            OCExpression operand = expression.getOperand();
            OCTypeElement typeElement = expression.getTypeElement();
            if (expression.isVariadic()) {
                return;
            }
            if (operand != null) {
                type = operand.getResolvedType(this.myEvaluator.getContext());
            } else if (typeElement != null) {
                type = typeElement.getType();
                OCResolveContext context = this.myEvaluator.getContext();
                type = type.resolve(context);
            } else {
                return;
            }
            int bytes = type.getSizeInBytes(expression.getContainingFile(), null, expression.getProject());
            if (bytes != -1) {
                this.myResult = this.myEvaluator.evalInteger(bytes);
            }
        }

        @Override
        public void visitParenthesizedExpression(OCParenthesizedExpression expression) {
            this.myResult = OCExpressionEvaluator.evaluate((OCTypeOwner)expression.getOperand(), this.myEvaluator);
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression) {
            OCExpression left = expression.getLeft();
            OCExpression right = expression.getRight();
            OCElementType operator = expression.getOperationSign();
            this.myResult = this.myEvaluator.evalBinary(operator, OCExpressionEvaluator.evaluate((OCTypeOwner)left, this.myEvaluator), OCExpressionEvaluator.evaluate((OCTypeOwner)right, this.myEvaluator));
            if (this.myResult != null || left == null || right == null || OCCodeInsightUtil.hasSideEffects(left) || OCCodeInsightUtil.hasSideEffects(right)) {
                return;
            }
            OCType leftType = OCTypeUtils.getResolvedCppReferencedType(left, this.myEvaluator.getContext());
            OCType rightType = OCTypeUtils.getResolvedCppReferencedType(right, this.myEvaluator.getContext());
            if (OCTypeUtils.isInstanceOfType(leftType, OCMagicType.class, OCStructType.class) || OCTypeUtils.isInstanceOfType(rightType, OCMagicType.class, OCStructType.class)) {
                return;
            }
            if (OCParenthesesUtils.areExpressionsEquivalent(left, right, true, this.myEvaluator.getContext())) {
                if (operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) {
                    this.myResult = this.myEvaluator.evalBool(false);
                } else if (operator == OCTokenTypes.EQEQ) {
                    this.myResult = this.myEvaluator.evalBool(true);
                }
            } else if (OCParenthesesUtils.areExpressionsOpposite(left, right, true, this.myEvaluator.getContext())) {
                if (operator == OCTokenTypes.OROR || operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) {
                    this.myResult = this.myEvaluator.evalBool(true);
                } else if (operator == OCTokenTypes.ANDAND || operator == OCTokenTypes.EQEQ) {
                    this.myResult = this.myEvaluator.evalBool(false);
                }
            }
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression) {
            this.myResult = this.myEvaluator.evalUnary(expression.getOperationSign(), OCExpressionEvaluator.evaluate((OCTypeOwner)expression.getOperand(), this.myEvaluator));
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression) {
            this.myResult = this.myEvaluator.evalConditional(OCExpressionEvaluator.evaluate((OCTypeOwner)expression.getCondition(), this.myEvaluator), () -> OCExpressionEvaluator.evaluate((OCTypeOwner)expression.getPositiveExpression(true), this.myEvaluator), () -> OCExpressionEvaluator.evaluate((OCTypeOwner)expression.getNegativeExpression(), this.myEvaluator));
        }

        @Override
        public void visitCompoundInitializer(OCCompoundInitializer initializer) {
            List<OCExpression> expressions = initializer.getInitializerExpressions();
            if (expressions.size() == 1) {
                this.myResult = OCExpressionEvaluator.evaluate((OCTypeOwner)expressions.get(0), this.myEvaluator);
            }
        }

        @Override
        public void visitCallExpression(OCCallExpression expression) {
            Boolean result = OCExpressionEvaluator.evaluateGNUBuiltInTrait(expression, this.myEvaluator.getContext());
            if (result != null) {
                this.myResult = this.myEvaluator.evalBool(result);
                return;
            }
            OCSymbol callee = OCGetSymbolVisitor.getSymbol(expression.getFunctionReferenceExpression());
            List<Object> argValues = expression.getArguments().stream().map(e -> OCExpressionEvaluator.evaluate((OCTypeOwner)e, this.myEvaluator)).collect(Collectors.toList());
            Number number = OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evalConstexprFunction(callee, this.myEvaluator.getContext(), argValues));
            this.myResult = number != null ? this.myEvaluator.evalInteger(number) : this.myEvaluator.evalDefault(expression);
        }

        @Override
        public void visitExpression(OCExpression expr) {
            this.myResult = this.myEvaluator.evalDefault(expr);
        }
    }

    public static abstract class CachingEvaluator<T>
    implements Evaluator<T> {
        private static final int MAX_SUBSTITUTIONS_PER_SYMBOL = 450;
        private Map<Pair<OCSymbol, OCTypeSubstitution>, T> mySymbolsWithSubstitutions = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)new HashingStrategy<Pair<OCSymbol, OCTypeSubstitution>>(this){
            final /* synthetic */ CachingEvaluator this$0;
            {
                this.this$0 = this$0;
            }

            public int hashCode(Pair<OCSymbol, OCTypeSubstitution> object) {
                return object == null ? 0 : object.hashCode();
            }

            public boolean equals(Pair<OCSymbol, OCTypeSubstitution> o1, Pair<OCSymbol, OCTypeSubstitution> o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
        private MostlySingularMultiMap<OCSymbol, OCTypeSubstitution> mySubstitutions = new MostlySingularMultiMap();
        @NotNull
        protected OCResolveContext myContext;

        protected CachingEvaluator(@NotNull OCResolveContext context) {
            this.myContext = context;
        }

        public CachingEvaluator(@NotNull CachingEvaluator<T> clone, @NotNull OCResolveContext context) {
            this.mySymbolsWithSubstitutions = clone.mySymbolsWithSubstitutions;
            this.mySubstitutions = clone.mySubstitutions;
            this.myContext = context;
        }

        private OCTypeSubstitution getSubstitution(OCSymbol symbol) {
            return this.myContext.useFor(symbol).getSubstitution();
        }

        protected void cache(@Nullable OCSymbol symbol, @Nullable T value) {
            OCTypeSubstitution substitution = this.getSubstitution(symbol);
            this.mySymbolsWithSubstitutions.put((Pair<OCSymbol, OCTypeSubstitution>)Pair.create((Object)symbol, (Object)substitution), value);
            if (symbol != null) {
                this.mySubstitutions.add((Object)symbol, (Object)substitution);
            }
        }

        protected void remove(@Nullable OCSymbol symbol) {
            OCTypeSubstitution substitution = this.getSubstitution(symbol);
            this.mySymbolsWithSubstitutions.remove(Pair.create((Object)symbol, (Object)substitution));
            if (symbol != null) {
                this.mySubstitutions.removeAllValues((Object)symbol);
            }
        }

        protected boolean contains(@Nullable OCSymbol symbol) {
            OCTypeSubstitution substitution = this.getSubstitution(symbol);
            return this.mySymbolsWithSubstitutions.containsKey(Pair.create((Object)symbol, (Object)substitution)) || symbol != null && ((List)this.mySubstitutions.get((Object)symbol)).size() >= 450;
        }

        @Nullable
        protected T get(@Nullable OCSymbol symbol) {
            return this.mySymbolsWithSubstitutions.get(Pair.create((Object)symbol, (Object)this.getSubstitution(symbol)));
        }

        @NotNull
        public OCResolveContext getContext() {
            return this.myContext;
        }

        @Override
        @Nullable
        public T evalEnumConst(OCSymbol symbol) {
            Integer value = OCExpressionEvaluator.evaluateEnumConst(symbol, this);
            return value != null ? (T)this.evalInteger(value) : null;
        }
    }

    public static interface Evaluator<T> {
        @Nullable
        public T evalInteger(Number var1);

        @Nullable
        public T evalEnumConst(OCSymbol var1);

        @Nullable
        public T evalBool(Boolean var1);

        @Nullable
        public T evalDefault(OCExpression var1);

        @Nullable
        public T evalBinary(OCElementType var1, @Nullable T var2, @Nullable T var3);

        @Nullable
        public T evalUnary(OCElementType var1, @Nullable T var2);

        @Nullable
        public T evalConditional(T var1, Supplier<T> var2, Supplier<T> var3);

        @Nullable
        public T evalCast(OCType var1, T var2);

        @Nullable
        public T evalCall(OCCallExpressionSymbol var1);

        @Nullable
        public T evalReference(OCReferenceExpressionSymbol var1);

        @Nullable
        public T evalSizeof(OCSizeofExpressionSymbol var1);

        @Nullable
        public T evalNoexcept(OCNoexceptExpressionSymbol var1);
    }
}

