/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Commenter;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.preprocessor.OCSyntheticLeafType;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifiedNameOwner;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolNameOwner;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentsOwner;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUDLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCEmptyName;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCReferenceWithContext;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReferenceContributor;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.util.OCScopeInfo;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementUtil {
    private static final OCIntType[] NONE_DEC = new OCIntType[]{OCIntType.INT, OCIntType.LONG, OCIntType.LONGLONG, OCIntType.INT128};
    private static final OCIntType[] NONE_HEX = new OCIntType[]{OCIntType.INT, OCIntType.UINT, OCIntType.LONG, OCIntType.ULONG, OCIntType.LONGLONG, OCIntType.ULONGLONG, OCIntType.INT128, OCIntType.UINT128};
    private static final OCIntType[] U_DEC = new OCIntType[]{OCIntType.UINT, OCIntType.ULONG, OCIntType.ULONGLONG, OCIntType.UINT128};
    private static final OCIntType[] U_HEX = U_DEC;
    private static final OCIntType[] L_DEC = new OCIntType[]{OCIntType.LONG, OCIntType.LONGLONG, OCIntType.INT128};
    private static final OCIntType[] L_HEX = new OCIntType[]{OCIntType.LONG, OCIntType.ULONG, OCIntType.LONGLONG, OCIntType.ULONGLONG, OCIntType.INT128, OCIntType.UINT128};
    private static final OCIntType[] UL_DEC = new OCIntType[]{OCIntType.ULONG, OCIntType.ULONGLONG, OCIntType.INT128};
    private static final OCIntType[] UL_HEX = UL_DEC;
    private static final OCIntType[] LL_DEC = new OCIntType[]{OCIntType.LONGLONG, OCIntType.INT128};
    private static final OCIntType[] LL_HEX = new OCIntType[]{OCIntType.LONGLONG, OCIntType.ULONGLONG, OCIntType.INT128, OCIntType.UINT128};
    private static final OCIntType[] ULL_DEC = new OCIntType[]{OCIntType.ULONGLONG, OCIntType.UINT128};
    private static final OCIntType[] ULL_HEX = ULL_DEC;
    private static final TokenSet GOOD_FOR_RENAME = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.POSSIBLE_ID_NAMES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.THIS_CPP_KEYWORD})});
    private static final Predicate<PsiElement> ELEMENT_NON_WHITESPACE_CONDITION = element -> !(element instanceof OCEmptyName) && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element));

    @Contract(value="null -> null;!null -> !null")
    public static IElementType getElementType(@Nullable ASTNode node) {
        return node == null ? null : node.getElementType();
    }

    @Contract(value="null -> null;!null -> !null")
    public static IElementType getElementType(@Nullable PsiElement element) {
        return element == null ? null : OCElementUtil.getElementType(element.getNode());
    }

    @Contract(value="null -> null")
    public static IElementType getObjCKeywordElementType(@Nullable ASTNode node) {
        if (node != null && OCElementUtil.getElementType(node) == OCElementTypes.OBJC_KEYWORD) {
            ASTNode[] children = node.getChildren(OCTokenTypes.KEYWORDS_WITH_AT);
            return children.length == 1 ? children[0].getElementType() : null;
        }
        return null;
    }

    @Nullable
    public static ASTNode findObjCKeyword(@NotNull ASTNode node, @NotNull IElementType type) {
        for (ASTNode child : node.getChildren(null)) {
            if (child.getElementType() != OCElementTypes.OBJC_KEYWORD) continue;
            for (ASTNode token : child.getChildren(null)) {
                if (OCElementUtil.getElementType(token) != type) continue;
                return token;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    public static String getAlternativeCppPunctuator(@Nullable IElementType tt) {
        if (!(tt instanceof OCPunctuatorElementType)) {
            return null;
        }
        return ((OCPunctuatorElementType)tt).getCppKeyword();
    }

    @Contract(value="null, _ -> false")
    public static boolean isOneOf(@Nullable ASTNode node, PsiElement ... candidates) {
        if (node == null) {
            return false;
        }
        for (PsiElement each : candidates) {
            if (each == null || node != each.getNode()) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isMethodOrFunction(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        IElementType type = node.getElementType();
        return type == OCElementTypes.METHOD || type == OCElementTypes.FUNCTION_DEFINITION;
    }

    @Contract(value="null -> false")
    public static boolean isMethodOrFunctionBody(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        return OCElementTypes.BLOCK_STATEMENTS.contains(node.getElementType()) && OCElementUtil.isMethodOrFunction(node.getTreeParent());
    }

    @Contract(value="null -> false")
    public static boolean hasNoReturnType(@Nullable OCFunctionDeclaration declaration) {
        if (declaration == null) {
            return false;
        }
        OCTypeElement typeElement = declaration.getTypeElement();
        return typeElement == null || typeElement.isEmptyType();
    }

    @Contract(value="null -> false")
    public static boolean isOperatorDeclaration(@Nullable OCDeclarator declarator) {
        if (declarator == null) {
            return false;
        }
        return declarator.getNode().findChildByType((IElementType)OCTokenTypes.OPERATOR_CPP_KEYWORD) != null;
    }

    @Contract(value="null -> false")
    public static boolean isVariableDeclaration(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != OCElementTypes.DECLARATION) {
            return false;
        }
        ASTNode declarator = node.findChildByType((IElementType)OCElementTypes.DECLARATOR);
        return declarator != null && !OCElementUtil.isFunctionDeclaratorOrPredeclarator(node);
    }

    @Contract(value="null -> false")
    public static boolean isFunctionPredeclaration(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() == OCElementTypes.FUNCTION_DECLARATION) {
            return true;
        }
        if (node.getElementType() != OCElementTypes.DECLARATION) {
            return false;
        }
        return OCElementUtil.isFunctionPredeclarator(node.findChildByType((IElementType)OCElementTypes.DECLARATOR));
    }

    @Contract(value="null -> false")
    public static boolean isFunctionPredeclarator(@Nullable ASTNode node) {
        if (!OCElementUtil.isFunctionDeclaratorOrPredeclarator(node)) {
            return false;
        }
        ASTNode parent = node.getTreeParent();
        return parent == null || parent.getElementType() != OCElementTypes.FUNCTION_DEFINITION;
    }

    @Contract(value="null -> false")
    public static boolean isFunctionDeclaratorOrPredeclarator(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != OCElementTypes.DECLARATOR) {
            return false;
        }
        return node.findChildByType((IElementType)OCElementTypes.PARAMETER_LIST) != null;
    }

    @Contract(value="null -> false")
    public static boolean isRefToken(@Nullable IElementType type) {
        return OCTokenTypes.TYPE_MODIFIERS.contains(type);
    }

    @Contract(value="null -> null")
    public static IElementType getRefInDeclarator(@Nullable ASTNode node) {
        if (node == null) {
            return null;
        }
        IElementType type = node.getElementType();
        if (type != OCElementTypes.DECLARATOR && type != OCElementTypes.STRUCTURED_BINDING_DECLARATOR) {
            return null;
        }
        IElementType ret = OCElementUtil.getElementType(OCElementUtil.getFirstNonSpaceChild(node));
        return OCElementUtil.isRefToken(ret) ? ret : null;
    }

    @Contract(value="null -> null")
    public static ASTNode getFirstNonSpaceChild(@Nullable ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode ret = node.getFirstChildNode();
        while (ret instanceof PsiWhiteSpace) {
            ret = ret.getTreeNext();
        }
        return ret;
    }

    @Contract(value="null -> false")
    public static boolean isStructTypeDeclaration(@Nullable ASTNode node) {
        if (node == null || !OCElementTypes.STRUCTURE_TYPES.contains(node.getElementType())) {
            return false;
        }
        return node.findChildByType((IElementType)OCTokenTypes.RBRACE) != null;
    }

    @Contract(value="null -> null")
    public static String getStringLiteral(@Nullable PsiElement element) {
        OCLiteralExpression literal;
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCLiteralExpression && (literal = (OCLiteralExpression)element).isNSStringLiteral()) {
            return literal.getUnescapedLiteralText();
        }
        return null;
    }

    @Nullable
    public static OCElementTypes.SelfSuperToken getSelfSuperToken(String name, PsiElement context, @NotNull OCResolveContext resolveContext) {
        OCElementTypes.SelfSuperToken token;
        if ("self".equals(name)) {
            token = OCElementTypes.SelfSuperToken.SELF;
        } else if ("super".equals(name)) {
            token = OCElementTypes.SelfSuperToken.SUPER;
        } else {
            return null;
        }
        if (PsiTreeUtil.getContextOfType((PsiElement)context, OCMethod.class, (boolean)false) == null) {
            return null;
        }
        OCBlockExpression block = (OCBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)context, OCBlockExpression.class);
        if (block != null) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            OCResolveUtil.processLocalSymbols(name, context, (Processor<OCSymbol>)finder, false);
            OCSymbol symbol = (OCSymbol)finder.getFoundValue();
            if (symbol != null && !(symbol.getType().resolve(resolveContext) instanceof OCMagicType)) {
                return null;
            }
        }
        return token;
    }

    @Nullable
    public static Object getConstValue(IElementType tt, String text, @Nullable PsiElement element, @Nullable OCInclusionContext context, @NotNull Project project) {
        if (tt == OCTokenTypes.FAKE_TRUE) {
            return 1;
        }
        if (tt == OCTokenTypes.FAKE_FALSE) {
            return 0;
        }
        if (tt == OCTokenTypes.CHARACTER_LITERAL) {
            return OCElementUtil.parseChar(text, element, context, project);
        }
        if (tt == OCTokenTypes.STRING_LITERAL || tt == OCTokenTypes.AT) {
            return text;
        }
        if (tt == OCTokenTypes.INTEGER_LITERAL) {
            return OCElementUtil.parseInteger((String)text, (PsiElement)element, (OCInclusionContext)context, (Project)project).second;
        }
        if (tt == OCTokenTypes.FLOAT_LITERAL) {
            try {
                return Float.valueOf(Float.parseFloat(StringUtil.replace((String)text, (String)"'", (String)"")));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (tt == OCTokenTypes.TRUE_CPP_KEYWORD) {
            return Boolean.TRUE;
        }
        if (tt == OCTokenTypes.FALSE_CPP_KEYWORD) {
            return Boolean.FALSE;
        }
        if (tt == OCTokenTypes.__NULL_KEYWORD || tt == OCTokenTypes.NULL_CPP_KEYWORD) {
            return 0;
        }
        return null;
    }

    @Nullable
    private static Number parseChar(@Nullable String text, @Nullable PsiElement element, @Nullable OCInclusionContext context, @NotNull Project project) {
        PsiFile file = element == null ? null : element.getContainingFile();
        OCCharLiteral charLiteral = OCStringLiteralUtil.parseCharLiteral(text);
        boolean plainOldC = OCCodeInsightUtil.isInPlainOldC(file, context);
        OCIntType detectedType = charLiteral.getType(plainOldC);
        OCNumber parsedNumber = null;
        String chars = charLiteral.getContents(false);
        int length = chars.length();
        if (length > 0) {
            long collector = 0L;
            int bytesPerChar = detectedType.getSizeInBytes(file, context, project);
            for (int i = 0; i < length; ++i) {
                char ch = chars.charAt(i);
                collector <<= (ch & 0xFF00) != 0 ? 16 : 8;
                collector += (long)ch;
            }
            parsedNumber = OCNumber.convert(BigInteger.valueOf(collector), bytesPerChar, detectedType.isSigned());
        }
        return parsedNumber;
    }

    private static OCIntType[] candidates(boolean hex, boolean unsigned, boolean L, boolean LL) {
        if (unsigned && LL) {
            return hex ? ULL_HEX : ULL_DEC;
        }
        if (LL) {
            return hex ? LL_HEX : LL_DEC;
        }
        if (unsigned && L) {
            return hex ? UL_HEX : UL_DEC;
        }
        if (L) {
            return hex ? L_HEX : L_DEC;
        }
        if (unsigned) {
            return hex ? U_HEX : U_DEC;
        }
        return hex ? NONE_HEX : NONE_DEC;
    }

    @NotNull
    public static Pair<OCIntType, Number> parseInteger(@NotNull String text, @Nullable PsiElement element, @Nullable OCInclusionContext context, @NotNull Project project) {
        OCIntType detectedType = OCIntType.ULONGLONG;
        OCNumber parsedNumber = null;
        try {
            OCNumber.ParseInfo parseInfo = OCNumber.ParseInfo.parse(text);
            OCIntType[] intTypes = OCElementUtil.candidates(parseInfo.radix != 10, parseInfo.countU > 0, parseInfo.countL == 1, parseInfo.countL == 2);
            BigInteger bigInteger = new BigInteger(parseInfo.numbers, parseInfo.radix);
            int magBitCount = bigInteger.bitLength();
            for (OCIntType type : intTypes) {
                int bits = type.getBits(element, context, project);
                int freeBits = bits - magBitCount;
                if (freeBits <= 0 && (freeBits != 0 || type.isSigned())) continue;
                detectedType = type;
                parsedNumber = OCNumber.convert(parseInfo.negative ? bigInteger.negate() : bigInteger, bits / 8, type.isSigned());
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Pair.create((Object)detectedType, parsedNumber);
    }

    @Nullable
    public static OCType getType(@Nullable PsiElement element) {
        if (element instanceof OCTypeElement) {
            return ((OCTypeElement)element).getType().resolve(element);
        }
        if (element instanceof OCExpression) {
            return ((OCExpression)element).getResolvedType();
        }
        if (element != null && OCElementUtil.getElementType(element) == OCElementTypes.TYPE_CODE_FRAGMENT) {
            OCType type = null;
            for (PsiElement child : element.getChildren()) {
                if (child instanceof OCTypeElement) {
                    type = OCElementUtil.getType(child);
                    continue;
                }
                if (!OCElementUtil.isElementSignificant(child)) continue;
                return null;
            }
            return type;
        }
        return null;
    }

    @Nullable
    public static OCMacroCall getElementMacroCall(@Nullable PsiElement element) {
        PsiElement macroCall = OCElementUtil.getPrevSiblingOrParentSibling(element);
        while (macroCall instanceof OCMacroCall) {
            OCMacroCall node = (OCMacroCall)macroCall;
            macroCall = macroCall.getPrevSibling();
            if (node.getTextLength() <= 0) continue;
            return node;
        }
        return null;
    }

    @Contract(value="null -> null")
    public static PsiElement getPrevSiblingOrParentSibling(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling != null) {
            return prevSibling;
        }
        PsiElement parent = element.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return OCElementUtil.getPrevSiblingOrParentSibling(parent);
    }

    @Nullable
    public static PsiElement getPrevLeaf(@Nullable PsiElement node) {
        while (node != null) {
            PsiElement prev = OCElementUtil.getPrevSiblingOrParentSibling(node);
            if (prev == null) {
                return null;
            }
            PsiElement result = prev;
            for (PsiElement lastChild = prev.getLastChild(); lastChild != null; lastChild = lastChild.getLastChild()) {
                result = lastChild;
            }
            if (result instanceof LeafPsiElement) {
                return result;
            }
            node = result;
        }
        return null;
    }

    @Nullable
    public static PsiElement getNextSiblingOrParentSibling(@NotNull PsiElement element) {
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling != null) {
            return nextSibling;
        }
        PsiElement parent = element.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return OCElementUtil.getNextSiblingOrParentSibling(parent);
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSibling(PsiElement element) {
        PsiElement next;
        for (next = element.getNextSibling(); next != null && OCElementUtil.isWhitespace(next); next = next.getNextSibling()) {
        }
        return next;
    }

    @Nullable
    public static PsiElement getPrevSignificantSibling(PsiElement element) {
        PsiElement prev;
        for (prev = element.getPrevSibling(); prev != null && !OCElementUtil.isElementSignificant(prev); prev = prev.getPrevSibling()) {
        }
        return prev;
    }

    @SafeVarargs
    @Nullable
    public static PsiElement getParentOfType(@Nullable PsiFile file, @NotNull TextRange range, Class<? extends PsiElement> ... parentClasses) {
        PsiElement element;
        if (file == null) {
            return null;
        }
        for (element = file.findElementAt(range.getStartOffset()); element != null && OCElementUtil.getRangeWithMacros(element).getEndOffset() < range.getEndOffset(); element = element.getParent()) {
        }
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])parentClasses);
    }

    @Nullable
    public static <T extends PsiElement> T getTopmostParentOfTypes(@Nullable PsiElement element, Class<? extends T> ... classes) {
        PsiElement next;
        PsiElement answer = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classes);
        while ((next = PsiTreeUtil.getParentOfType((PsiElement)answer, (Class[])classes)) != null) {
            answer = next;
        }
        return (T)answer;
    }

    public static boolean isPartOfMacroSubstitution(@NotNull PsiElement element) {
        return element.getTextLength() == 0 && !(element instanceof OCSymbolHolderVirtualPsiElement);
    }

    public static boolean isSynthetic(@NotNull PsiElement element) {
        return element instanceof ForeignLeafPsiElement && ((ForeignLeafPsiElement)element).getForeignType() instanceof OCSyntheticLeafType;
    }

    public static boolean insideDirective(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, OCDirective.class) != null;
    }

    public static void replaceWithIdentifier(@Nullable PsiElement oldElement, @NotNull String newName, @NotNull PsiElement context) {
        PsiElement newElement;
        if (oldElement == null) {
            return;
        }
        IElementType oldElementType = OCElementUtil.getElementType(oldElement);
        if (!GOOD_FOR_RENAME.contains(oldElementType)) {
            return;
        }
        if (newName.equals(oldElement.getText())) {
            return;
        }
        PsiElement psiElement = ((OCFile)oldElement.getContainingFile()).isCpp() && newName.equals("this") ? OCElementFactory.create((OCElementType)OCTokenTypes.THIS_CPP_KEYWORD, context) : (newElement = oldElementType == OCTokenTypes.UDL_SUFFIX ? OCElementFactory.createUDLSuffux(newName, context) : OCElementFactory.createIdentifier(newName, context));
        if (oldElement instanceof OCMacroForeignLeafElement) {
            OCMacroRange range = OCElementUtil.getRangeInMacroCall(oldElement);
            if (range != null && range.mapsToArguments()) {
                OCChangeUtil.replaceAST(range.getFirstElement(), newElement);
            }
            OCChangeUtil.replaceAST(oldElement, (PsiElement)OCElementFactory.createMacroForeignIdentifier(newName, (OCMacroForeignLeafElement)oldElement));
        } else {
            OCChangeUtil.replaceAST(oldElement, newElement);
        }
    }

    public static void changeQualifiedName(OCNamespaceQualifierOwner element, OCQualifiedName newName) {
        PsiElement nameIdentifier;
        if (newName == OCQualifiedName.GLOBAL) {
            OCChangeUtil.clear(element);
            ASTNode parentNode = element.getParent().getNode();
            ASTNode oldColon2x = parentNode.findChildByType((IElementType)OCTokenTypes.COLON2X);
            if (oldColon2x != null) {
                CodeEditUtil.removeChild((ASTNode)parentNode, (ASTNode)oldColon2x);
            }
            return;
        }
        OCCppNamespaceQualifier oldQualifier = element.getNamespaceQualifier();
        OCQualifiedName newNameQualifier = newName.getQualifier();
        String newNameName = newName.getName();
        ASTNode elementNode = element.getNode();
        if (newNameQualifier != null) {
            if (oldQualifier != null) {
                OCElementUtil.changeQualifiedName(oldQualifier, newNameQualifier);
            } else {
                PsiElement referenceToken;
                OCCppNamespaceQualifier newQualifier = OCElementFactory.createNamespaceQualifier(newNameQualifier, element);
                PsiElement psiElement = referenceToken = element instanceof OCNamespaceQualifiedNameOwner ? ((OCNamespaceQualifiedNameOwner)element).getNameIdentifier() : ((PsiNameIdentifierOwner)element).getNameIdentifier();
                if (newQualifier != null) {
                    element.addBefore(newQualifier, referenceToken);
                }
                if (referenceToken != null && OCElementUtil.getElementType(referenceToken.getPrevSibling()) != OCTokenTypes.COLON2X) {
                    OCChangeUtil.addChild(elementNode, OCElementFactory.createColon2x(element), referenceToken.getNode());
                }
            }
        } else {
            ASTNode oldColon2x;
            if (oldQualifier != null) {
                OCChangeUtil.delete(oldQualifier);
            }
            if ((oldColon2x = elementNode.findChildByType((IElementType)OCTokenTypes.COLON2X)) != null) {
                CodeEditUtil.removeChild((ASTNode)elementNode, (ASTNode)oldColon2x);
            }
        }
        PsiElement psiElement = nameIdentifier = element instanceof OCNamespaceQualifiedNameOwner ? ((OCNamespaceQualifiedNameOwner)element).getNameIdentifier() : ((PsiNameIdentifierOwner)element).getNameIdentifier();
        if (nameIdentifier != null && newNameName != null) {
            if (!nameIdentifier.getText().equals(newNameName)) {
                OCCppNamespaceQualifier nameWithArgs = OCElementFactory.createNamespaceQualifier(newName.changeQualifier(null), element);
                OCChangeUtil.replaceAST(nameIdentifier, nameWithArgs.getNode().getChildren(null));
            } else {
                OCElementUtil.replaceWithIdentifier(nameIdentifier, newNameName, element);
            }
        }
    }

    public static int getQualifiedNameComplexity(@NotNull OCQualifiedName name) {
        return OCElementUtil.getQualifiedNameComplexity(name, 1, 1);
    }

    public static int getQualifiedNameComplexity(@NotNull OCQualifiedName name, int pricePerName, int pricePerArgument) {
        OCQualifiedName qualifier = name.getQualifier();
        int complexity = pricePerName + (qualifier != null ? OCElementUtil.getQualifiedNameComplexity(qualifier, pricePerName, pricePerArgument) : 0);
        if (name instanceof OCQualifiedNameWithArguments) {
            for (OCTypeArgument argument : ((OCQualifiedNameWithArguments)name).getArguments()) {
                complexity += pricePerArgument;
                if (!(argument instanceof OCReferenceType)) continue;
                complexity += OCElementUtil.getQualifiedNameComplexity(((OCReferenceType)argument).getReference().getQualifiedName(), pricePerName, pricePerArgument);
            }
        }
        return complexity;
    }

    public static int getSubstitutedQualifiedNameComplexity(@NotNull OCNamespaceQualifierOwner element, @NotNull OCQualifiedName newName) {
        if (element instanceof OCTemplateArgumentsOwner) {
            PsiElement nameIdentifier;
            int complexity = 1;
            OCCppNamespaceQualifier oldQualifier = element.getNamespaceQualifier();
            OCQualifiedName newNameQualifier = newName.getQualifier();
            String newNameName = newName.getName();
            if (newNameQualifier != null && oldQualifier != null) {
                complexity += OCElementUtil.getSubstitutedQualifiedNameComplexity(oldQualifier, newNameQualifier);
            }
            OCTypeArgumentList argumentList = ((OCTemplateArgumentsOwner)((Object)element)).getTemplateArgumentList();
            PsiElement psiElement = nameIdentifier = element instanceof OCNamespaceQualifiedNameOwner ? ((OCNamespaceQualifiedNameOwner)element).getNameIdentifier() : ((PsiNameIdentifierOwner)element).getNameIdentifier();
            if (nameIdentifier != null && newNameName != null) {
                complexity = nameIdentifier.getText().equals(newNameName) ? (complexity += argumentList != null ? argumentList.getArguments().size() : 0) : (complexity += newName instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)newName).getArguments().size() : 0);
            }
            return complexity;
        }
        return OCElementUtil.getQualifiedNameComplexity(newName);
    }

    public static void fillChildrenRecursive(PsiElement parent, List<PsiElement> result) {
        for (PsiElement kid = parent.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            result.add(kid);
            OCElementUtil.fillChildrenRecursive(kid, result);
        }
    }

    public static List<PsiElement> getAllChildren(PsiElement element) {
        return ContainerUtil.mapNotNull((Object[])element.getNode().getChildren(null), node -> node.getPsi());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null -> null")
    public static OCMacroRange getRangeInMacroCall(@Nullable PsiElement psiElement) {
        TextRange callTextRange;
        OCMacroCall call;
        if (psiElement instanceof OCSymbolHolderVirtualPsiElement) {
            PsiFile file = psiElement.getContainingFile();
            if (file == null) return null;
            if ((psiElement = file.findElementAt(psiElement.getTextOffset())) == null) {
                return null;
            }
        } else if (!(psiElement != null && psiElement.getFirstChild() != null && psiElement.findElementAt(0) == null || psiElement instanceof OCMacroForeignLeafElement)) {
            return null;
        }
        PsiElement leaf = psiElement;
        for (PsiElement parent = leaf.getParent(); parent != null && OCElementUtil.isPartOfMacroSubstitution(parent); parent = parent.getParent()) {
            leaf = parent;
        }
        while ((call = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)(leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf)), (Class[])new Class[]{OCMacroCall.class})) == null || call.getTextRange().isEmpty()) {
            if (leaf != null && (!(leaf instanceof LeafPsiElement) || leaf instanceof OCMacroForeignLeafElement)) continue;
            return null;
        }
        int offset = psiElement instanceof OCMacroForeignLeafElement ? psiElement.getParent().getTextOffset() : psiElement.getTextOffset();
        if (offset >= (callTextRange = call.getTextRange()).getStartOffset() && offset <= callTextRange.getEndOffset()) return OCElementUtil.getRangeInMacroCall(psiElement, call);
        return null;
    }

    public static OCMacroRange getRangeInMacroCall(@NotNull PsiElement psiElement, @NotNull OCMacroCall call) {
        int index;
        OCReferenceElement macroReferenceElement = call.getMacroReferenceElement();
        String macroName = macroReferenceElement != null ? macroReferenceElement.getCanonicalText() : null;
        PsiElement firstLeaf = PsiTreeUtil.firstChild((PsiElement)psiElement);
        PsiElement lastLeaf = PsiTreeUtil.lastChild((PsiElement)psiElement);
        OCMacroForeignLeafElement firstMacroLeaf = firstLeaf instanceof OCMacroForeignLeafElement ? (OCMacroForeignLeafElement)firstLeaf : null;
        OCMacroForeignLeafElement lastMacroLeaf = lastLeaf instanceof OCMacroForeignLeafElement ? (OCMacroForeignLeafElement)lastLeaf : null;
        int n = index = firstMacroLeaf != null ? firstMacroLeaf.getMacroArgumentIndex() : -1;
        if (lastMacroLeaf != null && index != -1 && index < call.getArguments().size() && firstMacroLeaf.getMacroName().equals(macroName) && lastMacroLeaf.getMacroName().equals(macroName) && index == lastMacroLeaf.getMacroArgumentIndex()) {
            OCMacroCallArgument argument = call.getArguments().get(index);
            OCMacroRange outer = OCElementUtil.getRangeInMacroCall(call);
            if (outer != null && outer.getMacroCall() != call && outer.mapsToArguments()) {
                return outer;
            }
            PsiElement firstElement = argument.findElementAt(firstMacroLeaf.getRangeInMacroArgument().getStartOffset());
            PsiElement secondElement = argument.findElementAt(lastMacroLeaf.getRangeInMacroArgument().getEndOffset() - 1);
            if (firstElement != null && secondElement != null) {
                return new OCMacroRange(call, firstElement, secondElement);
            }
        }
        return new OCMacroRange(call);
    }

    public static void replaceDeclarationQualifiers(PsiElement dest, PsiElement source) {
        PsiElement child = dest.getFirstChild();
        PsiElement anchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)dest.getFirstChild());
        while (child != null) {
            IElementType tt = child.getNode().getElementType();
            PsiElement nextSibling = child.getNextSibling();
            if (OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(tt) || tt == OCTokenTypes.TYPEDEF_KEYWORD || OCTokenTypes.AUTO_KEYWORDS.contains(tt)) {
                if (anchor == child) {
                    anchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextSibling);
                }
                OCChangeUtil.delete(child);
            }
            if (tt == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                anchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextSibling);
            }
            child = nextSibling;
        }
        child = source.getFirstChild();
        while (child != null) {
            PsiElement nextSibling = child.getNextSibling();
            IElementType elementType = child.getNode().getElementType();
            if (elementType == OCTokenTypes.TYPEDEF_KEYWORD) {
                dest.addBefore(child, dest.getFirstChild());
                if (nextSibling instanceof PsiWhiteSpace) {
                    OCChangeUtil.addHandlingMacros(dest, nextSibling, dest.getFirstChild().getNextSibling(), OCChangeUtil.PostponedFormatAction.NoFormat, true);
                } else if (anchor != null) {
                    OCChangeUtil.addHandlingMacros(dest, OCElementFactory.spaceFromText(source), anchor, OCChangeUtil.PostponedFormatAction.NoFormat, true);
                }
            } else if (OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(elementType) || OCTokenTypes.AUTO_KEYWORDS.contains(elementType)) {
                ASTNode lastChildNode = dest.getNode().getLastChildNode();
                if (lastChildNode != null && !(lastChildNode.getPsi() instanceof PsiWhiteSpace)) {
                    OCChangeUtil.addHandlingMacros(dest, OCElementFactory.spaceFromText(source), null, OCChangeUtil.PostponedFormatAction.NoFormat, true);
                }
                dest.addBefore(child, anchor);
                if (lastChildNode == null) {
                    OCChangeUtil.addHandlingMacros(dest.getParent(), OCElementFactory.spaceFromText(source), dest, OCChangeUtil.PostponedFormatAction.NoFormat, false);
                } else if (nextSibling instanceof PsiWhiteSpace) {
                    OCChangeUtil.addHandlingMacros(dest, nextSibling, anchor, OCChangeUtil.PostponedFormatAction.NoFormat, true);
                } else if (anchor != null) {
                    OCChangeUtil.addHandlingMacros(dest, OCElementFactory.spaceFromText(source), anchor, OCChangeUtil.PostponedFormatAction.NoFormat, true);
                }
            }
            child = nextSibling;
        }
    }

    public static void replaceComments(PsiElement dest, PsiElement source) {
        PsiElement sourceFirstChild = source.getFirstChild();
        PsiElement lastChild = null;
        for (PsiElement sourceChild = sourceFirstChild; sourceChild != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(sourceChild)); sourceChild = sourceChild.getNextSibling()) {
            lastChild = sourceChild;
        }
        if (lastChild != null) {
            dest.addRangeBefore(sourceFirstChild, lastChild, dest.getFirstChild());
        }
    }

    @NotNull
    public static String getCommentText(@NotNull PsiComment comment) {
        Language language = comment.getLanguage();
        IElementType elementType = comment.getNode().getElementType();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        String rawCommentText = comment.getText();
        String commentPrefix = "";
        String commentSuffix = "";
        if (elementType == OCTokenTypes.EOL_COMMENT) {
            commentPrefix = StringUtil.notNullize((String)commenter.getLineCommentPrefix());
        } else if (elementType == OCTokenTypes.BLOCK_COMMENT) {
            commentPrefix = StringUtil.notNullize((String)commenter.getBlockCommentPrefix());
            commentSuffix = StringUtil.notNullize((String)commenter.getBlockCommentSuffix());
        }
        if (rawCommentText.length() >= commentPrefix.length() + commentSuffix.length()) {
            rawCommentText = rawCommentText.substring(commentPrefix.length(), rawCommentText.length() - commentSuffix.length());
        }
        return rawCommentText;
    }

    public static void restoreFunction(OCFunctionDeclaration sourceFunction, OCFunctionDeclaration destFunction) {
        OCConstructorInitializationList initializationList;
        OCChangeUtil.replaceHandlingMacros(destFunction.getTypeElement(), sourceFunction.getTypeElement());
        OCChangeUtil.replaceHandlingMacros(destFunction.getParameterList(), sourceFunction.getParameterList());
        OCElementUtil.replaceDeclarationQualifiers(destFunction, sourceFunction);
        OCElementUtil.replaceDeclarationQualifiers(destFunction.getTypeElement(), sourceFunction.getTypeElement());
        if (sourceFunction instanceof OCFunctionDefinition && (initializationList = ((OCFunctionDefinition)sourceFunction).getConstructorInitializationList()) != null && destFunction instanceof OCFunctionDefinition) {
            ((OCFunctionDefinition)destFunction).setConstructorInitializationList(initializationList);
        }
    }

    @Nullable
    public static VirtualFile getFilePath(@Nullable PsiFile file) {
        return file != null ? file.getOriginalFile().getVirtualFile() : null;
    }

    public static boolean startsWithWord(String name, String word) {
        if (name.startsWith(word)) {
            if (name.length() == word.length()) {
                return true;
            }
            char nextChar = name.charAt(word.length());
            if (Character.isUpperCase(nextChar) || !Character.isLetterOrDigit(nextChar)) {
                return true;
            }
        }
        return false;
    }

    public static boolean endsWithIgnoringFirstLetterCase(String name, String suffix) {
        char nameLetter;
        if (suffix.isEmpty()) {
            return true;
        }
        if (name.length() < suffix.length()) {
            return false;
        }
        char firstSuffixLetter = Character.toLowerCase(suffix.charAt(0));
        return firstSuffixLetter == (nameLetter = Character.toLowerCase(name.charAt(name.length() - suffix.length()))) && name.endsWith(suffix.substring(1));
    }

    public static boolean isRetainMethod(OCCallable method) {
        if (method instanceof OCMethod && OCElementUtil.isRetainSelector(((OCMethod)method).getSelector())) {
            return true;
        }
        OCSymbol symbol = method != null ? method.getSymbol() : null;
        return symbol != null && symbol.hasAttribute("ns_returns_retained");
    }

    public static boolean isRetainSelector(String selector) {
        return selector.equals("retain") || OCElementUtil.startsWithWord(selector, "alloc") || OCElementUtil.startsWithWord(selector, "new") || OCElementUtil.startsWithWord(selector, "copy") || selector.endsWith("Copy");
    }

    public static boolean isReleaseSelector(String selector) {
        return selector.endsWith("release") || selector.equals("drain");
    }

    public static boolean isRetainCall(@Nullable PsiElement element, boolean checkNestedCalls) {
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCConditionalExpression) {
            OCConditionalExpression condExpr = (OCConditionalExpression)element;
            return OCElementUtil.isRetainCall(condExpr.getPositiveExpression(true), checkNestedCalls) || OCElementUtil.isRetainCall(condExpr.getNegativeExpression(), checkNestedCalls);
        }
        if (!(element instanceof OCSendMessageExpression)) {
            return false;
        }
        OCSendMessageExpression expression = (OCSendMessageExpression)element;
        if (OCElementUtil.isRetainSelector(expression.getMessageSelector())) {
            return true;
        }
        OCMethodSymbol symbol = expression.getProbableResponders().getKnownResponder();
        return symbol != null && symbol.hasAttribute("ns_returns_retained") || checkNestedCalls && !OCElementUtil.isReleaseCall(element) && OCElementUtil.isRetainCall(expression.getReceiverExpression(), true);
    }

    public static boolean isReleaseCall(@Nullable PsiElement element) {
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCConditionalExpression) {
            OCConditionalExpression condExpr = (OCConditionalExpression)element;
            return OCElementUtil.isReleaseCall(condExpr.getPositiveExpression(true)) || OCElementUtil.isReleaseCall(condExpr.getNegativeExpression());
        }
        if (!(element instanceof OCSendMessageExpression)) {
            return false;
        }
        String selector = ((OCSendMessageExpression)element).getMessageSelector();
        return OCElementUtil.isReleaseSelector(selector);
    }

    private static Predicate<PsiElement> elementSignificantCondition(boolean macroCallIsSignificant) {
        return element -> !(element instanceof OCDefineDirective) && !(element instanceof OCDirective) && (macroCallIsSignificant || !(element instanceof OCMacroCall)) && ELEMENT_NON_WHITESPACE_CONDITION.test((PsiElement)element);
    }

    public static boolean isElementSignificant(PsiElement element) {
        return OCElementUtil.elementSignificantCondition(false).test(element);
    }

    public static boolean isElementEmpty(@NotNull PsiElement element) {
        if (element instanceof LeafPsiElement) {
            return !OCElementUtil.isElementSignificant(element) || element.getTextLength() == 0;
        }
        for (PsiElement child : OCElementUtil.getAllChildren(element)) {
            if (child == null || !OCElementUtil.isElementSignificant(child)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(@NotNull PsiElement element) {
        if (element instanceof LeafPsiElement) {
            return !ELEMENT_NON_WHITESPACE_CONDITION.test(element);
        }
        for (PsiElement child : OCElementUtil.getAllChildren(element)) {
            if (child == null || !ELEMENT_NON_WHITESPACE_CONDITION.test(child)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement e1, @NotNull PsiElement e2, boolean differentMacrosAreEquivalent) {
        return OCElementUtil.areElementsEquivalent(e1, e2, differentMacrosAreEquivalent, OCResolveContext.forPsi(e1));
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement e1, @NotNull PsiElement e2, boolean differentMacrosAreEquivalent, @NotNull OCResolveContext context) {
        if (!differentMacrosAreEquivalent && OCElementUtil.isPartOfMacroSubstitution(e1)) {
            OCMacroRange range2;
            OCMacroCall macroCall2;
            if (!OCElementUtil.isPartOfMacroSubstitution(e2)) {
                return false;
            }
            OCMacroRange range1 = OCElementUtil.getRangeInMacroCall(e1);
            OCMacroCall macroCall1 = range1 != null ? range1.getMacroCall() : null;
            if (macroCall1 == null ^ (macroCall2 = (range2 = OCElementUtil.getRangeInMacroCall(e2)) != null ? range2.getMacroCall() : null) == null || !OCElementUtil.getTextWithMacros(macroCall1).equals(OCElementUtil.getTextWithMacros(macroCall2))) {
                return false;
            }
        }
        if (e1 instanceof OCElement && ((OCElement)e1).isEmpty() && e2 instanceof OCElement && ((OCElement)e2).isEmpty()) {
            return true;
        }
        if (e1.getTextLength() == 0 != (e2.getTextLength() == 0)) {
            return false;
        }
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e1, (PsiElement)e2, (ref1, ref2) -> {
            PsiElement resolved2;
            if (ref1 instanceof OCReferenceWithContext && ref2 instanceof OCReferenceWithContext) {
                Object symbol2;
                Object symbol1 = ((OCReferenceWithContext)ref1).resolveToSymbol(context);
                return Comparing.equal(symbol1, symbol2 = ((OCReferenceWithContext)ref2).resolveToSymbol(context)) ? 0 : 1;
            }
            if (ref1 instanceof OCReference && ref2 instanceof OCReference) {
                OCSymbol symbol2;
                OCSymbol symbol1 = ((OCReference)ref1).resolveToSymbol();
                return Comparing.equal((Object)symbol1, (Object)(symbol2 = ((OCReference)ref2).resolveToSymbol())) ? 0 : 1;
            }
            PsiElement resolved1 = ref1.resolve();
            return Comparing.equal((Object)resolved1, (Object)(resolved2 = ref2.resolve())) ? 0 : 1;
        }, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getText()), (Comparable)((Object)o2.getText())), OCElementUtil.elementSignificantCondition(!differentMacrosAreEquivalent), (boolean)false);
    }

    @Nullable
    public static Pair<PsiElement, PsiElement> getElementsDiff(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == element2) {
            return null;
        }
        ASTNode node1 = element1.getNode();
        ASTNode node2 = element2.getNode();
        Pair different = Pair.create((Object)element1, (Object)element2);
        if (node1.getElementType() != node2.getElementType()) {
            return different;
        }
        if (OCElementUtil.isPartOfMacroSubstitution(element1) || OCElementUtil.isPartOfMacroSubstitution(element2)) {
            return OCElementUtil.areElementsEquivalent(element1, element2, false) ? null : different;
        }
        Condition predicate = OCElementUtil.elementSignificantCondition(false)::test;
        List children1 = ContainerUtil.filter(OCElementUtil.getAllChildren(element1), (Condition)predicate);
        List children2 = ContainerUtil.filter(OCElementUtil.getAllChildren(element2), (Condition)predicate);
        if (children1.size() != children2.size()) {
            return different;
        }
        Pair<PsiElement, PsiElement> currentDiff = null;
        for (int i = 0; i < children1.size(); ++i) {
            PsiElement child2;
            PsiElement child1 = (PsiElement)children1.get(i);
            Pair<PsiElement, PsiElement> subDiff = OCElementUtil.getElementsDiff(child1, child2 = (PsiElement)children2.get(i));
            if (subDiff == null) continue;
            if (currentDiff == null) {
                currentDiff = subDiff;
                continue;
            }
            return different;
        }
        if (children1.size() == 0 && !element1.textMatches(element2)) {
            return different;
        }
        return currentDiff;
    }

    @Nullable
    public static PsiElement getPreviousNonEmptyElement(PsiElement element) {
        ASTNode node = element.getNode();
        PsiElement psiElement = node.getPsi();
        while (psiElement != null && OCElementUtil.isElementEmpty(psiElement)) {
            psiElement = (node = node.getTreePrev()) != null ? node.getPsi() : null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getNextNonEmptyElement(PsiElement element) {
        ASTNode node = element.getNode();
        PsiElement psiElement = node.getPsi();
        while (psiElement != null && OCElementUtil.isElementEmpty(psiElement)) {
            node = node.getTreeNext();
            psiElement = node.getPsi();
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getPrevLeaf(@NotNull PsiElement element, @NotNull TokenSet skipSet) {
        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
        while (skipSet.contains(OCElementUtil.getElementType(prev))) {
            prev = PsiTreeUtil.prevLeaf((PsiElement)prev);
        }
        return prev;
    }

    @Nullable
    public static PsiElement getNextLeaf(@NotNull PsiElement element, @NotNull TokenSet skipSet) {
        PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)element);
        while (skipSet.contains(OCElementUtil.getElementType(next))) {
            next = PsiTreeUtil.nextLeaf((PsiElement)next);
        }
        return next;
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceCommentLeaf(@NotNull PsiElement element) {
        return OCElementUtil.getNextLeaf(element, OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
    }

    @Nullable
    public static PsiElement getPrevNonWhitespaceCommentLeaf(@NotNull PsiElement element) {
        return OCElementUtil.getPrevLeaf(element, OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
    }

    @Nullable
    public static PsiElement getFirstNonWhitespaceCommentLeaf(@NotNull PsiElement element) {
        PsiElement next = element.getFirstChild();
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(next))) {
            next = PsiTreeUtil.nextLeaf((PsiElement)next);
        }
        return next;
    }

    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getAdjacentParentOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass) {
        if (element == null) {
            return null;
        }
        int offset = element.getTextRange().getStartOffset();
        while (element != null) {
            if (aClass.isInstance(element)) {
                return (T)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling != null && aClass.isInstance(prevSibling) && prevSibling.getTextRange().getEndOffset() == offset) {
                return (T)prevSibling;
            }
            element = element.getParent();
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T getAdjacentParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])classes);
        if (parent != null) {
            return (T)parent;
        }
        return (T)PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)element), (Class[])classes);
    }

    public static TextRange getTrimmedRange(@NotNull PsiElement element) {
        return OCElementUtil.getTrimmedRange(element.getTextRange(), element.getContainingFile());
    }

    public static TextRange getTrimmedRange(@NotNull TextRange range, @NotNull PsiFile file) {
        int start;
        String text = range.substring(file.getText());
        if (text.length() == 0 || text.length() != range.getLength()) {
            return range;
        }
        int end = text.length() - 1;
        for (start = 0; start <= end && text.charAt(start) <= ' '; ++start) {
        }
        while (start <= end && text.charAt(end) <= ' ') {
            --end;
        }
        return new TextRange(range.getStartOffset() + start, range.getEndOffset() + end - text.length() + 1);
    }

    public static TextRange getRangeInParent(ASTNode node) {
        return OCElementUtil.getRangeInParent(node.getPsi());
    }

    public static TextRange getRangeInParent(PsiElement element) {
        TextRange range = element.getTextRange();
        int parentOffset = element.getParent().getTextOffset();
        return range.isEmpty() ? range : range.shiftRight(-parentOffset);
    }

    private static boolean isCorrespondingMacroCall(@Nullable PsiElement macroCall, PsiElement element) {
        if (!(macroCall instanceof OCMacroCall)) {
            return false;
        }
        PsiElement leaf = ((OCMacroCall)macroCall).getFirstExpansionLeaf();
        return leaf != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)leaf, (boolean)false);
    }

    @NotNull
    public static String getTextWithMacros(@Nullable PsiElement element) {
        if (element == null) {
            return "";
        }
        OCMacroRange range = OCElementUtil.getRangeInMacroCall(element);
        if (range == null) {
            PsiElement macroCall = OCElementUtil.getPrevSiblingOrParentSibling(element);
            if (OCElementUtil.isCorrespondingMacroCall(macroCall, element)) {
                StringBuilder result = new StringBuilder(element.getText());
                while (OCElementUtil.isCorrespondingMacroCall(macroCall, element)) {
                    result.insert(0, macroCall.getText());
                    macroCall = OCElementUtil.getPrevSiblingOrParentSibling(macroCall);
                }
                return result.toString();
            }
            return element.getText();
        }
        TextRange textRange = range.getArgumentRange();
        String callText = range.getMacroCall().getTextWithMacros();
        if (textRange == null) {
            return callText;
        }
        textRange = textRange.shiftRight(-range.getMacroCall().getTextRange().getStartOffset());
        return textRange.substring(callText);
    }

    public static String getTextFromLeaves(@NotNull PsiElement element) {
        PsiElement curLeaf;
        PsiElement nextLeaf = PsiTreeUtil.firstChild((PsiElement)element);
        PsiElement lastLeaf = PsiTreeUtil.lastChild((PsiElement)element);
        StringBuilder builder2 = new StringBuilder();
        do {
            curLeaf = nextLeaf;
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)curLeaf);
            builder2.append(curLeaf.getText());
        } while (curLeaf != lastLeaf && nextLeaf != null);
        return builder2.toString();
    }

    @NotNull
    public static TextRange getRangeWithMacros(PsiElement element) {
        OCMacroRange range = OCElementUtil.getRangeInMacroCall(element);
        if (range == null) {
            OCMacroCall macroCall = OCElementUtil.getElementMacroCall(element);
            TextRange textRange = element.getTextRange();
            if (macroCall != null && macroCall.getTextOffset() <= textRange.getEndOffset()) {
                return new TextRange(macroCall.getTextOffset(), textRange.getEndOffset());
            }
            return textRange;
        }
        TextRange callRange = range.getMacroCall().getRangeWithMacros();
        TextRange textRange = range.getArgumentRange();
        if (textRange != null) {
            return textRange;
        }
        return callRange;
    }

    public static boolean isEqualWithMacros(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        if (element1 == null || element2 == null || !Comparing.equal(element1.getClass(), element2.getClass())) {
            return false;
        }
        if (Comparing.equal((Object)element1, (Object)element2)) {
            return true;
        }
        OCMacroRange range1 = OCElementUtil.getRangeInMacroCall(element1);
        if (range1 != null && range1.mapsToArguments()) {
            return range1.getTextRange().equals((Object)element2.getTextRange());
        }
        OCMacroRange range2 = OCElementUtil.getRangeInMacroCall(element2);
        if (range2 != null && range2.mapsToArguments()) {
            return range2.getTextRange().equals((Object)element1.getTextRange());
        }
        return false;
    }

    public static TextRange getTextRangeWithoutComments(PsiElement element) {
        PsiElement child = element.getFirstChild();
        if (child instanceof PsiComment) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child != null) {
                return new TextRange(child.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
            }
        }
        return element.getTextRange();
    }

    public static boolean isVisibilityKeyword(@Nullable ASTNode node) {
        return OCElementUtil.isOCVisibilityKeyword(node) || OCElementUtil.isCPPVisibilityKeyword(node);
    }

    @Contract(value="null->false")
    public static boolean isOCVisibilityKeyword(@Nullable ASTNode node) {
        if (node != null) {
            IElementType type = node.getElementType();
            if (type == OCElementTypes.OBJC_KEYWORD) {
                type = OCElementUtil.getObjCKeywordElementType(node);
                return OCTokenTypes.IVAR_VISIBILITY_KEYWORDS.contains(type) || OCTokenTypes.PROTOCOL_METHODS_KEYWORDS.contains(type);
            }
            if (type == OCElementTypes.OBJC_ERROR_KEYWORD) {
                return OCElementUtil.getElementType(node.getTreeParent()) == OCElementTypes.INSTANCE_VARIABLES_LIST;
            }
        }
        return false;
    }

    public static boolean isCPPVisibilityKeyword(@Nullable ASTNode node) {
        return node != null && OCTokenTypes.CPP_VISIBILITY_KEYWORDS.contains(node.getElementType());
    }

    @Nullable
    public static String getTypeTextWithModifiers(@NotNull OCDeclaration declaration) {
        List<OCDeclarator> declarators = declaration.getDeclarators();
        return declarators.size() == 1 ? OCElementUtil.getTypeTextWithModifiers(declarators.get(0)) : null;
    }

    @Nullable
    public static String getTypeTextWithModifiers(OCDeclarator declarator) {
        OCDeclaration declaration = (OCDeclaration)declarator.getParent();
        OCTypeElement typeElement = declaration.getTypeElement();
        if (typeElement != null && (declaration instanceof OCFunctionDeclaration || OCCodeInsightUtil.isSimpleDeclaration(declarator.getTextWithMacros(), declarator.getName()))) {
            return typeElement.getTextWithMacros() + declarator.getModifiersText();
        }
        return null;
    }

    @Nullable
    public static String getReturnTypeTextWithModifiers(OCFunctionSymbol symbol, @NotNull Project project) {
        OCFunctionDeclaration funDefinition = symbol.locateFunctionDefinition(project);
        return funDefinition != null ? OCElementUtil.getTypeTextWithModifiers(funDefinition) : null;
    }

    @Nullable
    public static String getReturnTypeText(OCMethodSymbol symbol, @NotNull Project project) {
        PsiElement methodDefinition = symbol.locateDefinition(project);
        OCTypeElement returnType = methodDefinition instanceof OCMethod ? ((OCMethod)methodDefinition).getReturnTypeElement() : null;
        return returnType != null ? returnType.getTextWithMacros() : null;
    }

    @Contract(value="null -> null")
    public static OCPragma getPragmaAt(@Nullable PsiElement maybePragmaOrPragmaChild) {
        if (maybePragmaOrPragmaChild == null) {
            return null;
        }
        if (maybePragmaOrPragmaChild instanceof OCPragma) {
            return (OCPragma)maybePragmaOrPragmaChild;
        }
        if (maybePragmaOrPragmaChild.getParent() instanceof OCPragma) {
            return (OCPragma)maybePragmaOrPragmaChild.getParent();
        }
        return null;
    }

    @NotNull
    public static String getLeadingCommentsAndWhitespaces(@NotNull PsiElement element, boolean skipWhitespaces) {
        OCMacroRange curRange;
        StringBuilder text = new StringBuilder();
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCMacroCall macroCall = macroRange != null ? macroRange.getMacroCall() : null;
        PsiElement prevSibling = PsiTreeUtil.prevLeaf((PsiElement)element);
        while (prevSibling != null && OCElementUtil.isElementEmpty(prevSibling) && (!OCElementUtil.isPartOfMacroSubstitution(prevSibling) || (curRange = OCElementUtil.getRangeInMacroCall(prevSibling)) == null || curRange.getMacroCall() != macroCall)) {
            if (!skipWhitespaces || !OCTokenTypes.WHITESPACES.contains(OCElementUtil.getElementType(prevSibling))) {
                text.insert(0, OCElementUtil.getTextWithMacros(prevSibling));
            }
            prevSibling = PsiTreeUtil.prevLeaf((PsiElement)prevSibling);
        }
        return text.toString();
    }

    @NotNull
    public static String getTrailingCommentsAndWhitespaces(@NotNull PsiElement element, boolean skipWhitespaces) {
        OCMacroRange curRange;
        StringBuilder text = new StringBuilder();
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCMacroCall macroCall = macroRange != null ? macroRange.getMacroCall() : null;
        PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)element);
        while (nextSibling != null && OCElementUtil.isElementEmpty(nextSibling) && (!OCElementUtil.isPartOfMacroSubstitution(nextSibling) || (curRange = OCElementUtil.getRangeInMacroCall(nextSibling)) == null || curRange.getMacroCall() != macroCall)) {
            if (!skipWhitespaces || !OCTokenTypes.WHITESPACES.contains(OCElementUtil.getElementType(nextSibling))) {
                text.append(OCElementUtil.getTextWithMacros(nextSibling));
            }
            nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
        }
        return text.toString();
    }

    @Nullable
    public static PsiReference findReferenceInMacroArgument(@Nullable PsiElement element) {
        if (element == null || OCElementUtil.getElementType(element) != OCTokenTypes.STRING_LITERAL) {
            return null;
        }
        OCMacroCallArgument argument = (OCMacroCallArgument)PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class);
        if (argument == null) {
            return null;
        }
        PsiElement macroCall = argument.getParent();
        return OCElementUtil.findReferenceInMacroCall(macroCall, element);
    }

    @Nullable
    public static PsiReference findReferenceInMacroCall(@NotNull PsiElement macroCall, @Nullable PsiElement referenceElement) {
        if (macroCall instanceof OCMacroCall) {
            Ref result = Ref.create(null);
            OCResourceReferenceContributor.processReferenceProviders((Processor<OCResourceCompletionProvider>)((Processor)provider2 -> {
                OCResourceReference ref = provider2.getReferenceByCall(macroCall, referenceElement);
                if (ref != null) {
                    result.set((Object)ref);
                    return false;
                }
                return true;
            }));
            if (!result.isNull()) {
                return (PsiReference)result.get();
            }
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static SearchScope getUseScope(@NotNull PsiElement element) {
        return OCScopeInfo.createScopeInfo(element).getSearchScope();
    }

    @NotNull
    public static String getIdentifierName(PsiElement element) {
        if (element instanceof OCEmptyName) {
            return "id";
        }
        if (element == null) {
            return "<unnamed>";
        }
        ASTNode token = element.getNode();
        if (token == null) {
            return "<unnamed>";
        }
        StringBuilder result = new StringBuilder();
        if (token.getElementType() instanceof ForeignLeafType) {
            result.append(((ForeignLeafType)token.getElementType()).getValue());
        } else if (element instanceof ForeignLeafPsiElement) {
            result.append(OCElementUtil.getTextFromLeaves(element));
        } else {
            result.append(token.getText());
        }
        if (OCElementUtil.getElementType(element) == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
            IElementType type;
            PsiElement sibling = element;
            boolean first = true;
            int parLevel = 0;
            while ((sibling = sibling.getNextSibling()) != null && (type = sibling.getNode().getElementType()) != OCElementTypes.PARAMETER_LIST) {
                if (!OCElementUtil.isElementSignificant(sibling)) continue;
                if (type == OCTokenTypes.LPAR) {
                    ++parLevel;
                } else if (type == OCTokenTypes.RPAR) {
                    if (parLevel == 0) break;
                    --parLevel;
                }
                if (first) {
                    result.setLength(0);
                    result.append(OCTokenTypes.OPERATOR_CPP_KEYWORD.getName());
                    if (type == OCTokenTypes.IDENTIFIER || type == OCElementTypes.TYPE_ELEMENT || OCTokenTypes.KEYWORDS.contains(type)) {
                        result.append(' ');
                    }
                }
                result.append(OCElementUtil.getTextFromLeaves(sibling));
                first = false;
            }
        } else {
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
            if (prevSibling != null && "~".equals(OCElementUtil.getTextFromLeaves(prevSibling))) {
                result.insert(0, OCElementUtil.getTextFromLeaves(prevSibling));
            }
        }
        return result.toString().trim();
    }

    public static String getElementDebugName(@NotNull PsiElement element) {
        String IMPL = "Impl";
        String className = element.getClass().getSimpleName();
        String string = className = className.endsWith("Impl") ? className.substring(0, className.length() - "Impl".length()) : className;
        String name = element instanceof OCDeclarator ? ((OCDeclarator)element).getSymbolName() : (element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null);
        return name != null ? className + "(" + name + ")" : className;
    }

    public static IElementType getUnwrappedTokeType(@Nullable IElementType base) {
        while (base instanceof ForeignLeafType) {
            base = ((ForeignLeafType)base).getDelegate();
        }
        return base;
    }

    public static boolean containsDirectives(@NotNull ASTNode node) {
        for (ASTNode child : node.getChildren(null)) {
            if (!OCTokenTypes.DIRECTIVES.contains(child.getElementType()) && !OCElementUtil.containsDirectives(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDirectives(@NotNull PsiElement element) {
        return OCElementUtil.containsDirectives(element.getNode());
    }

    @Nullable
    public static OCClassDeclaration<?> resolveClassDeclaration(@Nullable OCSymbol symbol, Project project) {
        if (symbol == null) {
            return null;
        }
        PsiElement element = symbol.locateDefinition(project);
        return element instanceof OCClassDeclaration ? (OCClassDeclaration)element : null;
    }

    @Nullable
    public static TextRange getUserVisibleRangeInDocument(@NotNull PsiElement element) {
        TextRange range;
        OCMacroRange rangeInMacroCall = OCElementUtil.getRangeInMacroCall(element);
        if (rangeInMacroCall == null) {
            LeafElement fl = TreeUtil.findFirstLeaf((ASTNode)element.getNode());
            ASTNode ll = TreeUtil.findLastLeaf((ASTNode)element.getNode());
            if (fl != null && fl.getPsi() instanceof OCMacroForeignLeafElement || ll != null && ll.getPsi() instanceof OCMacroForeignLeafElement) {
                return null;
            }
            range = OCElementUtil.getRangeWithMacros(element);
        } else {
            range = rangeInMacroCall.mapsToArguments() ? rangeInMacroCall.getTextRange() : null;
        }
        return range;
    }

    public static boolean isEssentialNode(@NotNull PsiElement element) {
        return !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element)) && !element.getTextRange().isEmpty() && !(element instanceof OCPragma);
    }

    @Contract(value="null -> null;!null -> !null")
    @Nullable
    public static <T extends PsiElement> SmartPsiElementPointer<T> createPsiElementPointer(@Nullable T element) {
        if (element == null) {
            return null;
        }
        for (PsiElement child : element.getChildren()) {
            if (!child.getTextRange().equals((Object)element.getTextRange()) || !child.getClass().equals(element.getClass())) continue;
            return OCElementUtil.createPsiElementPointer(child);
        }
        return SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element, element.getContainingFile());
    }

    @Nullable
    public static <T extends PsiElement> T getPsiElementByPointer(@Nullable SmartPsiElementPointer<T> pointer) {
        PsiElement element;
        PsiElement psiElement = element = pointer != null ? pointer.getElement() : null;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent == null || parent.getClass() != element.getClass() || !parent.getTextRange().equals((Object)element.getTextRange())) {
                return (T)element;
            }
            element = parent;
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isMissingSemicolonError(@Nullable PsiElement psiElement) {
        return OCElementUtil.isErrorWithTextAtEnd(psiElement, "Missing ';'") || OCElementUtil.isErrorWithTextAtEnd(psiElement, "Expecting ';'");
    }

    @Contract(value="null -> false")
    public static boolean isMissingRParError(@Nullable PsiElement psiElement) {
        return OCElementUtil.isErrorWithTextAtEnd(psiElement, "Missing ')'") || OCElementUtil.isErrorWithTextAtEnd(psiElement, "Expecting ')'") || OCElementUtil.isErrorWithTextAtEnd(psiElement, "',' or ')' expected");
    }

    @Contract(value="null -> false")
    public static boolean isMissingCommaError(@Nullable PsiElement psiElement) {
        return OCElementUtil.isErrorWithTextAtEnd(psiElement, "Expecting ','");
    }

    @Contract(value="null -> false")
    public static boolean isIncompleteExpressionError(@Nullable PsiElement psiElement) {
        return OCElementUtil.isErrorWithTextAtEnd(psiElement, "Expression expected") || OCElementUtil.isErrorWithTextAtEnd(psiElement, "Declaration or expression expected") || OCElementUtil.isErrorWithTextAtEnd(psiElement, "Unexpected end of file");
    }

    @Contract(value="null, _ -> false")
    public static boolean isErrorWithTextAtEnd(@Nullable PsiElement psiElement, String suffix) {
        return psiElement instanceof PsiErrorElement && ((PsiErrorElement)psiElement).getErrorDescription().endsWith(suffix);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement getNextSiblingOfAnyType(@Nullable PsiElement sibling, @NotNull TokenSet types) {
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!types.contains(OCElementUtil.getElementType(child))) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement element) {
        return element instanceof OCSymbolNameOwner ? ((OCSymbolNameOwner)element).getSymbolName() : (element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement findRenameTargetDefinition(@Nullable PsiElement element, boolean toChangeSignature) {
        OCElement context = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCBlockStatement.class, OCCallable.class, OCConstructorFieldInitializer.class, OCUDLiteralExpression.class, OCCppNewExpression.class, OCCallExpression.class, OCSendMessageExpression.class, OCSelectorExpression.class});
        if (context instanceof OCBlockStatement) {
            return null;
        }
        return OCElementUtil.substituteNamedElementToRename(context, toChangeSignature);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement substituteNamedElementToRename(@Nullable PsiElement context, boolean toChangeSignature) {
        if (context instanceof OCCallExpression) {
            OCExpression function = ((OCCallExpression)context).getFunctionReferenceExpression();
            if (function instanceof OCReferenceExpression) {
                return OCElementUtil.fromRef(((OCReferenceExpression)function).getReferenceElement(), toChangeSignature);
            }
            if (function instanceof OCQualifiedExpression) {
                return OCElementUtil.fromRef(function.getReference(), toChangeSignature);
            }
            return null;
        }
        if (context instanceof OCCppNewExpression) {
            return OCElementUtil.fromRef(((OCCppNewExpression)context).getReferenceElement(), false);
        }
        if (context instanceof OCConstructorFieldInitializer) {
            return OCElementUtil.fromRef(((OCConstructorFieldInitializer)context).getReferenceElement(), false);
        }
        if (context instanceof OCSendMessageExpression || context instanceof OCSelectorExpression) {
            OCPolyVariantReference reference = (OCPolyVariantReference)context.getReference();
            if (reference == null) {
                return null;
            }
            List symbols = reference.resolveToSymbols();
            if (symbols.size() == 0) {
                return null;
            }
            return ((OCMethodSymbol)symbols.iterator().next()).locateDefinition(context.getProject());
        }
        if (context instanceof OCCallable) {
            if (OCElementUtil.skipUnsupportedOperators(context, toChangeSignature)) {
                return null;
            }
            OCBlockStatement body = ((OCCallable)context).getBody();
            if (body == null || !body.getTextRange().contains(context.getTextOffset())) {
                return toChangeSignature && OCElementUtil.getElementType(context) == OCElementTypes.FUNCTION_KR_DEFINITION ? null : context;
            }
            return null;
        }
        if (context instanceof OCUDLiteralExpression) {
            if (toChangeSignature) {
                return null;
            }
            return OCElementUtil.fromRef(context.getReference(), false);
        }
        return context;
    }

    public static boolean skipUnsupportedOperators(@NotNull PsiElement context, boolean toChangeSignature) {
        return context instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)context).isOperator() && (toChangeSignature || !((OCFunctionDeclaration)context).isUDL());
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static PsiElement fromRef(@Nullable PsiReference reference, boolean toChangeSignature) {
        if (reference != null) {
            OCSymbol symbol;
            PsiElement declarator = reference.resolve();
            if (declarator instanceof OCDeclarator) {
                PsiElement functionDeclaration = ((OCDeclarator)declarator).getExtendedContext();
                if (!(!(functionDeclaration instanceof OCFunctionDeclaration) || OCElementUtil.skipUnsupportedOperators(functionDeclaration, toChangeSignature) || toChangeSignature && OCElementUtil.getElementType(functionDeclaration) == OCElementTypes.FUNCTION_KR_DEFINITION)) {
                    return functionDeclaration;
                }
            } else if (reference instanceof OCReference && (symbol = ((OCReference)reference).resolveToSymbol()) != null) {
                return new OCSymbolHolderVirtualPsiElement(symbol, reference.getElement().getProject());
            }
        }
        return null;
    }

    public static boolean hasSyntheticIdentifier(@NotNull PsiElement element) {
        if (element instanceof PsiNameIdentifierOwner) {
            PsiElement id = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            return id == null || OCElementUtil.isSynthetic(id);
        }
        return false;
    }

    @Nullable
    public static PsiFile getContainingFileSkippingFragments(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        while (file instanceof OCCodeFragment) {
            PsiElement context = file.getContext();
            if (context == null) {
                return file;
            }
            file = context.getContainingFile();
        }
        return file;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        PsiFile psiFile = OCElementUtil.getContainingFileSkippingFragments(element);
        return OCFileUtil.getVirtualFile(psiFile);
    }
}

