/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCUDLiteralExpressionImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCElementFactory {
    private static final Logger LOG = Logger.getInstance(OCElementFactory.class);

    private OCElementFactory() {
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@NlsSafe String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        return OCElementFactory.declarationStatement(null, name, type, initializer, null, null, context);
    }

    @NotNull
    public static OCDeclaration declaration(@NlsSafe String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        return OCElementFactory.declarationStatement(null, name, type, initializer, null, null, context).getDeclaration();
    }

    @NotNull
    public static OCDeclaration declaration(@NlsSafe @Nullable String modifier, String name, OCType type, PsiElement context) {
        return OCElementFactory.declarationStatement(modifier, name, type, null, null, null, context).getDeclaration();
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@NlsSafe @Nullable String modifier, @NlsSafe String name, OCType type, @Nullable OCExpression initializer, @Nullable OCCompoundInitializer initializerList, @Nullable OCArgumentList argumentList, @NotNull PsiElement context) {
        Object declText = OCElementFactory.declarationText(modifier != null ? Collections.singletonList(modifier) : Collections.emptyList(), name, type, initializer != null ? "0" : null, context, null, false);
        if (initializer == null) {
            if (initializerList != null) {
                declText = (String)declText + "{}";
            } else if (argumentList != null) {
                declText = (String)declText + "(0)";
            }
        }
        OCDeclarationStatement statement = (OCDeclarationStatement)OCElementFactory.statementFromText((String)declText, context, true);
        OCDeclarator declarator = statement.getDeclaration().getDeclarators().get(0);
        if (initializer != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getInitializer(), initializer);
        } else if (initializerList != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getInitializerList(), initializerList);
        } else if (argumentList != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getArgumentList(), argumentList);
        }
        return statement;
    }

    @NotNull
    public static OCDeclaration declarationFromText(@NlsSafe @NotNull String text, PsiElement context) {
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context);
    }

    @NotNull
    public static OCDeclaration declarationFromText(@NlsSafe @NotNull String text, PsiElement context, boolean reformat) {
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context, reformat);
    }

    @NotNull
    public static String declarationText(@NlsSafe String name, OCType type, @NotNull PsiElement context) {
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, null, false);
    }

    @NotNull
    public static String declarationText(@NlsSafe String name, OCType type, String typeNameHint, @Nullable String initializerText, @NotNull PsiElement context) {
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, initializerText, context, typeNameHint, false);
    }

    @NotNull
    public static OCDeclaration declarationByNameAndType(@NlsSafe String name, OCType type, PsiElement context) {
        return OCElementFactory.declarationStatement(name, type, null, context).getDeclaration();
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationFromText(@NlsSafe String text, @NotNull PsiElement context) {
        return ((OCFunctionDefinition)OCElementFactory.topLevelDeclarationFromText("void f(" + text + "){}", context)).getParameterList().getParameterDeclarations().get(0);
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationByNameAndType(@NlsSafe String name, OCType type, @Nullable OCExpression defaultValue, PsiElement context) {
        String typeNameHint = null;
        if (type instanceof OCAutoType) {
            OCAutoType autoType = (OCAutoType)type;
            OCType incompleteType = autoType.getIncompleteType();
            typeNameHint = incompleteType != null ? incompleteType.getName() : autoType.getName();
        }
        OCParameterDeclaration paramDeclaration = OCElementFactory.paramDeclarationFromText(OCElementFactory.declarationText(Collections.emptyList(), name, type, defaultValue != null ? "0" : null, context, typeNameHint, false), context);
        if (defaultValue != null) {
            OCChangeUtil.replaceHandlingMacros(paramDeclaration.getDeclarator().getInitializer(), defaultValue);
        }
        return paramDeclaration;
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context) {
        return OCElementFactory.propertyDeclaration(name, type, context, null, false);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly) {
        return OCElementFactory.propertyDeclaration(name, type, context, semantics, readonly, null);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly, @NlsSafe @Nullable String additionalAttributes) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), OCCodeStyleSettings.class);
        return OCElementFactory.propertyDeclaration(name, type, context, semantics, settings == null || settings.PROPERTY_NONATOMIC, readonly, additionalAttributes);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean nonatomic, boolean readonly, @NlsSafe @Nullable String additionalAttributes) {
        ArrayList<@NlsSafe String> attributes = new ArrayList<String>();
        if (nonatomic) {
            attributes.add("nonatomic");
        }
        if (readonly) {
            attributes.add("readonly");
        }
        if (semantics == null && type.isPointerToObjectCompatible()) {
            semantics = OCPropertySymbolImpl.getDefaultSemanticsForType(type, context);
        }
        if (semantics == OCPropertySymbol.PropertySemantics.ASSIGN) {
            attributes.add("assign");
        } else if (semantics == OCPropertySymbol.PropertySemantics.WEAK) {
            attributes.add("weak");
        } else if (type.isPointerToObjectCompatible() && !readonly) {
            if (semantics == OCPropertySymbol.PropertySemantics.STRONG) {
                attributes.add("strong");
            } else if (semantics == OCPropertySymbol.PropertySemantics.RETAIN) {
                attributes.add("retain");
            } else if (semantics == OCPropertySymbol.PropertySemantics.COPY) {
                attributes.add("copy");
            }
        }
        @NlsSafe StringBuilder attributesText = new StringBuilder();
        if (!attributes.isEmpty()) {
            attributesText.append('(');
            attributesText.append(StringUtil.join(attributes, (String)","));
            attributesText.append(')');
        }
        if (!StringUtil.isEmpty((String)additionalAttributes)) {
            if (attributesText.length() > 0) {
                attributesText.append(' ');
            }
            attributesText.append(additionalAttributes);
            attributesText.append(' ');
        }
        String text = "@interface c @property " + attributesText + OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, null, true) + "; @end";
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0);
    }

    @NotNull
    public static OCDeclaration enumConst(@NlsSafe String name, PsiElement context) {
        return ((OCEnum)OCElementFactory.typeElementFromText("enum { " + name + "}", context).getFirstChild()).getFields().get(0);
    }

    @NotNull
    public static OCExpression booleanConstant(boolean value, @NotNull OCResolveContext context) {
        String constant = OCIntType.getAppropriateBool(context.isObjc()).getValue(value, context);
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(constant, context.getProject(), context.getElement(), false, false), OCExpression.class);
    }

    @NotNull
    public static OCSendMessageExpression sendMessageExpression(List<@NlsSafe String> paramStubs, PsiElement context) {
        StringBuilder text = new StringBuilder("[ 0 ");
        for (String paramStub : paramStubs) {
            text.append(paramStub).append(' ');
        }
        text.append("]");
        return (OCSendMessageExpression)OCElementFactory.expressionFromText(text.toString(), context);
    }

    @NotNull
    public static OCCompoundInitializer braceInitializer(@NotNull @NlsSafe String typeName, @NotNull List<OCExpression> args, @NotNull PsiElement context) {
        String argList = StringUtil.join(args, PsiElement::getText, (String)",");
        OCDeclaration declaration = OCElementFactory.declarationFromText(typeName + " tmp{" + argList + "};", context);
        OCDeclarator declarator = declaration.getDeclarators().get(0);
        return (OCCompoundInitializer)PsiTreeUtil.getChildOfType((PsiElement)declarator, OCCompoundInitializer.class);
    }

    @NotNull
    public static OCCallExpression callExpression(@Nullable @NlsSafe String functionName, List<String> paramStubs, PsiElement context) {
        if (functionName == null || functionName.isEmpty()) {
            functionName = "__empty";
        }
        StringBuilder text = new StringBuilder(functionName);
        text.append('(');
        boolean isFirst = true;
        for (String paramStub : paramStubs) {
            if (!isFirst) {
                text.append(',');
            }
            text.append(paramStub);
            isFirst = false;
        }
        text.append(')');
        return (OCCallExpression)OCElementFactory.expressionFromText(text.toString(), context);
    }

    @NotNull
    public static OCInterface interfaceByName(@NlsSafe String name, PsiElement context) {
        return (OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface " + name + " @end", context, true);
    }

    @NotNull
    public static OCMethod methodFromText(@NlsSafe String text, PsiElement context, boolean reformat) {
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface i " + text + " @end", context, reformat)).getMethods().get(0);
    }

    @NotNull
    public static OCDefineDirective macroDeclarationFromText(@NlsSafe String name, @NlsSafe String defaultValue, PsiFile file) {
        return (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText("#define " + name + " " + defaultValue, (PsiElement)file);
    }

    @NotNull
    public static OCMethod methodFromSignature(@NlsSafe @NotNull String signature2, @NotNull PsiElement context, boolean needBody, boolean reformat) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), OCCodeStyleSettings.class);
        String semicolon = settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "";
        return OCElementFactory.methodFromText(signature2 + (String)(needBody ? semicolon + "{\n}" : ";"), context, reformat);
    }

    @NotNull
    public static OCUnaryExpression unaryExpression(PsiElement operand, OCElementType operator) {
        OCUnaryExpression expression = (OCUnaryExpression)OCElementFactory.expressionFromText(operator.getName() + " a", operand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getOperand(), operand);
        return expression;
    }

    @NotNull
    public static PsiElement createUDLSuffux(@NlsSafe String name, PsiElement context) {
        OCUDLiteralExpressionImpl expression = (OCUDLiteralExpressionImpl)OCElementFactory.expressionFromText("\"\"" + name, context, false);
        return expression.getNameIdentifier();
    }

    @NotNull
    public static OCBinaryExpression binaryExpression(PsiElement leftOperand, PsiElement rightOperand, OCElementType operator) {
        OCBinaryExpression expression = (OCBinaryExpression)OCElementFactory.expressionFromText("a " + operator.getName() + " b", leftOperand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getLeft(), leftOperand);
        OCChangeUtil.replaceHandlingMacros(expression.getRight(), rightOperand);
        return expression;
    }

    @NotNull
    public static OCConditionalExpression conditionalExpression(@NotNull OCExpression condition, @NotNull OCExpression thenExpression, @NotNull OCExpression elseExpression) {
        OCConditionalExpression conditionalExpression = (OCConditionalExpression)OCElementFactory.expressionFromText("1 ? 2 : 3", condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getCondition(), condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getPositiveExpression(false), thenExpression);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getNegativeExpression(), elseExpression);
        return conditionalExpression;
    }

    @NotNull
    public static PsiElement binaryOperatorFromText(@NlsSafe String operator, PsiElement context) {
        return ((OCBinaryExpression)OCElementFactory.expressionFromText("a" + operator + "b", context)).getOperationSignNode().getPsi();
    }

    @NotNull
    public static ASTNode typeModifierFromText(@NlsSafe String modifier, PsiElement context) {
        return OCElementFactory.typeElementFromText(modifier + " int", context).getNode().getFirstChildNode();
    }

    @NotNull
    public static PsiElement ivarScopeSpecifier(OCVisibility scope, PsiElement context) {
        OCInstanceVariablesList clazz = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c { @" + scope + "} #end", context)).getInstanceVariablesList();
        for (PsiElement kid = clazz.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (OCVisibility.getVisibilityFromElement(kid) != scope) continue;
            return kid;
        }
        return null;
    }

    @NotNull
    public static OCInstanceVariablesList instanceVariableList(PsiElement context) {
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c {} @end", context)).getInstanceVariablesList();
    }

    @NotNull
    public static OCDeclaration constructorFromText(@NlsSafe String text, PsiElement context) {
        return OCElementFactory.constructorFromText(text, context, false);
    }

    @NotNull
    public static OCDeclaration constructorFromText(@NlsSafe String text, PsiElement context, boolean reformat) {
        String name = text.substring(0, text.indexOf(40));
        OCTypeElement type = OCElementFactory.typeElementFromTextOrNull("struct " + name + " { " + text + ";}", context, reformat);
        OCStruct struct = (OCStruct)type.getFirstChild();
        return (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)struct, OCFunctionDeclaration.class);
    }

    @NotNull
    public static OCConstructorInitializationList constructorInitializationList(OCElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : y(1) {}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCChangeUtil.delete(list.getInitializers().get(0));
        return list;
    }

    @NotNull
    public static OCConstructorFieldInitializer constructorFieldInitializerFromText(@NlsSafe String text, PsiElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : " + text + "{}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        return list.getInitializers().get(0);
    }

    @NotNull
    public static OCPropertyAttributesList propertyAttributeList(OCPropertySymbol.PropertyAttribute attribute, @NlsSafe @Nullable String value, PsiElement context) {
        String text = "@interface c @property (" + attribute.getTokenName() + (String)(value != null ? "=" + value : "") + ") int x; @end";
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0).getPropertyAttributesList();
    }

    @NotNull
    public static OCSynthesizePropertiesList synthesizeList(@NlsSafe String myKeyword, @NlsSafe String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i " + myKeyword + " " + property + (String)(ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        return (OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class);
    }

    @NotNull
    public static OCSynthesizeProperty synthesize(@NlsSafe String property, @NlsSafe @Nullable String ivar, PsiElement context) {
        String text = "@implementation i @synthesize " + property + (String)(ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        return ((OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class)).getProperties().get(0);
    }

    @NotNull
    private static String declaratorText(@NlsSafe String name, OCType type, @NotNull PsiElement context, boolean eraseARCAttributes) {
        if ("<unnamed>".equals(name)) {
            name = "";
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (type.getAliasName() == null) {
            if (OCElementFactory.isDeclaratorParenthesesRequired(type)) {
                return OCElementFactory.declaratorTextWithParentheses((String)name, type, context, eraseARCAttributes);
            }
            if (type instanceof OCArrayType) {
                OCArrayType arrayType = (OCArrayType)type;
                return OCElementFactory.arrayDeclaratorText((String)name, arrayType, context, eraseARCAttributes);
            }
            if (type instanceof OCPointerType) {
                OCPointerType pointerType = (OCPointerType)type;
                if (!(pointerType.getRefType() instanceof OCIdType)) {
                    name = (type instanceof OCBlockPointerType ? "^" : "*") + (pointerType.isConst() ? " const " : "") + (pointerType.isVolatile() ? " volatile " : "") + (String)name;
                }
                return (String)(!eraseARCAttributes && pointerType.getARCAttribute() != null ? pointerType.getARCAttribute().getTokenName() + " " : "") + OCElementFactory.declaratorText((String)name, pointerType.getRefType(), context, eraseARCAttributes);
            }
            if (type instanceof OCFunctionType) {
                OCFunctionType funType = (OCFunctionType)type;
                StringBuilder b = new StringBuilder();
                b.append(funType.getReturnType().getBestNameInContext(resolveContext));
                b.append(' ');
                if (((String)name).startsWith("(")) {
                    b.append((String)name);
                } else {
                    b.append("(").append((String)name).append(")");
                }
                b.append(OCTypeNameVisitor.getFunctionSignature(resolveContext, funType, "", false, null));
                return b.toString();
            }
        }
        return type.getBestNameInContext(resolveContext) + " " + (String)name;
    }

    @NotNull
    private static String declaratorTextWithParentheses(@NlsSafe String name, @NotNull OCType type, @NotNull PsiElement context, boolean eraseARCAttributes) {
        boolean isVariadic = false;
        if (type instanceof OCVariadicType) {
            type = ((OCVariadicType)type).getUnderlyingType();
            isVariadic = true;
        }
        StringBuilder pointerOrRefBuilder = new StringBuilder();
        while (type instanceof OCCppReferenceType || type.getClass().equals(OCPointerType.class)) {
            StringBuilder builder2 = new StringBuilder();
            if (type instanceof OCCppReferenceType) {
                builder2.append(((OCCppReferenceType)type).isRvalueRef() ? "&&" : "&");
                type.getCVQualifiers().appendCVQualifiers(builder2);
                type = ((OCCppReferenceType)type).getRefType();
            } else {
                builder2.append("*");
                type.getCVQualifiers().appendCVQualifiers(builder2);
                type = ((OCPointerType)type).getRefType();
            }
            pointerOrRefBuilder.insert(0, builder2);
        }
        return OCElementFactory.declaratorText("(" + pointerOrRefBuilder + (isVariadic ? "..." : "") + name + ")", type, context, eraseARCAttributes);
    }

    @NotNull
    private static String arrayDeclaratorText(@NlsSafe String name, @NotNull OCArrayType arrayType, @NotNull PsiElement context, boolean eraseARCAttributes) {
        return OCElementFactory.declaratorText(name + " [" + OCElementFactory.getArrayLength(arrayType, context) + "]", arrayType.getRefType(), context, eraseARCAttributes);
    }

    @NlsSafe
    private static String getArrayLength(@NotNull OCArrayType arrayType, @NotNull PsiElement context) {
        String name;
        if (!arrayType.hasLength()) {
            return "";
        }
        int length = arrayType.getLength(OCResolveContext.forPsi(context));
        if (length != -1) {
            return Integer.toString(length);
        }
        OCExpressionSymbol arrayLengthSymbol = arrayType.getLengthSymbol();
        if (arrayLengthSymbol instanceof OCReferenceExpressionSymbol && !"<unnamed>".equals(name = arrayLengthSymbol.getName()) && StringUtil.isNotEmpty((String)name)) {
            return name;
        }
        return "";
    }

    @NotNull
    public static String declarationText(@NotNull List<@NlsSafe String> modifiers, @NlsSafe String name, OCType type, @NlsSafe @Nullable String initializerText, @NotNull PsiElement context, @NlsSafe @Nullable String typeNameHint, boolean eraseARCAttributes) {
        if (type instanceof OCFunctionType && type.getAliasName() == null) {
            type = OCPointerType.to(type);
        }
        if (type == null) {
            return "";
        }
        boolean isUnnamed = "<unnamed>".equals(name) || name.isEmpty();
        StringBuilder b = new StringBuilder();
        for (String modifier : modifiers) {
            b.append(modifier).append(' ');
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (OCElementFactory.isDeclaratorParenthesesRequired(type) || type instanceof OCPointerType && type.getAliasName() == null) {
            b.append(OCElementFactory.declaratorText(name, type, context, eraseARCAttributes));
        } else {
            if (type instanceof OCUnknownType) {
                b.append(resolveContext.isObjc() ? "id" : "int");
            } else {
                b.append(type.getBestNameInContext(resolveContext));
            }
            if (!isUnnamed) {
                b.append(' ').append(name);
            }
        }
        Object declarationText = b.toString();
        if (typeNameHint != null && OCCodeInsightUtil.isSimpleDeclaration(b.toString(), name) && modifiers.isEmpty() && type.equalsAfterResolving(typeNameHint, resolveContext)) {
            declarationText = isUnnamed ? typeNameHint : typeNameHint + " " + name;
        }
        if (initializerText != null) {
            return (String)declarationText + "=" + initializerText;
        }
        return declarationText;
    }

    @NotNull
    public static PsiElement createIdentifier(@NlsSafe @NotNull String name, @NotNull PsiElement context) {
        List<OCDeclarator> declarators;
        OCCodeFragment fragment = OCElementFactory.codeFragment("int " + name, context.getProject(), context, false, false);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)fragment, OCElement.class);
        List<OCDeclarator> list = declarators = declaration != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name);
        }
        return declarators.get(0).getNameIdentifier();
    }

    @NotNull
    public static OCMacroForeignLeafElement createMacroForeignIdentifier(@NlsSafe @NotNull String name, @NotNull OCMacroForeignLeafElement sample) {
        List<OCDeclarator> declarators;
        OCCodeFragment fragment = OCElementFactory.codeFragment("#define M(x) x\nint M(" + name + ")", sample.getProject(), null, false, false);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)fragment, OCDeclaration.class);
        List<OCDeclarator> list = declarators = declaration != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name);
        }
        OCMacroForeignLeafElement identifier = (OCMacroForeignLeafElement)declarators.get(0).getNameIdentifier();
        identifier.copyFromElement(sample);
        return identifier;
    }

    @Nullable
    public static OCCppNamespaceQualifier createNamespaceQualifier(OCQualifiedName name, PsiElement context) {
        String nameText = name.getFullName(OCResolveContext.forPsi(context));
        if (!nameText.isEmpty()) {
            OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct " + nameText + "::XXXX {}", context, true).getTypeElement().getFirstChild();
            return struct.getNamespaceQualifier();
        }
        return null;
    }

    @NotNull
    public static ASTNode createColon2x(PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct A::B{}", context).getTypeElement().getFirstChild();
        return struct.getNode().findChildByType((IElementType)OCTokenTypes.COLON2X);
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.topLevelDeclarationFromText(text, context, false);
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        PsiElement child = element.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof OCMacroCall) {
            child = child.getNextSibling();
        }
        return child;
    }

    @NotNull
    public static OCTypeElement typeElementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        OCTypeElement typeElement = OCElementFactory.typeElementFromTextOrNull(text, context, true);
        return typeElement != null ? typeElement : new OCEmptyTypeElement(context);
    }

    @Nullable
    public static OCTypeElement typeElementFromTextOrNull(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean formatToCodestyle) {
        return (OCTypeElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.typeCodeFragment(text, context.getProject(), context, false, formatToCodestyle), OCTypeElement.class);
    }

    @Nullable
    public static OCReferenceElement referenceElementFromText(@NlsSafe @NotNull String name, @NotNull PsiElement context, boolean formatToCodestyle) {
        return (OCReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionFromText(name, context, formatToCodestyle), OCReferenceElement.class);
    }

    @Nullable
    public static OCExpression expressionFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.expressionFromText(text, context, false);
    }

    @Nullable
    public static OCExpression expressionFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(text, context.getProject(), context, false, reformat), OCExpression.class);
    }

    public static OCStatement statementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.statementFromText(text, context, false);
    }

    public static OCStatement statementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        text = "void _______dummy(){" + (String)text + ";}";
        OCCodeFragment element = OCElementFactory.codeFragment((String)text, context.getProject(), context, false, reformat);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCFunctionDefinition.class);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCBlockStatement.class);
        return (OCStatement)PsiTreeUtil.getChildOfType((PsiElement)element, OCStatement.class);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NonNls @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean reformat) {
        return OCElementFactory.codeFragment(text, project, context, OCTokenTypes.OC_FILE, physical, reformat);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull CharSequence text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle, OCLanguageKind kind) {
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, kind);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragmentCpp(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, OCElementFactory.getLanguageKindFromContext(context));
    }

    @NotNull
    public static OCCodeFragment expressionOrStatementsCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.typeCodeFragment(text, context.getProject(), context, true, false);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.TYPE_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment qualifiedIdCodeFragment(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.codeFragment(text, context.getProject(), context, OCElementTypes.QUALIFIED_ID_CODE_FRAGMENT, true, false);
    }

    public static OCCodeFragment getTypeCodeFragmentInWriteAction(@NlsSafe String text, @NotNull Project project, @Nullable PsiElement context) {
        return (OCCodeFragment)WriteCommandAction.writeCommandAction((Project)project).compute(() -> OCElementFactory.typeCodeFragment(text, project, context, true, true));
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project, context, type, physical, formatToCodestyle, OCElementFactory.getLanguageKindFromContext(context));
    }

    @NotNull
    public static OCLanguageKind getLanguageKindFromContext(@Nullable PsiElement context) {
        PsiFile file;
        if (context != null && (file = context.getContainingFile()) instanceof OCFile) {
            OCLanguageKind kind = ((OCFile)file).getKind();
            return CLanguageKind.find((boolean)kind.isObjC(), (boolean)kind.isCpp(), (boolean)kind.isCuda());
        }
        return CLanguageKind.maxLanguage();
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull CharSequence text, @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle, @NotNull OCLanguageKind kind) {
        if (context == null && formatToCodestyle) {
            OCLog.LOG.warn("Formatting of code fragment without context is deprecated!");
        }
        OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(project, kind, text, physical, (IElementType)type);
        if (context != null && context.isValid()) {
            fragment.setContext(context);
        }
        Application app = ApplicationManager.getApplication();
        if (formatToCodestyle) {
            if (app.isWriteAccessAllowed() || !physical) {
                PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)fragment));
            } else {
                LOG.error("Write access is required");
            }
        }
        return fragment;
    }

    @NotNull
    public static PsiElement create(@NotNull OCElementType type, @NotNull PsiElement context) {
        OCCodeFragment fragment = OCElementFactory.codeFragment(type.getName(), context.getProject(), context, true, false);
        return PsiTreeUtil.findChildOfType((PsiElement)fragment, LeafPsiElement.class);
    }

    @NotNull
    public static PsiElement spaceFromText(@NotNull PsiElement context) {
        return OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("CIDR_RULE_ZZZ1 CIDR_RULE_ZZZ2", context)).get(1);
    }

    @NotNull
    public static PsiElement newlineFromText(@NotNull PsiElement context) {
        return OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("CIDR_RULE_ZZZ1\nCIDR_RULE_ZZZ2", context)).get(1);
    }

    public static void initIndentFromContext(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        PsiFile context = oldElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)((TreeElement)newElement.getNode()), (int)IndentHelper.getInstance().getIndent(context, oldElement.getNode()));
    }

    @NotNull
    public static OCBlockStatement surroundByBraces(@NotNull PsiElement element) {
        if (element instanceof OCBlockStatement) {
            return (OCBlockStatement)element;
        }
        OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", element);
        OCChangeUtil.addAfter(blockStatement, element, blockStatement.getOpeningBrace());
        return blockStatement;
    }

    @NotNull
    public static PsiElement createLeaf(@NotNull PsiManager manager, @NotNull OCElementType type) {
        return Factory.createSingleLeafElement((IElementType)type, (CharSequence)type.getName(), (int)0, (int)type.getName().length(), null, (PsiManager)manager).getPsi();
    }

    private static boolean isDeclaratorParenthesesRequired(@NotNull OCType type) {
        if (type instanceof OCVariadicType) {
            type = ((OCVariadicType)type).getUnderlyingType();
        }
        OCType pointeeType = type;
        while (pointeeType instanceof OCCppReferenceType || pointeeType.getClass().equals(OCPointerType.class)) {
            if (pointeeType instanceof OCCppReferenceType) {
                pointeeType = ((OCCppReferenceType)pointeeType).getRefType();
                continue;
            }
            pointeeType = ((OCPointerType)pointeeType).getRefType();
        }
        return !(!type.getClass().equals(OCPointerType.class) && !(type instanceof OCCppReferenceType) || !(pointeeType instanceof OCArrayType) && !(pointeeType instanceof OCFunctionType));
    }

    private static class OCEmptyTypeElement
    implements OCTypeElement {
        @NotNull
        final PsiElement myContext;

        private OCEmptyTypeElement(@NotNull PsiElement context) {
            this.myContext = context;
        }

        @Override
        @NotNull
        public OCType getType() {
            return OCUnknownType.INSTANCE;
        }

        @Override
        @NotNull
        public OCType getRawType() {
            return OCUnknownType.INSTANCE;
        }

        @Override
        @NotNull
        public OCType getRawType(boolean assumeNonNull) {
            return OCUnknownType.INSTANCE;
        }

        @Override
        public int getArrayLengths() {
            return 0;
        }

        @Override
        public boolean isEmptyType() {
            return true;
        }

        @Override
        public OCFile getContainingOCFile() {
            return null;
        }

        @Override
        public String getTextWithMacros() {
            return null;
        }

        @Override
        public TextRange getRangeWithMacros() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getTextOffset() {
            return 0;
        }

        @Override
        public long getComplexOffset() {
            return 0L;
        }

        @NotNull
        public Project getProject() throws PsiInvalidElementAccessException {
            return this.myContext.getProject();
        }

        @NotNull
        public Language getLanguage() {
            return Language.ANY;
        }

        public PsiManager getManager() {
            return null;
        }

        public PsiElement @NotNull [] getChildren() {
            return PsiElement.EMPTY_ARRAY;
        }

        public PsiElement getParent() {
            return null;
        }

        public PsiElement getFirstChild() {
            return null;
        }

        public PsiElement getLastChild() {
            return null;
        }

        public PsiElement getNextSibling() {
            return null;
        }

        public PsiElement getPrevSibling() {
            return null;
        }

        public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
            return null;
        }

        public TextRange getTextRange() {
            return null;
        }

        public int getStartOffsetInParent() {
            return 0;
        }

        public int getTextLength() {
            return 0;
        }

        @Nullable
        public PsiElement findElementAt(int offset) {
            return null;
        }

        @Nullable
        public PsiReference findReferenceAt(int offset) {
            return null;
        }

        public String getText() {
            return null;
        }

        public char @NotNull [] textToCharArray() {
            return new char[0];
        }

        public PsiElement getNavigationElement() {
            return null;
        }

        public PsiElement getOriginalElement() {
            return null;
        }

        public boolean textMatches(@NotNull CharSequence text) {
            return false;
        }

        public boolean textMatches(@NotNull PsiElement element) {
            return false;
        }

        public boolean textContains(char c) {
            return false;
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
        }

        public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        }

        public PsiElement copy() {
            return null;
        }

        public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
            return null;
        }

        public PsiElement addBefore(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
            return null;
        }

        public PsiElement addAfter(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
            return null;
        }

        public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        }

        public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
            return null;
        }

        public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
            return null;
        }

        public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
            return null;
        }

        public void delete() throws IncorrectOperationException {
        }

        public void checkDelete() throws IncorrectOperationException {
        }

        public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        }

        public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
            return null;
        }

        public boolean isValid() {
            return false;
        }

        public boolean isWritable() {
            return false;
        }

        @Nullable
        public PsiReference getReference() {
            return null;
        }

        public PsiReference @NotNull [] getReferences() {
            return PsiReference.EMPTY_ARRAY;
        }

        @Nullable
        public <T> T getCopyableUserData(@NotNull Key<T> key) {
            return null;
        }

        public <T> void putCopyableUserData(@NotNull Key<T> key, @Nullable T value) {
        }

        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
            return false;
        }

        @Nullable
        public PsiElement getContext() {
            return this.myContext;
        }

        public boolean isPhysical() {
            return false;
        }

        @NotNull
        public GlobalSearchScope getResolveScope() {
            return null;
        }

        @NotNull
        public SearchScope getUseScope() {
            return null;
        }

        public ASTNode getNode() {
            return null;
        }

        public boolean isEquivalentTo(PsiElement another) {
            return false;
        }

        public Icon getIcon(int flags) {
            return null;
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            return null;
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        }
    }
}

