/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public final class OCConcurrentMostlySingularMultiUniqueMapBuilder<T> {
    @NotNull
    private final Map<String, Object> myMap;
    @NotNull
    private final Set<T> myAllValues;

    public OCConcurrentMostlySingularMultiUniqueMapBuilder(int capacity, int valuesEstimate, @NotNull HashingStrategy<T> strategy) {
        int reservedCapacity = (int)Math.ceil((double)capacity * 1.1);
        int reservedValues = Math.max(reservedCapacity, (int)Math.ceil((double)valuesEstimate * 1.1));
        this.myMap = new ConcurrentHashMap<String, Object>(reservedCapacity, 0.75f, 16);
        this.myAllValues = ConcurrentCollectionFactory.createConcurrentSet((int)reservedValues, strategy);
    }

    public OCConcurrentMostlySingularMultiUniqueMapBuilder(@NotNull HashingStrategy<T> strategy) {
        this.myMap = new ConcurrentHashMap<String, Object>();
        this.myAllValues = ConcurrentCollectionFactory.createConcurrentSet(strategy);
    }

    public boolean addIfAbsent(@NotNull String key, @NotNull T value) {
        if (this.myAllValues.add(value)) {
            MyMostlySingularMultiMap.add(this.myMap, key, value);
            return true;
        }
        return false;
    }

    @NotNull
    public MostlySingularMultiMap<String, T> build() {
        return MyMostlySingularMultiMap.createCompacted(this.myMap, this.myAllValues.size());
    }

    public static int estimateValueCount(@NotNull MostlySingularMultiMap<String, ?> multiMap) {
        return multiMap instanceof MyMostlySingularMultiMap ? ((MyMostlySingularMultiMap)multiMap).myValueHint : multiMap.size() * 4 / 3;
    }

    @NotNull
    public static <T> OCConcurrentMostlySingularMultiUniqueMapBuilder<T> createBuilder(@NotNull HashingStrategy<T> strategy) {
        return new OCConcurrentMostlySingularMultiUniqueMapBuilder<T>(strategy);
    }

    private static final class MyMostlySingularMultiMap<T>
    extends MostlySingularMultiMap<String, T> {
        private final int myValueHint;
        private static final BiFunction<Object, Object, Object> myRemappingFunction = (current, value) -> {
            if (current instanceof MostlySingularMultiMap.ValueList) {
                return current;
            }
            MostlySingularMultiMap.ValueList newList = new MostlySingularMultiMap.ValueList();
            newList.add(current);
            return newList;
        };

        private MyMostlySingularMultiMap(int expectedSize, int valueHint) {
            super(CollectionFactory.createSmallMemoryFootprintMap((int)expectedSize));
            this.myValueHint = valueHint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T> void add(@NotNull Map<String, Object> map2, @NotNull String key, @NotNull T value) {
            MostlySingularMultiMap.ValueList newList;
            Object newValue = map2.merge(key, value, myRemappingFunction);
            if (newValue == value) {
                return;
            }
            MostlySingularMultiMap.ValueList valueList = newList = (MostlySingularMultiMap.ValueList)newValue;
            synchronized (valueList) {
                newList.add(value);
            }
        }

        @NotNull
        private static <T> MostlySingularMultiMap<String, T> createCompacted(@NotNull Map<String, Object> sourceMap, int valueHint) {
            if (sourceMap.isEmpty()) {
                return MyMostlySingularMultiMap.emptyMap();
            }
            MyMostlySingularMultiMap<T> compactMap = new MyMostlySingularMultiMap<T>(sourceMap.size(), valueHint);
            for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof MostlySingularMultiMap.ValueList) {
                    ((MostlySingularMultiMap.ValueList)value).trimToSize();
                }
                compactMap.myMap.put(key, value);
            }
            return compactMap;
        }
    }
}

