/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableCacheListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.ui.OCUnloadedResolveContextsUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCUnloadedResolveContext;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveContextPanel
extends EditorBasedStatusBarPopup {
    private static final DataKey<ListPopupModel> POPUP_MODEL = DataKey.create((String)"OCResolveContextPanelPopupModel");
    @NonNls
    public static final String ID = "ActiveOCBuildConfiguration";
    @NonNls
    private static final String PREFIX_SEPARATOR = ": ";
    public static final @NlsContexts.StatusBarText String CONTEXT_PREFIX = OCBundle.message("resolve.contexts.prefix", new Object[0]) + ": ";
    private static final EditorBasedStatusBarPopup.WidgetState LOADING_STATE = new EditorBasedStatusBarPopup.WidgetState(OCBundle.message("resolve.contexts.loading", new Object[0]), CONTEXT_PREFIX + CommonBundle.getLoadingTreeNodeText(), false);
    private static final EditorBasedStatusBarPopup.WidgetState NO_CONTEXT_STATE = new EditorBasedStatusBarPopup.WidgetState(OCBundle.message("resolve.contexts.prefix.no.context", new Object[0]), CONTEXT_PREFIX + OCBundle.message("resolve.contexts.no.context", new Object[0]), false);
    private volatile boolean isCalculatingContext;
    private final AtomicReference<Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState>> myUpdateInfoRef = new AtomicReference();
    private volatile VirtualFile myLastUpdatedFile;
    private ProgressIndicator myCurrentProgress;
    private boolean myShowAllUnrelatedContexts;

    public OCResolveContextPanel(@NotNull Project project) {
        super(project, false);
    }

    private boolean hasAccessToSymbols() {
        return !DumbService.getInstance((Project)this.myProject).isDumb() && FileSymbolTablesCache.areSymbolsLoaded(this.myProject);
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState> updateInfo = this.replaceUpdateInfo(null);
        if (file == null || !Comparing.equal((Object)this.getSelectedFile(), (Object)file) || !FileSymbolTableHelper.isSourceFile(file, this.getProject())) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        if (!file.isValid()) {
            return NO_CONTEXT_STATE;
        }
        if (updateInfo == null || !Comparing.equal((Object)((VirtualFile)updateInfo.first), (Object)file)) {
            if (this.myCurrentProgress != null) {
                this.myCurrentProgress.cancel();
            }
            this.myCurrentProgress = new EmptyProgressIndicator();
            this.scheduleReloadFileContexts(file, this.myCurrentProgress);
            return this.isEmpty() || !Comparing.equal((Object)this.myLastUpdatedFile, (Object)file) ? LOADING_STATE : EditorBasedStatusBarPopup.WidgetState.NO_CHANGE_MAKE_VISIBLE;
        }
        this.myLastUpdatedFile = file;
        return (EditorBasedStatusBarPopup.WidgetState)updateInfo.second;
    }

    public void update(@Nullable Runnable finishUpdate) {
        this.replaceUpdateInfo(null);
        super.update(finishUpdate);
    }

    @Nullable
    private Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState> replaceUpdateInfo(@Nullable Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState> newValue) {
        return this.myUpdateInfoRef.getAndSet(newValue);
    }

    private void scheduleReloadFileContexts(VirtualFile file, @NotNull ProgressIndicator globalProgress) {
        Runnable update = () -> {
            EditorBasedStatusBarPopup.WidgetState state = this.getWidgetStateSync(file);
            this.replaceUpdateInfo((Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState>)Pair.create((Object)file, (Object)state));
            super.update(null);
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(update);
        } else {
            ReadAction.nonBlocking((Runnable)update).expireWith((Disposable)this).wrapProgress(globalProgress).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private EditorBasedStatusBarPopup.WidgetState getWidgetStateSync(@NotNull VirtualFile file) {
        OCParsedLanguageAndConfiguration langAndConfig;
        if (!file.isValid()) {
            return NO_CONTEXT_STATE;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (!OCResolveContextPanel.isRelevantFile(psiFile)) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        if (!this.hasAccessToSymbols()) {
            return EditorBasedStatusBarPopup.WidgetState.getDumbModeState((String)OCBundle.message("resolve.contexts.name", new Object[0]), (String)CONTEXT_PREFIX);
        }
        this.isCalculatingContext = true;
        try {
            langAndConfig = this.getAndVerifyLangAndConfiguration(psiFile);
        }
        finally {
            this.isCalculatingContext = false;
        }
        OCResolveConfiguration config = langAndConfig.getConfiguration();
        if (config == null) {
            return NO_CONTEXT_STATE;
        }
        OCLanguageKind kind = langAndConfig.getLanguageKind();
        Collection cs = (Collection)OCResolveContextPanel.getFileConfigurations((PsiFile)psiFile, (boolean)false).first;
        if (cs.size() > 0 && !cs.contains(config)) {
            OCResolveContextPanel.scheduleReParse(psiFile, (OCResolveConfiguration)ContainerUtil.getFirstItem((Collection)cs));
            return LOADING_STATE;
        }
        String text = kind.getShortDisplayName() + PREFIX_SEPARATOR + StringUtil.shortenTextWithEllipsis((String)config.getDisplayName(), (int)40, (int)15);
        String tooltip = OCBundle.message("resolve.contexts.current.file", kind.getDisplayName(), config.getDisplayName());
        List<OCUnloadedResolveContext> unloadedContexts = OCUnloadedResolveContextsUtil.getAllUnloadedContextsForFile(psiFile);
        return new EditorBasedStatusBarPopup.WidgetState(tooltip, text, cs.size() + unloadedContexts.size() > 1);
    }

    @Nullable
    public ListPopup createPopup(DataContext context) {
        VirtualFile file = this.getSelectedFile();
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (!OCResolveContextPanel.isRelevantFile(psiFile)) {
            return null;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        Pair<Collection<OCResolveConfiguration>, Boolean> configInfo = OCResolveContextPanel.getFileConfigurations(psiFile, true);
        Collection configurations = (Collection)configInfo.first;
        boolean isDetermined = (Boolean)configInfo.second;
        int configsSize = configurations.size();
        List<OCUnloadedResolveContext> unloadedContexts = OCUnloadedResolveContextsUtil.getAllUnloadedContextsForFile(psiFile);
        if (!isDetermined) {
            group.addSeparator(OCBundle.message("resolve.contexts.all.contexts", new Object[0]));
        }
        if (configsSize + unloadedContexts.size() > 1) {
            if (configsSize > 1) {
                group.add((AnAction)new AutoSelectItem(psiFile));
            }
            for (OCResolveConfiguration config : configurations) {
                group.add((AnAction)new ConfigurationItem(psiFile, config));
            }
        }
        if (!unloadedContexts.isEmpty()) {
            ArrayList<OCUnloadedResolveContext> relatedContexts = new ArrayList<OCUnloadedResolveContext>();
            ArrayList otherContexts = new ArrayList();
            if (isDetermined) {
                for (OCUnloadedResolveContext unloadedContext : unloadedContexts) {
                    ArrayList<OCUnloadedResolveContext> contexts = CollectionsKt.indexOfFirst((Iterable)configurations, unloadedContext::isRelatedTo) >= 0 ? relatedContexts : otherContexts;
                    contexts.add(unloadedContext);
                }
            } else {
                relatedContexts.addAll(unloadedContexts);
            }
            ContainerUtil.sort(relatedContexts);
            ContainerUtil.sort(otherContexts);
            group.addSeparator(OCBundle.message("resolve.contexts.unindexed.contexts", new Object[0]));
            for (OCUnloadedResolveContext unloadedContext : relatedContexts) {
                group.add((AnAction)new UnloadedItem(psiFile, unloadedContext, true));
            }
            if (!otherContexts.isEmpty()) {
                for (OCUnloadedResolveContext unloadedContext : otherContexts) {
                    group.add((AnAction)new UnloadedItem(psiFile, unloadedContext, false));
                }
                group.add((AnAction)new ShowMoreItem());
            }
        }
        OCResolveContextSettings settings = OCResolveContextSettings.getInstance((Project)this.myProject);
        final OCResolveConfiguration priorityConfig = (OCResolveConfiguration)settings.findPriorityConfiguration((Collection)configurations).first;
        OCResolveConfiguration effectiveConfig = this.getAndVerifyLangAndConfiguration(psiFile).getConfiguration();
        final Color outOfProjectColor = FileColorManager.getInstance((Project)this.myProject).getScopeColor("Non-Project Files");
        PopupFactoryImpl.ActionGroupPopup list = new PopupFactoryImpl.ActionGroupPopup(OCBundle.message("resolve.contexts.available", new Object[0]), (ActionGroup)group, context, false, true, true, false, null, 15, action -> action instanceof ItemBase && ((ItemBase)((Object)action)).matches(effectiveConfig), null){
            {
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
                DataManager.registerDataProvider((JComponent)this.getList(), dataId -> POPUP_MODEL.is(dataId) ? this.getListModel() : null);
            }

            protected ListCellRenderer getListElementRenderer() {
                return new PopupListElementRenderer<PopupFactoryImpl.ActionItem>((ListPopupImpl)this){

                    protected void customizeComponent(@NotNull JList<? extends PopupFactoryImpl.ActionItem> list, @NotNull PopupFactoryImpl.ActionItem actionItem, boolean isSelected) {
                        super.customizeComponent(list, (Object)actionItem, isSelected);
                        if (!(actionItem.getAction() instanceof ItemBase)) {
                            return;
                        }
                        ItemBase item = (ItemBase)actionItem.getAction();
                        if (item.isGrayedOut()) {
                            this.myTextLabel.setForeground((Color)JBColor.GRAY);
                        }
                        if (item.isOutOfProject() && !isSelected && outOfProjectColor != null) {
                            UIUtil.setBackgroundRecursively((Component)this.myComponent, (Color)outOfProjectColor);
                        }
                        Font listFont = UIUtil.getListFont();
                        this.myTextLabel.setFont(item.matches(priorityConfig) ? listFont.deriveFont(1) : listFont);
                    }
                };
            }

            public boolean shouldBeShowing(Object value) {
                if (!super.shouldBeShowing(value)) {
                    return false;
                }
                if (!(value instanceof PopupFactoryImpl.ActionItem)) {
                    return true;
                }
                AnAction action = ((PopupFactoryImpl.ActionItem)value).getAction();
                if (this.getSpeedSearch().isHoldingFilter()) {
                    return !(action instanceof ShowMoreItem);
                }
                return !(action instanceof UnloadedItem) || ((UnloadedItem)action).isRelated() || OCResolveContextPanel.this.myShowAllUnrelatedContexts;
            }
        };
        list.setAdText(OCBundle.message("resolve.contexts.file.resolved.in", new Object[0]), 10);
        return list;
    }

    private static boolean isRelevantFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof OCConfigurationOwner && psiFile.isValid();
    }

    @NotNull
    private static Pair<Collection<OCResolveConfiguration>, Boolean> getFileConfigurations(@NotNull PsiFile psiFile, boolean sort) {
        boolean isDetermined = true;
        List allConfigurations = OCInclusionContextUtil.getAllBuildConfigurationsForFile(psiFile, null);
        if (allConfigurations.isEmpty()) {
            isDetermined = false;
            allConfigurations = OCWorkspace.getInstance((Project)psiFile.getProject()).getConfigurations();
        }
        if (!sort) {
            return new Pair((Object)allConfigurations, (Object)isDetermined);
        }
        ArrayList<OCResolveConfiguration> sorted = new ArrayList<OCResolveConfiguration>(allConfigurations);
        ContainerUtil.sort(sorted);
        return new Pair(sorted, (Object)isDetermined);
    }

    protected void registerCustomListeners() {
        class Listener
        implements DumbService.DumbModeListener,
        OCInclusionContextListener,
        FileSymbolTableCacheListener {
            volatile boolean isDumbMode;

            Listener() {
            }

            public void enteredDumbMode() {
                this.isDumbMode = true;
                OCResolveContextPanel.this.update();
            }

            public void exitDumbMode() {
                this.isDumbMode = false;
                OCResolveContextPanel.this.update();
            }

            @Override
            public void resolveRootAndActiveConfigurationChanged(@NotNull VirtualFile file, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
                if (!OCResolveContextPanel.this.isCalculatingContext && !this.isDumbMode) {
                    OCResolveContextPanel.this.updateForFile(file);
                }
            }

            @Override
            public void onSymbolsUpToDate() {
                OCResolveContextPanel.this.update();
            }

            @Override
            public void onSymbolsInvalidated() {
            }
        }
        Listener listener = new Listener();
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)listener);
        this.myConnection.subscribe(OCInclusionContextListener.TOPIC, (Object)listener);
        this.myConnection.subscribe(FileSymbolTableCacheListener.TOPIC, (Object)listener);
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        return new OCResolveContextPanel(project);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    public OCParsedLanguageAndConfiguration getAndVerifyLangAndConfiguration(@NotNull PsiFile file) {
        OCLog.LOG.assertTrue(file instanceof OCConfigurationOwner);
        OCParsedLanguageAndConfiguration stored = ((OCConfigurationOwner)file).getParsedLanguageAndConfiguration();
        if (!(file instanceof OCPsiFile)) {
            OCLog.LOG.assertTrue(stored != null, (Object)"Non-OC file has no stored config");
            return stored;
        }
        OCImmutableInclusionContext context = OCHeaderContextCache.headerContext(file);
        OCParsedLanguageAndConfiguration result = new OCParsedLanguageAndConfiguration(context.getConfiguration(), context.getLanguageKind());
        if (stored != null && (result.getConfiguration() != stored.getConfiguration() || result.getLanguageKind() != stored.getLanguageKind())) {
            VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
                this.update();
            });
        }
        return result;
    }

    private static void scheduleReParse(PsiFile psiFile, OCResolveConfiguration config) {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> OCResolveContextPanel.setUserConfiguration(psiFile, config));
    }

    private static void setUserConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        application.runWriteAction(() -> {
            Project project = psiFile.getProject();
            FileManager fileManager = PsiManagerEx.getInstanceEx((Project)project).getFileManager();
            for (VirtualFile file : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
                PsiFile cachedPsi = OCInclusionContextUtil.findCachedPsiFile(file, project);
                if (!OCResolveContextPanel.isRelevantFile(cachedPsi)) continue;
                fileManager.setViewProvider(file, null);
            }
            OCFileActiveConfigurationCache.setUserSelectedConfiguration(psiFile, config);
        });
    }

    public final class ShowMoreItem
    extends ItemBase
    implements KeepingPopupOpenAction {
        private ShowMoreItem() {
            this.updateText();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OCResolveContextPanel.this.myShowAllUnrelatedContexts = !OCResolveContextPanel.this.myShowAllUnrelatedContexts;
            this.updateText();
            this.refilter(e.getInputEvent());
        }

        private void updateText() {
            this.getTemplatePresentation().setText(OCResolveContextPanel.this.myShowAllUnrelatedContexts ? OCBundle.message("resolve.show.related.contexts", new Object[0]) : OCBundle.message("resolve.show.all.contexts", new Object[0]), false);
        }

        private void refilter(@Nullable InputEvent event) {
            if (event == null || !(event.getSource() instanceof JComponent)) {
                return;
            }
            DataProvider dataProvider = DataManager.getDataProvider((JComponent)((JComponent)event.getSource()));
            if (dataProvider != null) {
                Objects.requireNonNull((ListPopupModel)POPUP_MODEL.getData(dataProvider)).refilter();
            }
        }
    }

    public static final class UnloadedItem
    extends ItemBase {
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final OCUnloadedResolveContext myUnloadedContext;
        private final boolean myIsRelated;

        private UnloadedItem(@NotNull PsiFile file, @NotNull OCUnloadedResolveContext unloadedContext, boolean related) {
            this.myIsRelated = related;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(unloadedContext.getDisplayName(), false);
            this.myFile = file;
            this.myUnloadedContext = unloadedContext;
        }

        public boolean isRelated() {
            return this.myIsRelated;
        }

        @Override
        protected boolean isGrayedOut() {
            return true;
        }

        @Override
        protected boolean isOutOfProject() {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Class<? extends Configurable> configurableClass = this.myUnloadedContext.getConfigurableToSelect();
            if (configurableClass != null) {
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myFile.getProject(), configurableClass);
            }
        }
    }

    public static final class ConfigurationItem
    extends ItemBase {
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final OCResolveConfiguration myConfig;

        private ConfigurationItem(@NotNull PsiFile file, @NotNull OCResolveConfiguration config) {
            String text = config.getDisplayName();
            this.getTemplatePresentation().setText(text, false);
            this.myFile = file;
            this.myConfig = config;
        }

        @Override
        protected boolean matches(@Nullable OCResolveConfiguration config) {
            return config == this.myConfig;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OCResolveContextPanel.scheduleReParse(this.myFile, this.myConfig);
        }

        @NotNull
        public OCResolveConfiguration getConfig() {
            return this.myConfig;
        }
    }

    public static final class AutoSelectItem
    extends ItemBase {
        @NotNull
        private final PsiFile myFile;

        AutoSelectItem(@NotNull PsiFile file) {
            this.myFile = file;
            this.getTemplatePresentation().setText(OCBundle.message("resolve.contexts.select.automatically", new Object[0]), false);
        }

        @Override
        protected boolean matches(@Nullable OCResolveConfiguration config) {
            return config == null;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                OCInclusionContextUtil.resetUserSelectedConfigurations(this.myFile.getProject());
                OCResolveContextPanel.setUserConfiguration(this.myFile, null);
            });
        }
    }

    private static abstract class ItemBase
    extends AnAction {
        private ItemBase() {
        }

        protected boolean matches(@Nullable OCResolveConfiguration config) {
            return false;
        }

        protected boolean isGrayedOut() {
            return false;
        }

        protected boolean isOutOfProject() {
            return false;
        }
    }
}

