/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFieldAdapterForSymbolName
implements OCFieldAdapter<OCSymbolNavigationItem> {
    public static final OCFieldAdapterForSymbolName INSTANCE = new OCFieldAdapterForSymbolName();

    @NotNull
    public String getName(@NotNull OCSymbolNavigationItem symbol) {
        return symbol.getName();
    }

    public Icon getIcon(@NotNull OCSymbolNavigationItem item) {
        return item.getSymbol().getIcon(item.getProject());
    }

    public String getTypeText(@NotNull OCSymbolNavigationItem item) {
        VirtualFile file;
        OCSymbol symbol = item.getSymbol();
        if (symbol instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName name;
            OCResolveContext context = OCResolveContext.forSymbol(symbol, item.getProject());
            OCSymbolWithQualifiedName owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context);
            if (symbol instanceof OCFunctionSymbol && owner != null) {
                owner = owner.getResolvedOwner(context);
            }
            if (owner != null && (name = owner.getResolvedQualifiedName(context)) != null) {
                return name.getFullName(context).substring(2);
            }
        }
        return (file = symbol.getContainingFile()) != null ? file.getName() : "";
    }

    @NotNull
    public String getReadableName(@NotNull OCSymbolNavigationItem symbol) {
        return symbol.getSymbol().getPresentableName();
    }

    protected boolean isTopLevelOnly() {
        return true;
    }

    @NotNull
    public Collection<OCSymbolNavigationItem> collectValuesFromProject(final @NotNull Project project, final @Nullable Condition<OCSymbolNavigationItem> condition) {
        if (project.isDisposed()) {
            return Collections.emptyList();
        }
        Collection allValues = OCFieldAdapter.collectAllValues((Project)project, Collections.emptyList(), () -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            CommonProcessors.CollectProcessor allCollector = new CommonProcessors.CollectProcessor();
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<? super OCSymbol>)allCollector, null, this.isTopLevelOnly());
            return allCollector.getResults();
        });
        return (Collection)OCFieldAdapter.computeWithWriteActionPriority((Project)project, indicator -> {
            final ArrayList results = new ArrayList();
            Processor<OCSymbol> processor = new Processor<OCSymbol>(){
                final Set uniquePresentationName = new HashSet();

                public boolean process(OCSymbol symbol) {
                    OCSymbolNavigationItem item = new OCSymbolNavigationItem(symbol, project);
                    if (this.accept(item)) {
                        results.add(item);
                    }
                    return true;
                }

                private boolean accept(OCSymbolNavigationItem item) {
                    ProgressManager.checkCanceled();
                    Boolean res = null;
                    while (res == null) {
                        try {
                            res = (Boolean)ProgressManager.getInstance().runProcess(() -> (Boolean)ReadAction.compute(() -> {
                                if (project.isDisposed()) {
                                    return false;
                                }
                                String mappedSymbolName = OCFieldAdapterForSymbolName.this.getReadableName(item);
                                if (!this.uniquePresentationName.contains(mappedSymbolName) && (condition == null || condition.value((Object)item))) {
                                    this.uniquePresentationName.add(mappedSymbolName);
                                    return true;
                                }
                                return false;
                            }), indicator);
                        }
                        catch (ProcessCanceledException processCanceledException) {}
                    }
                    return res;
                }
            };
            ContainerUtil.process((Iterable)allValues, (Processor)processor);
            return results;
        });
    }

    @NotNull
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        boolean caseSensitive = CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 3 && CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 2;
        return new CamelHumpMatcher(prefix, caseSensitive);
    }

    public String getPrefix(@NotNull String text, int offset) {
        int i = text.lastIndexOf(32, offset - 1) + 1;
        int j = text.lastIndexOf(10, offset - 1) + 1;
        return text.substring(Math.max(i, j), offset);
    }
}

