/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors.names;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeNameVisitorBase
implements OCTypeVisitor<String> {
    public static final int MAX_STRUCT_PARAMETERS_IN_PRESENTATION = 5;
    public static final int MAX_TEMPLATE_DEPTH_IN_PRESENTATION = 10;
    public static final int MAX_ARG_LENGTH_IN_PRESENTATION = 300;
    protected final int myTemplateDepth;

    protected OCTypeNameVisitorBase(int templateDepth) {
        this.myTemplateDepth = templateDepth;
    }

    @NotNull
    public abstract String getName(OCType var1);

    protected abstract String getNameForTypeArgument(OCTypeArgument var1);

    protected List<OCTypeArgument> getTypeArguments(@NotNull OCTemplateSymbol symbol) {
        return this.getTypeArguments(symbol, DefaultArgumentsRemovalStrategy.LAST_MATCH);
    }

    @NotNull
    protected abstract List<OCTypeArgument> getTypeArguments(@NotNull OCTemplateSymbol var1, @NotNull DefaultArgumentsRemovalStrategy var2);

    @Nullable
    protected abstract String getCanonicalName(OCReferenceType var1);

    @Nullable
    protected abstract Project getProject();

    protected String getSubstitutedTypeName(String baseName, @NotNull OCTemplateSymbol symbol) {
        return this.getSubstitutedTypeName(baseName, symbol, DefaultArgumentsRemovalStrategy.LAST_MATCH);
    }

    protected String getSubstitutedTypeName(String baseName, @NotNull OCTemplateSymbol symbol, @NotNull DefaultArgumentsRemovalStrategy defaultArgumentsRemovalStrategy) {
        List<OCTypeArgument> arguments = this.getTypeArguments(symbol, defaultArgumentsRemovalStrategy);
        StringBuilder builder2 = new StringBuilder(baseName);
        if (arguments.size() > 0) {
            builder2.append('<');
            if (this.myTemplateDepth < 10) {
                for (int j = 0; j < arguments.size(); ++j) {
                    if (j > 5) {
                        builder2.append("...");
                        break;
                    }
                    if (j != 0) {
                        builder2.append(", ");
                    }
                    OCTypeArgument argument = arguments.get(j);
                    if (symbol.isSpecialization() && argument != null) {
                        builder2.append(this.getNameForTypeArgument(argument));
                        continue;
                    }
                    if (argument instanceof OCType) {
                        builder2.append(this.getName((OCType)argument));
                        continue;
                    }
                    if (argument != null) {
                        builder2.append(this.getNameForTypeArgument(argument));
                        continue;
                    }
                    builder2.append(symbol.getTemplateParameters().get(j).getName());
                }
            } else {
                builder2.append("...");
            }
            builder2.append(">");
        }
        return builder2.toString();
    }

    @NonNls
    private static String appendIsKindof(boolean isKindof, @NonNls String typeString) {
        if (!isKindof || typeString.startsWith("__kindof ")) {
            return typeString;
        }
        return "__kindof " + typeString;
    }

    protected String appendCVQualifiers(OCType type, @NonNls String typeString) {
        return CVQualifiers.appendCVQualifiers(typeString, type, this.getProject());
    }

    @NotNull
    public static String addTypeQualifier(@NotNull String typeString, @NotNull OCType type, @Nullable Project project, @NonNls @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        if (qualifier.isEmpty()) {
            return typeString;
        }
        OCCodeStyleSettings oCCodeStyleSettings = settings = project != null ? (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || type instanceof OCFunctionType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            return typeString.endsWith(" " + qualifier) ? typeString : typeString + " " + qualifier;
        }
        return typeString.startsWith(qualifier + " ") ? typeString : qualifier + " " + typeString;
    }

    @NotNull
    public static String removeTypeQualifier(@NonNls @NotNull String typeString, @NotNull OCType type, @Nullable Project project, @NonNls @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        OCCodeStyleSettings oCCodeStyleSettings = settings = project != null ? (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            return typeString.endsWith(" " + qualifier) ? typeString.substring(0, typeString.length() - qualifier.length() - 1) : typeString;
        }
        return typeString.startsWith(qualifier + " ") ? typeString.substring(qualifier.length() + 1) : typeString;
    }

    protected String getFunctionSignature(OCFunctionType type, String signatureWithoutParams) {
        StringBuilder builder2 = new StringBuilder(signatureWithoutParams);
        builder2.append('(');
        builder2.append(StringUtil.join(type.getParameterTypes(true), this::getName, (String)","));
        builder2.append(')');
        return this.appendCVQualifiers(type, builder2.toString());
    }

    @Override
    public String visitEllipsisReferenceType(OCEllipsisType type) {
        return "...";
    }

    @Override
    public String visitObjectType(OCObjectType type) {
        boolean isGeneric;
        List<OCProtocolSymbol> protocols = type.getAugmentedProtocols();
        OCInterfaceSymbol interfaceSymbol = type.getInterface();
        boolean bl = isGeneric = interfaceSymbol != null && !interfaceSymbol.getGenericParameters().isEmpty() && interfaceSymbol.getSubstitution() != OCTypeSubstitution.ID;
        if (protocols.isEmpty() && !isGeneric) {
            return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, type.getClassName()));
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append(isGeneric ? this.getSubstitutedTypeName(type.getClassName(), interfaceSymbol, DefaultArgumentsRemovalStrategy.ALL_MATCH) : type.getClassName());
        if (!protocols.isEmpty()) {
            builder2.append('<');
            builder2.append(StringUtil.join(protocols, OCSymbol::getName, (String)", "));
            builder2.append('>');
        }
        return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder2.toString()));
    }

    @Override
    public String visitUnknownType(OCUnknownType type) {
        return (String)this.visitMagicType(type);
    }

    @Override
    public String visitVoidType(OCVoidType type) {
        return this.appendCVQualifiers(type, "void");
    }

    @Override
    public String visitTypeParameterType(OCTypeParameterType type) {
        return this.appendCVQualifiers(type, type.getSymbol().getName());
    }

    @Override
    public String visitAutoType(OCAutoType type) {
        return this.appendCVQualifiers(type, "auto");
    }

    @Override
    public String visitVariadicType(OCVariadicType type) {
        return this.getName(type.getUnderlyingType()) + "...";
    }

    @Override
    @NonNls
    public String visitBracedInitListType(OCBracedInitListType type) {
        return "<braced-init-list>";
    }

    @Override
    public String visitReferenceType(OCReferenceType type) {
        String name = this.getCanonicalName(type);
        boolean isBaseClause = type.getReference() instanceof OCSymbolReference.BaseClauseReference;
        String[] protocolNames = type.getProtocolNames();
        if (protocolNames.length == 0) {
            if (isBaseClause) {
                return type.getReference().getQualifiedName().getName();
            }
            return name != null ? OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, name)) : "<unnamed>";
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append(name).append('<').append(protocolNames[0]);
        for (int i = 1; i < protocolNames.length; ++i) {
            builder2.append(", ").append(protocolNames[i]);
        }
        builder2.append('>');
        return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder2.toString()));
    }

    @Override
    @NonNls
    public String visitStructuredBindingType(OCStructuredBindingType type) {
        return "<structured-binding>";
    }

    @Override
    @NonNls
    public String visitDeferredType(OCDeferredType type) {
        return "<deferred-type>";
    }

    public static enum DefaultArgumentsRemovalStrategy {
        NONE,
        LAST_MATCH,
        ALL_MATCH;

    }
}

