/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors.names;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitorBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDumbTypeNameVisitor
extends OCTypeNameVisitorBase {
    @Nullable
    private final Project myProject;

    public OCDumbTypeNameVisitor() {
        this(0, null);
    }

    public OCDumbTypeNameVisitor(int templateDepth, @Nullable Project project) {
        super(templateDepth);
        this.myProject = project;
    }

    @Override
    @NotNull
    public String getName(OCType type) {
        String aliasName = type.getAliasName();
        if (aliasName != null) {
            return aliasName;
        }
        return type.accept(this);
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    @Override
    public String visitFunctionType(OCFunctionType type) {
        String name = this.getName(type.getReturnType());
        return this.getFunctionSignature(type, name);
    }

    @Override
    public String visitMagicType(OCMagicType type) {
        return type.getMagicName();
    }

    @Override
    public String visitAutoType(OCAutoType type) {
        String typeStr = type.getTypeConstraintName() != null ? type.getTypeConstraintName() + " auto" : "auto";
        return this.appendCVQualifiers(type, typeStr);
    }

    @Override
    public String visitArrayType(OCArrayType type) {
        return this.getArrayTypeName(type, null);
    }

    @NotNull
    private String getArrayTypeName(OCArrayType type, @Nullable String modifier) {
        StringBuilder builder2 = new StringBuilder();
        OCType current = type;
        while (current instanceof OCArrayType) {
            OCArrayType arrayType = current;
            builder2.append("[");
            if (arrayType.getLengthSymbol() != null) {
                builder2.append(arrayType.getLengthSymbol().getPresentableName());
            }
            builder2.append("]");
            current = arrayType.getRefType();
        }
        if (modifier != null) {
            builder2.insert(0, modifier);
        }
        builder2.insert(0, this.getName(current));
        return builder2.toString();
    }

    @Override
    public String visitPointerType(OCPointerType type) {
        if (type.getTerminalType() instanceof OCFunctionType) {
            OCFunctionType ft = (OCFunctionType)type.getTerminalType();
            StringBuilder builder2 = new StringBuilder();
            builder2.append(ft.getReturnType().getName()).append(" (");
            StringBuilder asteriskBuilder = new StringBuilder();
            if (type.getClassQualifier() != null) {
                builder2.append(this.getName(type.getClassQualifier())).append("::");
            }
            OCType cur = type;
            while (cur instanceof OCPointerType) {
                asteriskBuilder.append(cur instanceof OCBlockPointerType ? (char)'^' : '*');
                cur = cur.getRefType();
            }
            for (int i = asteriskBuilder.length() - 1; i >= 0; --i) {
                builder2.append(asteriskBuilder.charAt(i));
            }
            builder2.append(')');
            String signature2 = this.getFunctionSignature(ft, builder2.toString());
            return this.appendCVQualifiers(type, signature2);
        }
        String refCanonical = (String)(type.getARCAttribute() != null ? type.getARCAttribute().getTokenName() + " " : "") + this.getName(type.getRefType());
        if (type instanceof OCBlockPointerType) {
            return "invalid_block_pointer: ^(" + refCanonical + ")";
        }
        if (type.getRefType() instanceof OCIdType) {
            return refCanonical;
        }
        Object suffix = "*";
        if (type.getClassQualifier() != null) {
            suffix = type.getClassQualifier().getName() + "::" + (String)suffix;
        }
        return this.appendCVQualifiers(type, refCanonical + " " + (String)suffix);
    }

    @Override
    public String visitBlockPointerType(OCBlockPointerType type) {
        return this.visitPointerType(type);
    }

    @Override
    public String visitCppReferenceType(OCCppReferenceType type) {
        String modifier;
        String string = modifier = type.isRvalueRef() ? "&&" : "&";
        if (type.getTerminalType() instanceof OCFunctionType) {
            OCFunctionType ft = (OCFunctionType)type.getTerminalType();
            return this.getFunctionSignature(ft, this.getName(ft.getReturnType()) + " (" + modifier + ")");
        }
        if (type.getRefType() instanceof OCArrayType) {
            return this.getArrayTypeName((OCArrayType)type.getRefType(), " (" + modifier + ")");
        }
        String refCanonical = this.getName(type.getRefType());
        if (type.getRefType() instanceof OCIdType) {
            return refCanonical;
        }
        return this.appendCVQualifiers(type, refCanonical + " " + modifier);
    }

    @Override
    public String visitIdType(OCIdType type) {
        return this.visitObjectType(type);
    }

    @Override
    public String visitIntType(OCIntType type) {
        return this.appendCVQualifiers(type, type.getText());
    }

    @Override
    public String visitRealType(OCRealType type) {
        return this.appendCVQualifiers(type, type.getText());
    }

    @Override
    protected String getCanonicalName(OCReferenceType type) {
        return type.getReference().getQualifiedName().getShortName(this.myTemplateDepth);
    }

    @Override
    public String visitStructType(OCStructType type) {
        OCStructSymbol symbol = type.getStructs().get(0);
        String baseName = type.getTypedefName() != null ? type.getTypedefName() : (symbol.isUnnamed() ? "anonymous " + symbol.getKind().getStructKeyword() : symbol.getName());
        OCTypeSubstitution substitution = symbol.getSubstitution();
        if (substitution != OCTypeSubstitution.ID || symbol.isSpecialization()) {
            return this.appendCVQualifiers(type, this.getSubstitutedTypeName(baseName, symbol));
        }
        return this.appendCVQualifiers(type, baseName);
    }

    @Override
    protected String getNameForTypeArgument(OCTypeArgument argument) {
        return argument.getShortName(this.myTemplateDepth + 1);
    }

    @Override
    @NotNull
    protected List<OCTypeArgument> getTypeArguments(@NotNull OCTemplateSymbol symbol, @NotNull OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy defaultArgumentsRemovalStrategy) {
        OCTypeSubstitution substitution = symbol.getSubstitution();
        ArrayList<OCTypeArgument> arguments = new ArrayList<OCTypeArgument>();
        List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
        if (specialization != null) {
            arguments.addAll(specialization);
        } else {
            for (OCTypeParameterSymbol argument : symbol.getTemplateParameters()) {
                arguments.add(substitution.getSubstitutionFor(argument));
            }
        }
        if (symbol instanceof OCInterfaceSymbol) {
            boolean removeArguments = true;
            for (int i = arguments.size() - 1; i >= 0; --i) {
                OCTypeParameterSymbol argument = symbol.getTemplateParameters().get(i);
                OCTypeArgument typeArgument = (OCTypeArgument)arguments.get(i);
                if (!(typeArgument instanceof OCType) || !(argument.getDefaultValue() instanceof OCType)) continue;
                boolean isDefaultId = ((OCType)argument.getDefaultValue()).isPointerToID();
                boolean isArgumentId = ((OCType)typeArgument).isPointerToID();
                if (isDefaultId && isArgumentId) continue;
                removeArguments = false;
                break;
            }
            if (removeArguments) {
                arguments.clear();
            }
        }
        return arguments;
    }

    @Override
    public String visitExpansionPackType(OCExpansionPackType type) {
        return StringUtil.join((Collection)ContainerUtil.map(type.getExpansions(), typeArgument -> typeArgument.getShortName(this.myTemplateDepth)), (String)", ");
    }
}

