/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCDeductionCandidateSymbol;
import com.jetbrains.cidr.lang.resolve.OCTypeArgumentsProcessor;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimpleTypeSubstitution
extends OCTypeSubstitution {
    @NotNull
    private Map<OCTypeParameterSymbol, OCTypeArgument> mySubstitutions;

    public OCSimpleTypeSubstitution() {
    }

    OCSimpleTypeSubstitution(@NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutions) {
        this.mySubstitutions = substitutions;
    }

    @NotNull
    public Map<OCTypeParameterSymbol, OCTypeArgument> getSubstitutions() {
        return this.mySubstitutions;
    }

    public static OCSimpleTypeSubstitution create(@NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutions) {
        return substitutions.isEmpty() ? ID : new OCSimpleTypeSubstitution(new HashMap<OCTypeParameterSymbol, OCTypeArgument>(substitutions));
    }

    @Override
    public boolean hasSubstitutionForName(@NotNull String name) {
        for (OCTypeParameterSymbol symbol : this.getTypeParameters()) {
            if (!name.equals(symbol.getName())) continue;
            return true;
        }
        return false;
    }

    public Set<OCTypeParameterSymbol> getTypeParameters() {
        return this.mySubstitutions.keySet();
    }

    @Override
    public Collection<OCTypeArgument> getSubstitutedTypes() {
        return this.mySubstitutions.values();
    }

    @Override
    public boolean processSubstitutions(Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>> processor) {
        return ContainerUtil.process(this.mySubstitutions.entrySet(), processor);
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCSimpleTypeSubstitution f = (OCSimpleTypeSubstitution)first;
        OCSimpleTypeSubstitution s = (OCSimpleTypeSubstitution)second;
        return c.equalMaps(f.mySubstitutions, s.mySubstitutions);
    }

    @Override
    public OCType substitute(@NotNull OCType type, final boolean overwriteSubstitution, final @NotNull OCResolveContext context) {
        if (this != ID) {
            return type.transformType(new OCTypeSubstitution.TypeSubstituteVisitor(this, overwriteSubstitution, context){

                @Override
                public OCType visitTypeParameterType(OCTypeParameterType type) {
                    OCTypeArgument arg = OCSimpleTypeSubstitution.this.mySubstitutions.get(type.getSymbol());
                    if (arg != null) {
                        if (arg instanceof OCType) {
                            OCType result = (OCType)arg;
                            if (arg instanceof OCReferenceType) {
                                result = OCTypeSubstitution.substituteReferenceType((OCReferenceType)arg, OCSimpleTypeSubstitution.this, overwriteSubstitution, context);
                            }
                            return result.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProjectOrNull());
                        }
                        return new OCMagicType(arg.getNameForPresentation(OCType.Presentation.FULL, context, true, 0));
                    }
                    return type;
                }
            });
        }
        return type;
    }

    public static List<OCTemplateSymbol> resolveTemplateSpecialization(@NotNull List<OCTemplateSymbol> symbols, List<OCTypeArgument> arguments, @NotNull OCResolveContext resolver) {
        OCTemplateSymbol substituted;
        Ref count;
        if (symbols.isEmpty()) {
            return symbols;
        }
        ArrayList<OCTemplateSymbol> qualifiedContainers = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> predefinitions = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> nonSpecialized = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> specialized = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> result = new ArrayList<OCTemplateSymbol>();
        OCSimpleTypeSubstitution.divideSymbols(symbols, qualifiedContainers, predefinitions, nonSpecialized, specialized);
        arguments = OCArgumentsList.expandVariadicTypes(arguments, resolver);
        List resolvedArguments = ContainerUtil.map(arguments, argument -> OCSimpleTypeSubstitution.resolveTypeArgument(resolver, Collections.emptyMap(), argument));
        boolean dependentType = OCSimpleTypeSubstitution.isDependentType(resolvedArguments, resolver);
        if (symbols.size() == 1) {
            OCTemplateSymbol symbol = symbols.get(0);
            Ref count2 = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
            OCTemplateSymbol substituted2 = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, specialized.isEmpty() ? symbol : null, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count2);
            if (count2.get() != OCTypeUnificationVisitor.NOT_UNIFIED || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                result.add(substituted2);
            }
            return result;
        }
        if (!specialized.isEmpty()) {
            OCTemplateSymbol bestSpecialization = null;
            OCTypeUnificationVisitor.UnificationResult bestSpecializationCount = OCTypeUnificationVisitor.NOT_UNIFIED;
            for (OCTemplateSymbol symbol : specialized) {
                Ref count3 = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                OCTemplateSymbol baseSymbol = null;
                if (nonSpecialized.size() == 1) {
                    baseSymbol = nonSpecialized.get(0);
                } else if (predefinitions.size() == 1) {
                    baseSymbol = predefinitions.get(0);
                }
                if (symbol instanceof OCFunctionSymbol && !(baseSymbol instanceof OCFunctionSymbol)) {
                    baseSymbol = null;
                }
                OCTemplateSymbol substituted3 = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, baseSymbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count3);
                if (!dependentType) {
                    if (symbol instanceof OCFunctionSymbol) {
                        if (((OCTypeUnificationVisitor.UnificationResult)count3.get()).isBetter(bestSpecializationCount)) {
                            result.clear();
                            result.add(symbol);
                        } else if (!bestSpecializationCount.isBetter((OCTypeUnificationVisitor.UnificationResult)count3.get()) && count3.get() != OCTypeUnificationVisitor.NOT_UNIFIED) {
                            result.add(symbol);
                        }
                    }
                    if (!((OCTypeUnificationVisitor.UnificationResult)count3.get()).isBetter(bestSpecializationCount)) continue;
                    bestSpecialization = substituted3;
                    bestSpecializationCount = (OCTypeUnificationVisitor.UnificationResult)count3.get();
                    continue;
                }
                if (count3.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                result.add(substituted3);
            }
            if (!dependentType && bestSpecialization != null && !(bestSpecialization instanceof OCFunctionSymbol)) {
                result.add(bestSpecialization);
            }
        }
        if (result.isEmpty() || dependentType || resolver.isIncompleteMode() && arguments.isEmpty()) {
            for (OCTemplateSymbol symbol : nonSpecialized) {
                count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, symbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                if (dependentType) {
                    result.add(0, substituted);
                    continue;
                }
                result.add(substituted);
            }
        }
        if (result.isEmpty()) {
            for (OCTemplateSymbol symbol : predefinitions) {
                count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, symbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                if (nonSpecialized.size() == 1) {
                    count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                    substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(nonSpecialized.get(0), nonSpecialized.get(0), substituted, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                    if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                    result.add(substituted);
                    continue;
                }
                result.add(substituted);
            }
        }
        result.addAll(qualifiedContainers);
        return result;
    }

    protected static void divideSymbols(@NotNull List<OCTemplateSymbol> symbols, @NotNull List<OCTemplateSymbol> qualifiedContainers, @NotNull List<OCTemplateSymbol> predefinitions, @NotNull List<OCTemplateSymbol> nonSpecialized, @NotNull List<OCTemplateSymbol> specialized) {
        for (OCTemplateSymbol symbol : symbols) {
            if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isQualifiedContainer()) {
                qualifiedContainers.add(symbol);
                continue;
            }
            if (symbol instanceof OCStructSymbol && symbol.isPredeclaration()) {
                predefinitions.add(symbol);
                continue;
            }
            if (symbol.getTemplateSpecialization() != null) {
                specialized.add(symbol);
                continue;
            }
            nonSpecialized.add(symbol);
        }
    }

    private static boolean isDependentType(@NotNull List<OCTypeArgument> arguments, @NotNull OCResolveContext resolver) {
        boolean dependentType = false;
        for (OCTypeArgument argument : arguments) {
            if (argument instanceof OCCppReferenceType) {
                argument = ((OCCppReferenceType)argument).getRefType();
            }
            if (argument instanceof OCStructType) {
                if (((OCStructType)argument).getStructs().size() <= 1) continue;
                dependentType = true;
                continue;
            }
            if (!(argument instanceof OCMagicType) && (!(argument instanceof OCVariadicType) || !(((OCVariadicType)argument).getUnderlyingType() instanceof OCTypeParameterType)) && (!(argument instanceof OCExpressionTypeArgument) || OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)argument).getSymbol(), resolver) != null)) continue;
            dependentType = true;
            if (!(argument instanceof OCTypeParameterType)) continue;
            resolver.addTypeDependency(((OCTypeParameterType)argument).getSymbol());
        }
        return dependentType;
    }

    @Override
    public OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol param) {
        return this.mySubstitutions.get(param);
    }

    private static OCTemplateSymbol applyArgumentsToTemplateSymbol(@NotNull OCTemplateSymbol symbol, @Nullable OCTemplateSymbol baseSymbol, @Nullable OCTemplateSymbol predefinition, @NotNull List<OCTypeArgument> resolvedArguments, @NotNull OCResolveContext resolver, @NotNull Ref<OCTypeUnificationVisitor.UnificationResult> specializationCount) {
        Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
        List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
        int resolvedArgumentsCnt = resolvedArguments.size();
        boolean isNonExpandedVariadic = false;
        if (resolvedArgumentsCnt > 0 && ContainerUtil.getLastItem(resolvedArguments) instanceof OCVariadicType) {
            --resolvedArgumentsCnt;
            isNonExpandedVariadic = true;
        }
        if (!(specialization != null && specialization.size() >= resolvedArgumentsCnt || symbol.isVariadicTemplate() || baseSymbol != null && baseSymbol.getTemplateParameters().size() >= resolvedArgumentsCnt && !baseSymbol.isVariadicTemplate())) {
            specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
            return symbol;
        }
        if (specialization != null) {
            OCResolveContext paramResolveContext = resolver.clearSubstitution();
            paramResolveContext.setDontExpandVariadics(true);
            if (!OCTypeArgumentsProcessor.processArguments(specialization, resolvedArguments, (Function<OCTypeArgument, OCTypeArgument>)((Function)typeArgument -> OCSimpleTypeSubstitution.resolveTypeArgument(paramResolveContext, substitutionMap, typeArgument)), false, (parameter, argument) -> {
                if (parameter instanceof OCType && ((OCType)parameter).isUnresolved(paramResolveContext)) {
                    specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                    return false;
                }
                if (argument != null) {
                    if (OCSimpleTypeSubstitution.incompatibleArgument(parameter, argument, substitutionMap, resolver)) {
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return false;
                    }
                    OCTypeUnificationVisitor.UnificationResult result = OCSimpleTypeSubstitution.unify(parameter, argument, substitutionMap, resolver);
                    specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result));
                    if (parameter instanceof OCMagicType) {
                        ((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).incNumOfNonSpecializedArgs();
                    }
                    if (specializationCount.get() == OCTypeUnificationVisitor.NOT_UNIFIED) {
                        return false;
                    }
                }
                return true;
            })) {
                return symbol;
            }
        }
        if (baseSymbol != null) {
            OCTypeArgument argument2;
            OCTypeParameterSymbol parameterSymbol;
            List<OCTypeParameterSymbol> parameters = baseSymbol.getTemplateParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                parameterSymbol = parameters.get(i);
                Object defaultValue = parameterSymbol.getDefaultValue();
                OCTypeArgument parameter2 = new OCTypeParameterType(parameterSymbol);
                if (specialization != null && i >= specialization.size() && !(ContainerUtil.getLastItem(specialization) instanceof OCVariadicType) && defaultValue != null) {
                    parameter2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, defaultValue);
                }
                if (parameterSymbol.isVariadic()) break;
                if (i < resolvedArgumentsCnt) {
                    argument2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, resolvedArguments.get(i));
                } else if (predefinition != null) {
                    List<OCTypeParameterSymbol> predefParameters = predefinition.getTemplateParameters();
                    OCTypeArgument oCTypeArgument = argument2 = predefParameters.size() > i ? predefinition.getSubstitution().getSubstitutionFor(predefParameters.get(i)) : null;
                    if (argument2 == null) {
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                } else {
                    if (defaultValue == null) {
                        if (!(baseSymbol instanceof OCStructSymbol) || isNonExpandedVariadic) break;
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                    argument2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, defaultValue);
                    if (specialization != null && i < specialization.size()) {
                        OCTypeArgument specializationParameter = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, specialization.get(i));
                        OCTypeUnificationVisitor.UnificationResult result = OCSimpleTypeSubstitution.unify(specializationParameter, argument2, substitutionMap, resolver);
                        specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result));
                        if (specializationParameter instanceof OCMagicType) {
                            ((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).incNumOfNonSpecializedArgs();
                        }
                    }
                }
                OCSimpleTypeSubstitution.unifyArgument(parameter2, argument2, parameterSymbol, substitutionMap, resolver, specializationCount);
            }
            if (baseSymbol.isVariadicTemplate()) {
                int variadicParamIndex;
                for (variadicParamIndex = parameters.size() - 1; variadicParamIndex > 0 && parameters.get(variadicParamIndex - 1).isVariadic(); --variadicParamIndex) {
                }
                parameterSymbol = parameters.get(variadicParamIndex);
                if (!(symbol instanceof OCFunctionSymbol)) {
                    substitutionMap.put(parameterSymbol, new OCExpansionPackType());
                }
                OCTypeParameterType parameter3 = new OCTypeParameterType(parameterSymbol);
                for (int i = variadicParamIndex; i < resolvedArguments.size(); ++i) {
                    argument2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, resolvedArguments.get(i));
                    OCSimpleTypeSubstitution.unifyArgument(parameter3, argument2, parameterSymbol, substitutionMap, resolver, specializationCount);
                }
                if (specialization != null) {
                    int specializationsRequiredCnt = specialization.size();
                    OCTypeArgument lastArgument = (OCTypeArgument)ContainerUtil.getLastItem(specialization);
                    if (lastArgument != null && lastArgument.isVariadic()) {
                        --specializationsRequiredCnt;
                    }
                    if (resolvedArgumentsCnt < specializationsRequiredCnt && !isNonExpandedVariadic) {
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                }
            }
        }
        OCTypeSubstitution minimalSubstitution = resolver.getSubstitution().getMinimalDependentSubstitution(resolvedArguments, resolver);
        return OCSimpleTypeSubstitution.compose(OCSimpleTypeSubstitution.create(substitutionMap), minimalSubstitution, false).substitute(symbol, null, true, resolver);
    }

    private static void unifyArgument(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @NotNull OCTypeParameterSymbol parameterSymbol, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext resolver, @NotNull Ref<OCTypeUnificationVisitor.UnificationResult> specializationCount) {
        OCTypeUnificationVisitor.UnificationResult result = OCSimpleTypeSubstitution.unify(parameter, argument, substitutionMap, resolver);
        OCTypeArgument substitutionResult = substitutionMap.get(parameterSymbol);
        if (substitutionResult instanceof OCType && ((OCType)substitutionResult).isUnresolved(resolver)) {
            specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
        } else {
            specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result));
        }
    }

    private static boolean incompatibleArgument(@NotNull OCTypeArgument specializationParam, @NotNull OCTypeArgument argument, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext resolver) {
        resolver = resolver.substitute(OCSimpleTypeSubstitution.create(substitutionMap));
        if (specializationParam instanceof OCReferenceType && argument instanceof OCStructType) {
            boolean isStruct;
            OCReferenceType specializationType = (OCReferenceType)specializationParam;
            OCStructType argumentType = (OCStructType)argument;
            List<OCSymbol> specializationSymbols = specializationType.getReference(resolver).resolveToSymbols(true, true, false, resolver);
            boolean bl = isStruct = ContainerUtil.findInstance(specializationSymbols, OCStructSymbol.class) != null;
            if (isStruct && !specializationSymbols.contains(argumentType.getSymbol())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected static OCTypeArgument resolveTypeArgument(@NotNull OCResolveContext resolver, Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCTypeArgument argument) {
        return OCSimpleTypeSubstitution.resolveTypeArgument(argument, resolver.useFor(argument, OCSimpleTypeSubstitution.create(substitutionMap)));
    }

    @NotNull
    public static OCTypeArgument resolveTypeArgument(@NotNull OCTypeArgument argument, @NotNull OCResolveContext context) {
        OCExpressionSymbol expressionSymbol;
        OCTypeArgument value;
        if (argument instanceof OCReferenceType) {
            Object prevValue = null;
            for (OCSymbol symbol : context.resolveToSymbols(((OCReferenceType)argument).getReference(context))) {
                Object value2 = OCExpressionEvaluator.evaluate(symbol, context);
                if (value2 == null) {
                    prevValue = null;
                    break;
                }
                if (prevValue != null && !value2.equals(prevValue)) {
                    return new OCExpressionTypeArgument(new OCUnknownExpressionSymbol(null, 0L));
                }
                prevValue = value2;
            }
            if (prevValue != null) {
                return new OCExpressionTypeArgument(new OCLiteralExpressionSymbol(prevValue, null, null));
            }
        }
        if (argument instanceof OCType) {
            argument = ((OCType)argument).transformType(new OCTypeResolveVisitor(context));
        } else if (argument instanceof OCExpressionTypeArgument && (value = (expressionSymbol = ((OCExpressionTypeArgument)argument).getSymbol()).evaluateToTypeArgument(context)) != null) {
            return value;
        }
        return argument;
    }

    public static OCTypeUnificationVisitor.UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext context) {
        return OCSimpleTypeSubstitution.unify(parameter, argument, null, substitutionMap, null, false, false, context);
    }

    public static OCTypeUnificationVisitor.UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @Nullable OCTypeOwner expression, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @Nullable Set<OCTypeParameterSymbol> dependentTypes, boolean functionParametersMode, boolean isVariadicMode, @NotNull OCResolveContext context) {
        return new OCTypeUnificationVisitor(functionParametersMode, true, isVariadicMode, true, false, argument, expression, substitutionMap, dependentTypes, context).unify(parameter, argument);
    }

    public static OCTypeUnificationVisitor.UnificationResult unifyByFunctionArgument(@Nullable OCFunctionSymbol function, @NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @Nullable OCTypeOwner expression, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @Nullable Set<OCTypeParameterSymbol> dependentTypes, boolean isVariadicMode, @NotNull OCResolveContext context) {
        OCTypeUnificationVisitor visitor = new OCTypeUnificationVisitor(true, true, isVariadicMode, true, false, argument, expression, substitutionMap, dependentTypes, context);
        if (function != null && !function.isFriend()) {
            visitor.setUnifiableTypeParameters(new HashSet<OCTypeParameterSymbol>(function.getTemplateParameters()));
            if (function instanceof OCDeductionCandidateSymbol) {
                visitor.setCTADParameters(new HashSet<OCTypeParameterSymbol>(((OCDeductionCandidateSymbol)function).getCTADParameters()));
            }
        }
        return visitor.unify(parameter, argument);
    }

    @NotNull
    String substList() {
        Map<OCTypeParameterSymbol, OCTypeArgument> substitutions = this.mySubstitutions;
        Function converter = entry -> {
            Object valueString;
            String keyString = ((OCTypeParameterSymbol)entry.getKey()).toString();
            keyString = keyString.substring(keyString.indexOf(91));
            OCTypeArgument value = (OCTypeArgument)entry.getValue();
            if (value instanceof OCTypeParameterType) {
                valueString = ((OCTypeParameterType)value).getSymbol().toString();
                valueString = "<param>" + ((String)valueString).substring(((String)valueString).indexOf(91));
            } else if (value instanceof OCExpressionTypeArgument) {
                valueString = ((OCExpressionTypeArgument)value).getSymbol().toString();
                valueString = "<value>" + ((String)valueString).substring(((String)valueString).indexOf(91));
            } else {
                valueString = value.toString();
            }
            return keyString + " -> " + (String)valueString;
        };
        return StringUtil.join((Collection)ContainerUtil.map(substitutions.entrySet(), (Function)converter), (String)", ");
    }

    public String toString() {
        return "{" + this.substList() + "}";
    }

    public int hashCode() {
        return this.mySubstitutions.hashCode();
    }
}

