/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCLocalTypes;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceTypeBuilder {
    private boolean myConst = false;
    private boolean myVolatile = false;
    @Nullable
    private OCNullability myNullability;
    @NotNull
    private final OCSymbolReference myReference;
    private String @NotNull [] myProtocolNames = ArrayUtilRt.EMPTY_STRING_ARRAY;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private ARCAttribute myARCAttribute = null;
    private boolean myFunctionParameterType = false;
    private boolean myIsKindof = false;

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name, @Nullable OCSymbolWithQualifiedName globalContext, @Nullable VirtualFile file, long complexOffset, boolean isBaseClause, boolean isInsideTemplateArguments, boolean isSpecialization, boolean skipBaseClasses) {
        this(OCReferenceTypeBuilder.makeGlobalReference(name, globalContext, file, complexOffset, isBaseClause, isInsideTemplateArguments, isSpecialization, skipBaseClasses));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name, @Nullable PsiElement localContext, @Nullable OCSymbolWithQualifiedName globalContext, boolean isBaseClause, @Nullable VirtualFile file, long complexOffset) {
        this(OCReferenceTypeBuilder.tryMakeLocalReference(name, localContext, globalContext, isBaseClause, file, complexOffset));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name, @Nullable PsiElement localContext, @Nullable VirtualFile file) {
        this(OCReferenceTypeBuilder.tryMakeLocalReference(name, localContext, null, false, file, -1L));
    }

    public OCReferenceTypeBuilder(@NotNull OCSymbolReference reference) {
        this.myReference = reference;
    }

    @NotNull
    private static OCSymbolReference makeGlobalReference(@NotNull OCQualifiedName name, @Nullable OCSymbolWithQualifiedName globalContext, @Nullable VirtualFile file, long complexOffset, boolean isBaseClause, boolean isInsideTemplateArguments, boolean isSpecialization, boolean skipBaseClasses) {
        if (isBaseClause) {
            return OCSymbolReference.getBaseClauseReference(name, globalContext, file, complexOffset);
        }
        if (isInsideTemplateArguments) {
            return OCSymbolReference.getTemplateArgsReference(name, globalContext, file, complexOffset, isSpecialization, skipBaseClasses);
        }
        return OCSymbolReference.getGlobalReference(name, globalContext, file, complexOffset);
    }

    @NotNull
    private static OCSymbolReference tryMakeLocalReference(@NotNull OCQualifiedName name, @Nullable PsiElement localContext, @Nullable OCSymbolWithQualifiedName globalContext, boolean isBaseClause, @Nullable VirtualFile virtualFile, long complexOffset) {
        PsiElement adjustedStruct;
        long adjustedOffset;
        PsiFile maybeOCFile;
        Boolean local = false;
        if (localContext != null && (maybeOCFile = InjectedLanguageManager.getInstance((Project)localContext.getProject()).getTopLevelFile((PsiElement)localContext.getContainingFile())) instanceof OCPsiFile) {
            OCFile file = ((OCPsiFile)maybeOCFile).getOCFile();
            virtualFile = OCElementUtil.getVirtualFile(localContext);
            local = OCLocalTypes.canBeLocalType(file, name);
            if (local == null) {
                local = PsiTreeUtil.getTopmostParentOfType((PsiElement)localContext, OCCallable.class) != null;
            } else if (OCLocalTypes.hasLocalUsingStatement(file, (OCCallable)PsiTreeUtil.getTopmostParentOfType((PsiElement)localContext, OCCallable.class))) {
                local = true;
            }
        }
        if (local.booleanValue()) {
            return OCSymbolReference.getLocalReference(name, localContext);
        }
        if (globalContext == null) {
            globalContext = OCSymbolReferenceResolver.getGlobalContextFromLocal(localContext);
        }
        long l = adjustedOffset = (adjustedStruct = OCSymbolReferenceResolver.getAdjustedScope(localContext)) == null ? complexOffset : OCSymbolOffsetUtil.getComplexRange(adjustedStruct).getEndOffset();
        if (isBaseClause) {
            return OCSymbolReference.getBaseClauseReference(name, globalContext, virtualFile, complexOffset);
        }
        if (localContext != null && localContext.getParent() instanceof OCTemplateArgumentList) {
            boolean isSpecialization = localContext.getParent().getParent() instanceof OCStruct;
            return OCSymbolReference.getTemplateArgsReference(name, globalContext, virtualFile, adjustedOffset, isSpecialization, isSpecialization);
        }
        return OCSymbolReference.getGlobalReference(name, globalContext, virtualFile, adjustedOffset);
    }

    @NotNull
    public OCReferenceTypeBuilder setSingleProtocolName(@NotNull String protocolName) {
        return this.setProtocolNames(new String[]{protocolName});
    }

    @NotNull
    public OCReferenceTypeBuilder setProtocolNames(String @NotNull [] protocolNames) {
        this.myProtocolNames = protocolNames;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setSubstitution(@NotNull OCTypeSubstitution substitution) {
        this.mySubstitution = substitution;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setARCAttribute(@Nullable ARCAttribute arcAttribute) {
        this.myARCAttribute = arcAttribute;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setProtocolSubstitutionARCFromType(@NotNull OCReferenceType fromType) {
        this.setProtocolNames(fromType.getProtocolNames());
        this.setSubstitution(fromType.getSubstitution());
        this.setARCAttribute(fromType.getARCAttribute());
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setConstVolatile(boolean isConst, boolean isVolatile) {
        this.myConst = isConst;
        this.myVolatile = isVolatile;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setConstVolatile(@NotNull OCType fromType) {
        return this.setConstVolatile(fromType.isConst(), fromType.isVolatile());
    }

    @NotNull
    public OCReferenceTypeBuilder setNullability(@Nullable OCNullability nullability) {
        this.myNullability = nullability;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
        return this;
    }

    public void setIsKindof(boolean isKindof) {
        this.myIsKindof = isKindof;
    }

    @NotNull
    public OCReferenceType build() {
        return OCReferenceType.create(this.myConst, this.myVolatile, this.myReference, this.myProtocolNames, this.mySubstitution, this.myARCAttribute, this.myNullability, this.myFunctionParameterType, this.myIsKindof);
    }
}

