/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.ArcAnnotatedType;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCReferenceTypeFull;
import com.jetbrains.cidr.lang.types.OCReferenceTypeSimple;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCReferenceType
extends OCType
implements Serializable,
ArcAnnotatedType {
    @NotNull
    private OCSymbolReference myReference;
    private boolean myIsKindof;
    private boolean myFunctionParameterType = false;

    @NotNull
    public static OCReferenceType create(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, String @NotNull [] protocolNames, @NotNull OCTypeSubstitution substitution, @Nullable ARCAttribute arcAttribute, @Nullable OCNullability nullability, boolean functionParameterType, boolean isKindof) {
        if (protocolNames.length == 0 && substitution == OCTypeSubstitution.ID && arcAttribute == null) {
            return new OCReferenceTypeSimple(reference, isConst, isVolatile, nullability, functionParameterType, isKindof);
        }
        return new OCReferenceTypeFull(isConst, isVolatile, reference, protocolNames, substitution, arcAttribute, nullability, functionParameterType, isKindof);
    }

    protected OCReferenceType() {
    }

    protected OCReferenceType(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, @Nullable OCNullability nullability, boolean functionParameterType, boolean isKindof) {
        super(isConst, isVolatile, nullability);
        this.myReference = reference;
        this.myFunctionParameterType = functionParameterType;
        this.myIsKindof = isKindof;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceType f = (OCReferenceType)first;
        OCReferenceType s = (OCReferenceType)second;
        if (f.getARCAttribute() != s.getARCAttribute()) {
            return false;
        }
        if (f.myIsKindof != s.myIsKindof) {
            return false;
        }
        if (!Arrays.equals(f.getProtocolNames(), s.getProtocolNames())) {
            return false;
        }
        if (!c.equalObjects(f.myReference, s.myReference)) {
            return false;
        }
        return c.equalObjects(f.getSubstitution(), s.getSubstitution());
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + this.myReference.hashCode();
        result = 31 * result + Objects.hashCode((Object)this.getARCAttribute());
        result = 31 * result + Arrays.hashCode(this.getProtocolNames());
        result = 31 * result + this.getSubstitution().hashCode();
        result = 31 * result + Boolean.valueOf(this.myIsKindof).hashCode();
        return result;
    }

    public abstract String @NotNull [] getProtocolNames();

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        return true;
    }

    @NotNull
    public abstract OCTypeSubstitution getSubstitution();

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull PsiElement context) {
        return OCReferenceType.fromText(name).resolve(context);
    }

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull OCResolveContext context) {
        return OCReferenceType.fromText(name).resolve(context);
    }

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull @NonNls String protocolName, @NotNull PsiElement context) {
        return OCReferenceType.fromText(name, protocolName).resolve(context);
    }

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull @NonNls String protocolName, @NotNull OCResolveContext context) {
        return OCReferenceType.fromText(name, protocolName).resolve(context);
    }

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull OCResolveContext context, boolean ignoreImports) {
        return OCReferenceType.fromText(name).resolve(context, ignoreImports);
    }

    @NotNull
    public static OCReferenceType fromText(@NonNls @Nullable String name) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).build();
    }

    @NotNull
    public static OCReferenceType fromText(@NonNls @NotNull String name, @NotNull String protocolName) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).setSingleProtocolName(protocolName).build();
    }

    @NotNull
    public static OCReferenceType fromText(@NonNls @NotNull String name, String @NotNull [] protocolNames) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).setProtocolNames(protocolNames).build();
    }

    public static OCReferenceType fromQualifiedName(OCQualifiedName name) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(name)).build();
    }

    @NotNull
    public abstract OCReferenceType cloneWithReference(@NotNull OCSymbolReference var1);

    @NotNull
    public OCSymbolReference getReference() {
        return this.myReference;
    }

    @NotNull
    public OCSymbolReference getReference(@NotNull OCResolveContext context) {
        return this.getReference(context.getFile());
    }

    @NotNull
    public OCSymbolReference getReference(@Nullable PsiFile file) {
        OCLanguageKind kind = OCPsiFile.getKind(file);
        return this.getReference(kind == null || kind.isObjC());
    }

    @NotNull
    public OCSymbolReference getReference(boolean maybeObjC) {
        return this.myReference;
    }

    @Override
    protected String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint, int templateDepth) {
        if (nameHint == null) {
            nameHint = CVQualifiers.appendCVQualifiers(this.myReference.getQualifiedName().getFullName(context), this, context.getProject());
        }
        return super.getBestNameInContext(context, nameHint, templateDepth);
    }

    @Override
    @Nullable
    public abstract ARCAttribute getARCAttribute();

    @Override
    @NotNull
    public OCReferenceType cloneWithArcAttribute(@Nullable ARCAttribute arcAttribute) {
        return OCReferenceType.create(this.isConst(), this.isVolatile(), this.getReference(), this.getProtocolNames(), this.getSubstitution(), arcAttribute, this.getNullability(), this.isFunctionParameterType(), this.isKindof());
    }

    public boolean isFunctionParameterType() {
        return this.myFunctionParameterType;
    }

    public void setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }

    public boolean hasElaboratedTypeSpecifier() {
        return OCSymbolReference.removeTypeToken((String)this.myReference.getQualifiedName().getName()).typeToken != null;
    }
}

