/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNumber;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIntType
extends OCNumericType {
    public static final OCIntType BOOL = new OCIntType(true, CTypeId.SIGNED_CHAR, "signed char", "%d");
    public static final OCIntType BOOLEAN = new OCIntType(false, CTypeId.CHAR, "unsigned char", "%d");
    public static final OCIntType BOOL_NATIVE = new OCIntType(true, CTypeId.BOOL, "bool", "%d");
    public static final OCIntType CHAR = new OCIntType(true, CTypeId.CHAR, "char", "%c");
    public static final OCIntType CHAR_CONST = new OCIntType(true, CTypeId.CHAR, "char", "%c", true, false);
    public static final OCIntType SCHAR = new OCIntType(true, CTypeId.SIGNED_CHAR, "signed char", "%c");
    public static final OCIntType UCHAR = new OCIntType(false, CTypeId.CHAR, "unsigned char", "%c");
    public static final OCIntType WCHAR = new OCIntType(true, CTypeId.WCHAR_T, "wchar_t", "%lc");
    public static final OCIntType WCHAR_CONST = new OCIntType(true, CTypeId.WCHAR_T, "wchar_t", "%lc", true, false);
    public static final OCIntType CHAR8 = new OCIntType(false, CTypeId.CHAR8_T, "char8_t", "%c");
    public static final OCIntType CHAR16 = new OCIntType(false, CTypeId.CHAR16_T, "char16_t", "%lc");
    public static final OCIntType CHAR16_CONST = new OCIntType(false, CTypeId.CHAR16_T, "char16_t", "%lc", true, false);
    public static final OCIntType CHAR32 = new OCIntType(false, CTypeId.CHAR32_T, "char32_t", "%lc");
    public static final OCIntType CHAR32_CONST = new OCIntType(false, CTypeId.CHAR32_T, "char32_t", "%lc", true, false);
    public static final OCIntType SHORT = new OCIntType(true, CTypeId.SHORT, "short", "%hi");
    public static final OCIntType USHORT = new OCIntType(false, CTypeId.SHORT, "unsigned short", "%hu");
    public static final OCIntType INT = new OCIntType(true, CTypeId.INT, "int", "%i");
    public static final OCIntType UINT = new OCIntType(false, CTypeId.INT, "unsigned int", "%u");
    public static final OCIntType LONG = new OCIntType(true, CTypeId.LONG, "long", "%li");
    public static final OCIntType ULONG = new OCIntType(false, CTypeId.LONG, "unsigned long", "%lu");
    public static final OCIntType LONGLONG = new OCIntType(true, CTypeId.LONG_LONG, "long long int", "%lli");
    public static final OCIntType ULONGLONG = new OCIntType(false, CTypeId.LONG_LONG, "unsigned long long int", "%llu");
    public static final OCIntType INT128 = new OCIntType(true, CTypeId.INT128_T, "__int128_t", "%ji");
    public static final OCIntType UINT128 = new OCIntType(false, CTypeId.INT128_T, "__uint128_t", "%ju");
    public static final OCIntType SSIZE_T = new OCIntType(true, CTypeId.SIZE_T, "ssize_t", "%zi");
    public static final OCIntType SIZE_T = new OCIntType(false, CTypeId.SIZE_T, "size_t", "%zu");
    public static final OCIntType PTRDIFF_T = new OCIntType(true, CTypeId.PTRDIFF_T, "ptrdiff_t", "%ti");
    public static final OCIntType __INT8 = new OCIntType(true, CTypeId.CHAR, "__int8", "%c");
    public static final OCIntType __UINT8 = new OCIntType(false, CTypeId.CHAR, "unsigned __int8", "%c");
    public static final OCIntType __INT16 = new OCIntType(true, CTypeId.SHORT, "__int16", "%hi");
    public static final OCIntType __UINT16 = new OCIntType(false, CTypeId.SHORT, "unsigned __int16", "%hu");
    public static final OCIntType __INT32 = new OCIntType(true, CTypeId.INT, "__int32", "%i");
    public static final OCIntType __UINT32 = new OCIntType(false, CTypeId.INT, "unsigned __int32", "%u");
    public static final OCIntType __INT64 = new OCIntType(true, CTypeId.LONG_LONG, "__int64", "%lli");
    public static final OCIntType __UINT64 = new OCIntType(false, CTypeId.LONG_LONG, "unsigned __int64", "%llu");
    public static final OCIntType __WCHAR_T = new OCIntType(true, CTypeId.WCHAR_T, "__wchar_t", "%lc");
    private static final List<OCIntType> UNSIGNED_BASIC_TYPES = Arrays.asList(UINT, UCHAR, USHORT, ULONG, ULONGLONG, UINT128);
    private static final List<OCIntType> SIGNED_BASIC_TYPES = Arrays.asList(INT, SCHAR, SHORT, LONG, LONGLONG, INT128);
    private boolean myIsSigned;
    private String myText;
    private String myFormatString;

    public static boolean isBool(OCType type, @NotNull OCResolveContext context) {
        return BOOL.equalsWithAliasName(type, context) || BOOLEAN.equalsWithAliasName(type, context) || BOOL_NATIVE.equalsWithAliasName(type, context);
    }

    public static OCIntType getAppropriateBool(boolean isObjC) {
        return isObjC ? BOOL : BOOL_NATIVE;
    }

    public static OCIntType getAppropriateBool(@Nullable PsiElement element) {
        return OCIntType.getAppropriateBool(OCCodeInsightUtil.isInObjC(element));
    }

    @Override
    public int getRank(@NotNull OCResolveContext context) {
        int byteCount;
        return (byteCount << 3) + ((byteCount = this.getSizeInBytes(context.getFile(), null, context.getProject())) > 1 && this.isSigned() ? 0 : 1);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCIntType f = (OCIntType)first;
        OCIntType s = (OCIntType)second;
        if (f.myIsSigned != s.myIsSigned) {
            return false;
        }
        if (!Objects.equals(f.myFormatString, s.myFormatString)) {
            return false;
        }
        if (!Objects.equals(f.myText, s.myText)) {
            return false;
        }
        return f.myTypeId.equals((Object)s.myTypeId);
    }

    public OCIntType() {
    }

    private OCIntType(boolean isSigned, CTypeId w, @NonNls @NotNull String text, @NonNls @NotNull String formatString) {
        this(isSigned, w, text, formatString, false, false);
    }

    private OCIntType(boolean isSigned, CTypeId w, @NonNls @NotNull String text, @NonNls @NotNull String formatString, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myIsSigned = isSigned;
        this.myTypeId = w;
        this.myText = text;
        this.myFormatString = formatString;
    }

    @NotNull
    public List<OCIntType> getBasicTypes() {
        return this.isSigned() ? SIGNED_BASIC_TYPES : UNSIGNED_BASIC_TYPES;
    }

    public OCIntType cloneType(boolean isConst, boolean isVolatile) {
        return new OCIntType(this.isSigned(), this.getCTypeId(), this.getText(), this.getFormatString(), isConst, isVolatile);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitIntType(this);
    }

    @Override
    public boolean isSigned() {
        return this.myIsSigned;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isChar() {
        return CTypeId.CHAR.equals((Object)this.myTypeId);
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public boolean isIntegerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    @NotNull
    public String getFormatString() {
        return this.myFormatString;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.myIsSigned ? 1 : 0);
    }

    @NotNull
    public static OCIntType literalType(@NotNull String text, @Nullable PsiElement element, @NotNull Project project) {
        if ("TRUE".equals(text = StringUtil.toUpperCase((String)text)) || "FALSE".equals(text)) {
            return BOOL;
        }
        return (OCIntType)OCElementUtil.parseInteger((String)text, (PsiElement)element, null, (Project)project).first;
    }

    public boolean canRepresent(@NotNull OCNumber value, @NotNull PsiElement element) {
        if (value.isSigned() && value.signum() == -1 && !this.myIsSigned) {
            return false;
        }
        int valueBitLength = value.bitLength();
        int typeBitLength = this.getBits(element, null, element.getProject()) - (this.myIsSigned ? 1 : 0);
        return valueBitLength <= typeBitLength;
    }

    @Override
    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context) {
        return this.getValue(false, context);
    }

    public String getValue(boolean value, @NotNull OCResolveContext context) {
        if (Objects.equals(this.myAliasName, "BOOL")) {
            return value ? "YES" : "NO";
        }
        if (Objects.equals(this.myAliasName, "Boolean") || context.isCpp() && Objects.equals(this.myAliasName, "bool")) {
            return value ? "true" : "false";
        }
        return value ? "1" : "0";
    }

    @NotNull
    public OCIntType promoteToSigned(@NotNull OCResolveContext context) {
        if (this.myIsSigned) {
            return this;
        }
        if (this.myTypeId.ordinal() <= CTypeId.INT.ordinal()) {
            return INT;
        }
        if (this.equals(ULONG, context)) {
            return LONG;
        }
        return LONGLONG;
    }

    static {
        BOOL.attachAliasName("BOOL");
        BOOLEAN.attachAliasName("Boolean");
        BOOL_NATIVE.attachAliasName("bool");
        SIZE_T.attachAliasName("std::size_t");
        PTRDIFF_T.attachAliasName("std::ptrdiff_t");
        INT128.attachAliasName("__int128");
        assert (UNSIGNED_BASIC_TYPES.size() == SIGNED_BASIC_TYPES.size());
        for (Pair intTypePair : ContainerUtil.zip(UNSIGNED_BASIC_TYPES, SIGNED_BASIC_TYPES)) {
            assert (((OCIntType)intTypePair.first).getCTypeId().getDefaultTypeSize() == ((OCIntType)intTypePair.second).getCTypeId().getDefaultTypeSize());
        }
    }
}

