/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBlockPointerType
extends OCPointerType {
    public OCBlockPointerType() {
    }

    public OCBlockPointerType(OCType refType, ARCAttribute attribute, @Nullable OCNullability nullability, boolean isConst, boolean isVolatile) {
        super(refType, attribute, null, nullability, isConst, isVolatile);
    }

    public static OCBlockPointerType blockPtr(@NotNull OCType refType) {
        return OCBlockPointerType.blockPtr(refType, null, false, false);
    }

    public static OCBlockPointerType blockPtr(@NotNull OCType refType, ARCAttribute attribute, boolean isConst, boolean isVolatile) {
        return OCBlockPointerType.blockPtr(refType, attribute, null, isConst, isVolatile);
    }

    public static OCBlockPointerType blockPtr(@NotNull OCType refType, ARCAttribute attribute, @Nullable OCNullability nullability, boolean isConst, boolean isVolatile) {
        return new OCBlockPointerType(refType, attribute, nullability, isConst, isVolatile);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitBlockPointerType(this);
    }

    @Override
    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context) {
        OCType ref = this.getRefType();
        if (ref instanceof OCFunctionType) {
            List<OCType> argumentTypes;
            OCFunctionType fun = (OCFunctionType)ref;
            StringBuilder builder2 = new StringBuilder();
            builder2.append("^");
            OCType returnType = fun.getReturnType();
            String returnTypeName = returnType.getName();
            if (!"void".equals(returnTypeName)) {
                builder2.append(returnTypeName);
            }
            if (!(argumentTypes = fun.getParameterTypes()).isEmpty()) {
                builder2.append("(");
                List<String> names = fun.getParameterNames();
                for (int i = 0; i < argumentTypes.size(); ++i) {
                    PsiElement element;
                    String name;
                    if (i > 0) {
                        builder2.append(", ");
                    }
                    OCType argType = argumentTypes.get(i);
                    String string = name = names != null ? names.get(i) : "<unnamed>";
                    if ("<unnamed>".equals(name)) {
                        Collection<String> possibilities = OCNameSuggester.suggestForType(argType, null, Collections.emptyList(), context);
                        String string2 = name = possibilities.isEmpty() ? "" : (String)ContainerUtil.getFirstItem(possibilities);
                    }
                    if ((element = context.getElement()) == null) continue;
                    builder2.append(OCElementFactory.declarationText(name != null ? name : "", argType, element));
                }
                builder2.append(") ");
            }
            builder2.append("{\n");
            if (!returnType.isVoid()) {
                builder2.append("return ");
                builder2.append(returnType.getDefaultValue(context));
                builder2.append(";\n");
            }
            builder2.append("}");
            return builder2.toString();
        }
        return super.getDefaultValue(context);
    }
}

