/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineOption;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParserException;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public interface CidrCommandLineParser {
    public static final ProjectExtensionPointName<CidrCommandLineParser> CIDR_COMMAND_LINE_PARSER = new ProjectExtensionPointName("com.intellij.cidrCommandLineParser");
    public static final CidrCommandLineParser DUMMY_PARSER = new DummyCommandLineParser();

    @NotNull
    public CompletableFuture<List<CidrCommandLineOption>> parse(OCCompilerKind var1, @NotNull List<String> var2);

    @NotNull
    public List<CidrCommandLineOption> parseSync(OCCompilerKind var1, @NotNull List<String> var2) throws CidrCommandLineParserException;

    @NotNull
    public static CidrCommandLineParser getParser(@NotNull Project project) {
        if (project.isDefault()) {
            return DUMMY_PARSER;
        }
        return CIDR_COMMAND_LINE_PARSER.extensions((AreaInstance)project).findFirst().orElse(DUMMY_PARSER);
    }

    public static class DummyCommandLineParser
    implements CidrCommandLineParser {
        @Override
        @NotNull
        public CompletableFuture<List<CidrCommandLineOption>> parse(OCCompilerKind compiler, @NotNull List<String> switches) {
            return CompletableFuture.completedFuture(ContainerUtil.emptyList());
        }

        @Override
        @NotNull
        public List<CidrCommandLineOption> parseSync(OCCompilerKind compiler, @NotNull List<String> switches) {
            return ContainerUtil.emptyList();
        }
    }
}

