/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.MaybeVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.OCSerializer;
import org.jetbrains.annotations.NotNull;

public class MaybeFileOwnerSerializer<T extends MaybeVirtualFileOwner>
extends FieldSerializer<T> {
    private final FileSymbolTableSerializer mySerializer;

    public MaybeFileOwnerSerializer(@NotNull FileSymbolTableSerializer serializer, @NotNull Class<T> symbolClass) {
        super(serializer.getKryo(), symbolClass);
        this.mySerializer = serializer;
    }

    public void write(Kryo kryo, Output output2, T object) {
        output2.writeBoolean(object.getContainingFile() != null);
        super.write(kryo, output2, object);
    }

    @NotNull
    protected final T create(Kryo kryo, Input input2, Class<T> type) {
        boolean hasFile = input2.readBoolean();
        T result = this.createInstance(kryo, input2, type);
        result.init(hasFile ? this.mySerializer.getCurrentFile() : null);
        return result;
    }

    @NotNull
    protected final T createCopy(Kryo kryo, T original) {
        MaybeVirtualFileOwner result = (MaybeVirtualFileOwner)super.createCopy(kryo, original);
        VirtualFile file = original.getContainingFile();
        OCSerializer.LOG.assertTrue(file == null || file.equals(this.mySerializer.getCurrentFile()));
        result.init(file);
        return (T)result;
    }

    public final T createInstance(Kryo kryo, Input input2, Class<T> type) {
        return (T)((MaybeVirtualFileOwner)super.create(kryo, input2, type));
    }
}

