/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializer;
import org.jetbrains.annotations.NotNull;

public class GlobalReferenceSerializer<T extends OCSymbolReference.GlobalReference>
extends FieldSerializer<T> {
    private final FileSymbolTableSerializer mySerializer;

    public GlobalReferenceSerializer(@NotNull FileSymbolTableSerializer serializer, @NotNull Class<T> type) {
        super(serializer.getKryo(), type);
        this.mySerializer = serializer;
    }

    public T read(Kryo kryo, Input input2, Class<T> type) {
        OCSymbolReference.GlobalReference object = (OCSymbolReference.GlobalReference)super.read(kryo, input2, type);
        boolean storesVirtualFile = input2.readBoolean();
        if (storesVirtualFile) {
            object.setVirtualFileOrSymbolContext(this.mySerializer.getCurrentFile());
        } else {
            Object symbol = kryo.readClassAndObject(input2);
            if (symbol != null) {
                OCLog.LOG.assertTrue(symbol instanceof OCSymbolWithQualifiedName, (Object)("Wrong symbol in reference: " + symbol.getClass()));
            }
            object.setVirtualFileOrSymbolContext(symbol);
        }
        return (T)object;
    }

    public void write(Kryo kryo, Output output2, T object) {
        super.write(kryo, output2, object);
        Object fileOrContext = ((OCSymbolReference.GlobalReference)object).getVirtualFileOrSymbolContext();
        boolean storesVirtualFile = fileOrContext instanceof VirtualFile;
        output2.writeBoolean(storesVirtualFile);
        if (!storesVirtualFile) {
            kryo.writeClassAndObject(output2, fileOrContext);
        }
    }
}

