/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCActivityLog;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.zipcache.CidrZipBackedCache;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SymbolBuildingTask
extends DumbModeTask {
    @NotNull
    private final String myActivityName;
    @NotNull
    private final Project myProject;
    private volatile boolean myShouldCancel = true;

    public SymbolBuildingTask(@NotNull @NonNls String activityName, @NotNull Project project) {
        this.myActivityName = activityName;
        this.myProject = project;
    }

    @Nullable
    public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
        if (taskFromQueue.getClass().equals(((Object)((Object)this)).getClass()) && ((SymbolBuildingTask)taskFromQueue).myActivityName.equals(this.myActivityName) && ((SymbolBuildingTask)taskFromQueue).myProject.equals(this.myProject)) {
            return this;
        }
        return null;
    }

    @NotNull
    public static SymbolBuildingTask runSymbolActivity(@NonNls @NotNull String activityName, @NotNull Project project, final @NotNull Consumer<? super OCBuildingActivityProgressIndicator> task) {
        SymbolBuildingTask buildingTask = new SymbolBuildingTask(activityName, project){

            @Override
            protected void process(@NotNull OCBuildingActivityProgressIndicator indicator) {
                task.accept(indicator);
            }
        };
        buildingTask.runSymbolActivity();
        return buildingTask;
    }

    protected abstract void process(@NotNull OCBuildingActivityProgressIndicator var1);

    boolean shouldCancel() {
        return this.myShouldCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInDumbMode(@NotNull ProgressIndicator original) {
        OCBuildingActivityProgressIndicator indicator = new OCBuildingActivityProgressIndicator(original);
        Disposable cancelOnProjectDispose = () -> {
            if (this.myShouldCancel) {
                indicator.cancel();
            }
        };
        try {
            long start = System.currentTimeMillis();
            OCActivityLog.log(this.myProject, this.myActivityName + " " + start + ": START");
            Disposer.register((Disposable)OCSymbolTablesBuildingActivity.getInstance(this.myProject), (Disposable)cancelOnProjectDispose);
            this.process(indicator);
            this.myShouldCancel = false;
            OCActivityLog.log(this.myProject, this.myActivityName + " " + start + ": END after " + (System.currentTimeMillis() - start));
        }
        catch (ProcessCanceledException pce) {
            if (indicator.isCanceled()) {
                throw pce;
            }
            this.reportUnexpectedException(pce);
        }
        catch (Throwable t) {
            this.reportUnexpectedException(t);
        }
        finally {
            Disposer.dispose((Disposable)cancelOnProjectDispose);
        }
    }

    private void reportUnexpectedException(Throwable t) {
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return;
        }
        Throwable e = t instanceof ProcessCanceledException ? new RuntimeException(t) : t;
        OCLog.LOG.error("Unexpected exception during symbol building (" + this.myActivityName + ")", e);
        if (CidrZipBackedCache.buildingCache) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public void runSymbolActivity() {
        Application app = ApplicationManager.getApplication();
        if (app.isHeadlessEnvironment() && app.isWriteAccessAllowed()) {
            this.scheduleTaskAfterWriteAction(app);
        } else {
            DumbService.getInstance((Project)this.myProject).queueTask((DumbModeTask)this);
        }
    }

    private void scheduleTaskAfterWriteAction(@NotNull Application app) {
        final Disposable listenerDisposable = Disposer.newDisposable();
        final AtomicBoolean isHandled = new AtomicBoolean();
        app.addApplicationListener(new ApplicationListener(){

            public void afterWriteActionFinished(@NotNull Object action) {
                if (isHandled.getAndSet(true)) {
                    return;
                }
                Disposer.dispose((Disposable)listenerDisposable);
                SymbolBuildingTask.this.queue(SymbolBuildingTask.this.myProject);
            }
        }, listenerDisposable);
    }
}

