/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.google.common.collect.ImmutableListMultimap;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCWorkerActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.RecursiveSymbolBuilding;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCSymbolTableBuildingUtil {
    @Nullable
    private static NotNullProducer<? extends ProgressIndicator> ourIndicatorFactory;

    @TestOnly
    public static void setIndicatorFactory(@Nullable NotNullProducer<? extends ProgressIndicator> indicatorFactory) {
        ourIndicatorFactory = indicatorFactory;
    }

    @NotNull
    private static ProgressIndicator createCancelableLoopIndicator(@NotNull ProgressIndicator mainIndicator) {
        NotNullProducer<? extends ProgressIndicator> indicatorFactory = ourIndicatorFactory;
        return indicatorFactory != null ? (ProgressIndicator)indicatorFactory.produce() : new SensitiveProgressWrapper(mainIndicator){

            protected boolean isReuseable() {
                return true;
            }
        };
    }

    @NotNull
    static Runnable withCustomLoopIndicator(@NotNull Runnable action) {
        NotNullProducer<? extends ProgressIndicator> indicatorFactory = ourIndicatorFactory;
        return indicatorFactory != null ? () -> ProgressManager.getInstance().runProcess(action, (ProgressIndicator)indicatorFactory.produce()) : action;
    }

    @NotNull
    static <T> Callable<T> withCustomLoopIndicator(@NotNull Callable<T> action) {
        NotNullProducer<? extends ProgressIndicator> indicatorFactory = ourIndicatorFactory;
        return indicatorFactory != null ? () -> {
            Object result = ProgressManager.getInstance().runProcess(() -> {
                try {
                    return action.call();
                }
                catch (Exception e) {
                    return e;
                }
            }, (ProgressIndicator)indicatorFactory.produce());
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            return result;
        } : action;
    }

    public static void runCancelableReadAction(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Runnable runnable) {
        ReadAction.nonBlocking((Runnable)OCSymbolTableBuildingUtil.withCustomLoopIndicator(runnable)).expireWith((Disposable)OCSymbolTablesBuildingActivity.getInstance(project)).wrapProgress(indicator).executeSynchronously();
    }

    public static <T> T runCancelableReadAction(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Callable<T> callable) {
        return (T)ReadAction.nonBlocking(OCSymbolTableBuildingUtil.withCustomLoopIndicator(callable)).expireWith((Disposable)OCSymbolTablesBuildingActivity.getInstance(project)).wrapProgress(indicator).executeSynchronously();
    }

    static void invokeAndWaitSafely(@NotNull ProgressIndicator indicator, @NotNull Runnable runnable) {
        Semaphore s = new Semaphore(1);
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> WriteAction.run(() -> {
            try {
                runnable.run();
            }
            finally {
                s.up();
            }
        }));
        ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)s, (ProgressIndicator)indicator);
    }

    static <T> void processRecursiveTasks(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator, double from, double to, @NotNull ImmutableListMultimap<Object, T> clusters, @NotNull BiFunction<? super ProgressIndicator, ? super ProgressIndicator, RecursiveSymbolBuilding<T>> symbolBuildingProvider) {
        OCSymbolTableBuildingUtil.processWithWriteActionPriority((ProgressIndicator)indicator, project, (Consumer<? super ProgressIndicator>)((Consumer)localIndicator -> {
            RecursiveSymbolBuilding symbolBuilding = (RecursiveSymbolBuilding)symbolBuildingProvider.apply((ProgressIndicator)indicator, (ProgressIndicator)localIndicator);
            OCWorkerActivity.runWithProgress(indicator, symbolBuilding.getIndicatorText(), from, to, () -> symbolBuilding.process(clusters));
        }));
    }

    private static void processWithWriteActionPriority(@NotNull ProgressIndicator globalIndicator, @NotNull Project project, @NotNull Consumer<? super ProgressIndicator> runnable) {
        final ProgressIndicator localProgress = OCSymbolTableBuildingUtil.createCancelableLoopIndicator(globalIndicator);
        ProgressManager.getInstance().runProcess(() -> {
            if (project.isDisposed()) {
                return;
            }
            ApplicationListener applicationListener = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    localProgress.cancel();
                }

                public void writeActionFinished(@NotNull Object action) {
                    if (localProgress.isRunning()) {
                        localProgress.stop();
                    }
                    localProgress.start();
                }
            };
            Disposable listenerDisposable = Disposer.newDisposable();
            ApplicationManager.getApplication().addApplicationListener(applicationListener, listenerDisposable);
            try {
                runnable.consume((Object)localProgress);
            }
            finally {
                Disposer.dispose((Disposable)listenerDisposable);
            }
        }, localProgress);
    }
}

