/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCSymbolLoadingActivity {
    static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        Project project = userData.getProject();
        indicator.setText(OCBundle.message("symbol.table.activity.loading.symbols", new Object[0]));
        indicator.startTiming("Loading symbols");
        Collection<VirtualFile> allFiles = Objects.requireNonNull(userData.getAllFiles());
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        long loadedFileCount = 0L;
        if (userData.getMode() != OCSymbolTablesBuildingMode.FULL) {
            loadedFileCount = cache.deserializeTables(Objects.requireNonNull(userData.getLocationHash()), allFiles, (ProgressIndicator)indicator, 0.25);
        }
        userData.setLoadedFraction(indicator.getFraction());
        userData.setSavingFraction(1.0 - 0.1 * (double)((long)allFiles.size() - loadedFileCount) / (double)Math.max(1, allFiles.size()));
        OCLog.LOG.info("Loaded " + OCSymbolLoadingActivity.getAllTablesCount(cache) + " tables for " + cache.getCachedFiles().size() + " files (" + loadedFileCount + " project files)");
        indicator.logTiming();
    }

    @NotNull
    public static Collection<VirtualFile> getFilesToBuildCachesForSafely(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        return OCSymbolTableBuildingUtil.runCancelableReadAction(project, indicator, () -> FileSymbolTablesCache.getInstance(project).getFilesToBuildTablesFor());
    }

    static int getAllTablesCount(@NotNull FileSymbolTablesCache cache) {
        Set<VirtualFile> files = cache.getCachedFiles();
        return OCSymbolLoadingActivity.getAllTablesCount(cache, files);
    }

    static int getAllTablesCount(@NotNull FileSymbolTablesCache cache, @NotNull Set<VirtualFile> files) {
        int result = 0;
        for (VirtualFile file : files) {
            result += cache.allTablesForFileCount(file);
        }
        return result;
    }
}

