/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.RootsWithConfigurations;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCWorkerActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCModuleMapDeserializationActivity {
    public static final Key<Boolean> DESERIALIZED_BUNDLED_MODULE_MAPS_ONLY = Key.create((String)"Deserialize bundled module maps only");

    public static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        Project project = userData.getProject();
        Ref ref = new Ref();
        try (CidrEventSpan ignored = new CidrEventSpan("moduleMaps", "getAllHeaderRootsForModuleMapBuilding", null);){
            OCWorkerActivity.runWithIndeterminateProgress(indicator, OCBundle.message("loading.headers.search.roots", new Object[0]), () -> {
                RootsWithConfigurations roots2 = OCModuleMapDeserializationActivity.getHeadersSearchRoots(indicator, project);
                ref.set((Object)roots2);
            });
        }
        ignored = new CidrEventSpan("moduleMaps", "deserialize", (Object)(((RootsWithConfigurations)ref.get()).getSize() + " root(s)"));
        try {
            Boolean bundledOnlyObject = (Boolean)userData.getUserData(DESERIALIZED_BUNDLED_MODULE_MAPS_ONLY);
            boolean bundledOnly = bundledOnlyObject != null && bundledOnlyObject != false;
            OCWorkerActivity.runWithProgress(indicator, OCBundle.message("loading.module.maps", new Object[0]), 0.0, 0.1, () -> ModuleMapSerializationService.getInstance(project).deserializeModuleMaps((ProgressIndicator)indicator, (RootsWithConfigurations)ref.get(), bundledOnly));
        }
        finally {
            ignored.close();
        }
    }

    @NotNull
    private static RootsWithConfigurations getHeadersSearchRoots(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull Project project) {
        return OCSymbolTableBuildingUtil.runCancelableReadAction(project, (ProgressIndicator)indicator, () -> {
            indicator.checkCanceled();
            ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project);
            HashMap<ModuleMapRoot, List> map2 = new HashMap<ModuleMapRoot, List>();
            for (OCResolveConfiguration configuration : OCWorkspace.getInstance((Project)project).getConfigurations()) {
                List<ModuleMapRoot> roots2 = moduleMapManager.cacheFor(configuration).getModuleMapRoots();
                for (ModuleMapRoot root : roots2) {
                    List configurations = map2.computeIfAbsent(root, k -> new ArrayList());
                    configurations.add(configuration);
                }
            }
            return new RootsWithConfigurations(map2);
        });
    }
}

