/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.ModuleMapBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapDeserializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapSerializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import com.jetbrains.cidr.lang.symbols.symtable.building.SymbolBuildingTask;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class OCModuleMapBuildingActivity {
    public static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        try (CidrEventSpan ignored = new CidrEventSpan("moduleMaps", "buildRemaining", null);){
            new ModuleMapBuildingActivity(userData.getProject(), indicator).buildModuleMaps();
        }
    }

    @TestOnly
    public static void rebuildModuleMaps(@NotNull Project project) {
        OCInitialBuildingInfo info = new OCInitialBuildingInfo(project, OCSymbolTablesBuildingMode.FAST);
        OCModuleMapBuildingActivity.rebuildModuleMaps(info);
    }

    @TestOnly
    public static void rebuildModuleMaps(@NotNull OCInitialBuildingInfo info) {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        Project project = info.getProject();
        SymbolBuildingTask.runSymbolActivity("rebuildModuleMaps", project, indicator -> {
            ModuleMapCache.getInstance(project).reset();
            ModuleMapManager.getInstance(project).clearCache();
            indicator.setIndeterminate(false);
            OCModuleMapDeserializationActivity.build(indicator, info);
            OCModuleMapBuildingActivity.build(indicator, info);
            OCModuleMapSerializationActivity.build(indicator, info);
        });
    }

    public static void buildModuleMapsFromScratch(@NotNull Project project) {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        OCInitialBuildingInfo info = new OCInitialBuildingInfo(project, OCSymbolTablesBuildingMode.FAST);
        info.putUserData(OCModuleMapDeserializationActivity.DESERIALIZED_BUNDLED_MODULE_MAPS_ONLY, true);
        OCModuleMapBuildingActivity.rebuildModuleMaps(info);
    }
}

