/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCWorkerActivity;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class OCHeaderMapLoadingActivity {
    OCHeaderMapLoadingActivity() {
    }

    static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        OCWorkerActivity.runWithProgress(indicator, OCBundle.message("symbol.table.activity.loading.header.maps", new Object[0]), 0.0, 1.0, () -> {
            indicator.checkCanceled();
            Project project = userData.getProject();
            OCHeaderMapManager.getInstance(project).load(OCHeaderMapLoadingActivity.getAllHeaderRoots(project, indicator));
        });
    }

    @NotNull
    static Set<HeadersSearchRoot> getAllHeaderRoots(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator) {
        return (Set)OCSymbolTableBuildingUtil.runCancelableReadAction(project, (ProgressIndicator)indicator, () -> OCWorkspace.getInstance((Project)project).getConfigurations().stream().flatMap(configuration -> configuration.getAllCompilerSettings()).flatMap(settings -> {
            ProgressManager.checkCanceled();
            return settings.getHeadersSearchRoots().getAllRoots().stream();
        }).collect(Collectors.toCollection(THashSet::new)));
    }
}

