/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.HashSetQueue;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableCacheListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolLoadedNotifier;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.SymbolBuildingTask;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTableUpdater {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final Project myProject;
    @NotNull
    private final UpdateQueue myRootQueue = new UpdateQueue();
    @NotNull
    private final UpdateQueue myIncludeQueue = new UpdateQueue();
    @NotNull
    private final AtomicBoolean myHugeUpdateRequested = new AtomicBoolean();
    @NotNull
    private final AtomicInteger myLastNotificationId = new AtomicInteger();
    @NotNull
    private final ThreadLocal<UpdateQueue> myParentQueue = new ThreadLocal();
    @NotNull
    private final CachedValue<Boolean> myQueueUpdater;

    public FileSymbolTableUpdater(@NotNull Project project) {
        this.myProject = project;
        this.myQueueUpdater = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance((Project)project).getModificationTrackers();
            return new CachedValueProvider.Result((Object)this.rebuildQueues(), new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
        }, false);
    }

    public void ensurePendingFilesProcessed(boolean rootsOnly) {
        ProgressManager pm = ProgressManager.getInstance();
        ProgressIndicator ci = pm.getProgressIndicator();
        if (ci == null) {
            EmptyProgressIndicator ind = new EmptyProgressIndicator();
            pm.runProcess(() -> this.update(rootsOnly), (ProgressIndicator)ind);
        } else {
            this.update(rootsOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(boolean rootsOnly) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        OCLog.LOG.assertTrue(indicator != null, (Object)"no progress indicator");
        UpdateQueue parentQueue = this.myParentQueue.get();
        if (parentQueue == this.myRootQueue) {
            throw new IllegalStateException("Nested updates are not allowed for root files.");
        }
        if (parentQueue != null && !rootsOnly) {
            throw new IllegalStateException("Nested update may not process included files.");
        }
        ProgressManager.checkCanceled();
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        int updatedCount = 0;
        while (true) {
            VirtualFile file = null;
            UpdateQueue queue2 = null;
            Object object = this.myLock;
            synchronized (object) {
                while (file == null) {
                    ProgressManager.checkCanceled();
                    this.myQueueUpdater.getValue();
                    if (isDispatchThread && rootsOnly && this.tryHugeUpdate()) {
                        return;
                    }
                    if (!this.hasFilesToUpdate(rootsOnly)) {
                        if (!rootsOnly && updatedCount > 0) {
                            this.notifyOnUpToDate();
                        }
                        return;
                    }
                    file = this.myRootQueue.startProcessingNext();
                    queue2 = this.myRootQueue;
                    if (file == null && !rootsOnly) {
                        file = this.myIncludeQueue.startProcessingNext();
                        queue2 = this.myIncludeQueue;
                    }
                    if (file != null) continue;
                    try {
                        this.myLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            boolean ok = false;
            this.myParentQueue.set(queue2);
            try {
                ProgressManager.checkCanceled();
                FileSymbolTableUpdater.updateTables(file, this.myProject, queue2 == this.myRootQueue);
                ok = true;
                ++updatedCount;
                continue;
            }
            finally {
                this.myParentQueue.set(parentQueue);
                Object object2 = this.myLock;
                synchronized (object2) {
                    queue2.finishProcessing(file, ok);
                    this.myLock.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    private boolean hasFilesToUpdate(boolean rootsOnly) {
        return this.myRootQueue.hasUnprocessedFiles() || !rootsOnly && this.myIncludeQueue.hasUnprocessedFiles();
    }

    private void notifyInvalidated() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ((FileSymbolTableCacheListener)this.myProject.getMessageBus().syncPublisher(FileSymbolTableCacheListener.TOPIC)).onSymbolsInvalidated();
    }

    private void notifyOnUpToDate() {
        int notificationId = this.myLastNotificationId.incrementAndGet();
        Runnable n = () -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myLastNotificationId.get() == notificationId && !this.myProject.isDisposed() && FileSymbolTablesCache.areSymbolsLoaded(this.myProject) && this.isUpToDate()) {
                    ((FileSymbolTableCacheListener)this.myProject.getMessageBus().syncPublisher(FileSymbolTableCacheListener.TOPIC)).onSymbolsUpToDate();
                }
            }
        };
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            n.run();
        } else {
            app.invokeLater(n);
        }
    }

    public boolean isUpToDate() {
        return this.isUpToDate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate(boolean rootsOnly) {
        Object object = this.myLock;
        synchronized (object) {
            return !this.hasFilesToUpdate(rootsOnly);
        }
    }

    private boolean rebuildQueues() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myRootQueue.approximateSize() + this.myIncludeQueue.approximateSize());
        files.addAll(this.myRootQueue.removeAllFilesToUpdate());
        files.addAll(this.myIncludeQueue.removeAllFilesToUpdate());
        for (VirtualFile file : files) {
            this.addFileInner(file);
        }
        return true;
    }

    private static void updateTables(@NotNull VirtualFile file, @NotNull Project project, boolean isRoot) {
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        if (!isRoot && cache.allTablesForFileCount(file) > 0) {
            return;
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        OCImportGraph importGraph = OCImportGraph.getInstance(project);
        for (OCResolveConfiguration config : OCResolveConfigurations.getAllBuildConfigurationsForIndexing((VirtualFile)file, (Project)project)) {
            importGraph.buildSymbolAndRootHeaderCache(config, file, !isRoot, pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileForUpdate(@NotNull VirtualFile file) {
        Object object = this.myLock;
        synchronized (object) {
            boolean wasUpToDate = this.isUpToDate();
            this.addFileInner(file);
            if (wasUpToDate && !this.isUpToDate()) {
                this.notifyInvalidated();
            }
            this.myLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="_, true -> !null")
    public @Nullable List<@NotNull VirtualFile> addFilesForUpdate(@NotNull @NotNull Collection<@NotNull ? extends VirtualFile> files, boolean clearCaches) {
        Object object = this.myLock;
        synchronized (object) {
            List<VirtualFile> clearedFiles = clearCaches ? FileSymbolTablesCache.getInstance(this.myProject).removeFilesFromCache(files) : null;
            boolean wasUpToDate = this.isUpToDate();
            for (VirtualFile virtualFile : files) {
                this.addFileInner(virtualFile);
            }
            if (wasUpToDate && !this.isUpToDate()) {
                this.notifyInvalidated();
            }
            this.myLock.notifyAll();
            return clearedFiles;
        }
    }

    private void addFileInner(@NotNull VirtualFile file) {
        if (!file.isValid()) {
            return;
        }
        if (this.isInclude(file)) {
            this.myIncludeQueue.add(file);
        } else {
            this.myRootQueue.add(file);
        }
    }

    private boolean isInclude(@NotNull VirtualFile file) {
        return OCRootUtil.isNeedToFindRoot(file, this.myProject);
    }

    private boolean tryHugeUpdate() {
        int fileScore = this.myRootQueue.approximateSize();
        if (fileScore < 20) {
            return false;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myRootQueue.removeAllFilesToUpdate());
        this.myHugeUpdateRequested.set(false);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myHugeUpdateRequested.getAndSet(true)) {
                return;
            }
            this.buildSymbolsForFiles(files);
        }, ModalityState.NON_MODAL);
        return true;
    }

    private void buildSymbolsForFiles(@NotNull Collection<VirtualFile> files) {
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        SymbolBuildingTask.runSymbolActivity("buildSymbolsForFiles", this.myProject, indicator -> {
            OCSymbolTableBuildingUtil.invokeAndWaitSafely((ProgressIndicator)indicator, () -> {
                if (this.myProject.isDisposed() || indicator.isCanceled()) {
                    return;
                }
                FileSymbolTablesCache fileSymbolTablesCache = FileSymbolTablesCache.getInstance(this.myProject);
                fileSymbolTablesCache.notifySymbolsUnloaded();
                fileSymbolTablesCache.reparseCachedPsiFiles();
            });
            indicator.checkCanceled();
            OCSymbolTableBuilder builder2 = new OCSymbolTableBuilder(this.myProject, (OCBuildingActivityProgressIndicator)((Object)indicator), files, false);
            builder2.processBuildFiles(indicator.getFraction(), 1.0);
            OCSymbolLoadedNotifier.notifySymbolsAreLoadedAndReparseCachedFiles(this.myProject, indicator);
        });
    }

    private static class UpdateQueue {
        private final HashSetQueue<VirtualFile> myFilesToUpdate = new HashSetQueue();
        private int myFilesInProgressCount;

        private UpdateQueue() {
        }

        public void add(VirtualFile file) {
            this.myFilesToUpdate.add((Object)file);
        }

        public VirtualFile startProcessingNext() {
            VirtualFile file = this.getFirstValid(true);
            if (file == null) {
                return null;
            }
            ++this.myFilesInProgressCount;
            return file;
        }

        public boolean hasUnprocessedFiles() {
            return this.myFilesInProgressCount > 0 || this.getFirstValid(false) != null;
        }

        @Nullable
        private VirtualFile getFirstValid(boolean remove) {
            VirtualFile first;
            while ((first = (VirtualFile)this.myFilesToUpdate.peek()) != null && !first.isValid()) {
                this.myFilesToUpdate.poll();
            }
            if (remove && first != null) {
                this.myFilesToUpdate.poll();
            }
            return first;
        }

        public void finishProcessing(VirtualFile file, boolean isProcessed) {
            --this.myFilesInProgressCount;
            if (!isProcessed) {
                this.myFilesToUpdate.add((Object)file);
            }
        }

        public Collection<VirtualFile> removeAllFilesToUpdate() {
            VirtualFile file;
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.myFilesToUpdate.size());
            while ((file = this.getFirstValid(true)) != null) {
                result.add(file);
            }
            return result;
        }

        public int approximateSize() {
            return this.myFilesToUpdate.size();
        }
    }
}

