/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.building.ImpatientDeferredException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProcessingDependencyGraph<Item> {
    private final Map<Thread, Item> myThreadToAwaitingItem = new HashMap<Thread, Item>();
    private final Map<Item, Context> myItemToProcessingContext = CollectionFactory.createSmallMemoryFootprintMap();

    ProcessingDependencyGraph() {
    }

    synchronized boolean isAlreadyProcessing(@NotNull Item item, @NotNull Thread currentThread) {
        Context currentProcessingContext = this.myItemToProcessingContext.get(item);
        return currentProcessingContext != null && ProcessingDependencyGraph.isRecursive(currentThread, currentProcessingContext.getThread());
    }

    @NotNull
    synchronized State startProcessing(@NotNull Item item, @NotNull Thread currentThread, @Nullable Runnable reschedule) throws ImpatientDeferredException {
        Context currentProcessingContext = this.myItemToProcessingContext.get(item);
        if (currentProcessingContext == null) {
            this.myItemToProcessingContext.put(item, new Context(currentThread));
            return State.ACQUIRED;
        }
        Thread currentProcessingThread = currentProcessingContext.getThread();
        if (ProcessingDependencyGraph.isRecursive(currentThread, currentProcessingThread)) {
            return State.RECURSIVE;
        }
        if (reschedule != null) {
            currentProcessingContext.add(reschedule);
            throw new ImpatientDeferredException();
        }
        if (this.isDeadlock(currentThread, currentProcessingThread)) {
            return State.DEADLOCK;
        }
        this.myThreadToAwaitingItem.put(currentThread, item);
        return State.WAIT;
    }

    synchronized boolean retryStartProcessing(@NotNull Item item, @NotNull Thread currentThread) {
        Thread currentProcessingThread = this.getCurrentProcessingThread(item);
        if (currentProcessingThread == null) {
            this.myItemToProcessingContext.put(item, new Context(currentThread));
            this.myThreadToAwaitingItem.remove(currentThread);
            return true;
        }
        return false;
    }

    synchronized void stopWaiting(@NotNull Thread currentThread) {
        this.myThreadToAwaitingItem.remove(currentThread);
    }

    synchronized void finishProcessing(@NotNull Item item) {
        Context processingContext = this.myItemToProcessingContext.remove(item);
        if (!OCLog.LOG.assertTrue(processingContext != null, (Object)"Current processing context not found")) {
            return;
        }
        Iterator iterator = processingContext.iterator();
        while (iterator.hasNext()) {
            Runnable reschedule = (Runnable)iterator.next();
            reschedule.run();
        }
    }

    private static boolean isRecursive(@NotNull Thread context, @NotNull Thread thread) {
        return context == thread;
    }

    private boolean isDeadlock(@NotNull Thread context, @NotNull Thread thread) {
        Item lock;
        while ((lock = this.myThreadToAwaitingItem.get(thread)) != null) {
            Thread next = this.getCurrentProcessingThread(lock);
            if (next == null || next == thread) {
                return false;
            }
            if (next == context) {
                return true;
            }
            thread = next;
        }
        return false;
    }

    @Nullable
    private Thread getCurrentProcessingThread(@NotNull Item item) {
        Context currentProcessingContext = this.myItemToProcessingContext.get(item);
        return currentProcessingContext != null ? currentProcessingContext.getThread() : null;
    }

    private static final class Context
    extends SmartList<Runnable> {
        @NotNull
        private final Thread myThread;

        Context(@NotNull Thread thread) {
            this.myThread = thread;
        }

        @NotNull
        Thread getThread() {
            return this.myThread;
        }

        public boolean equals(@Nullable Object o) {
            throw new AssertionError();
        }

        public int hashCode() {
            throw new AssertionError();
        }

        public String toString() {
            return "ProcessingContext{thread=" + this.myThread + "} " + super.toString();
        }
    }

    static enum State {
        DEADLOCK,
        RECURSIVE,
        ACQUIRED,
        WAIT;

    }
}

