/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCFileSymbolTableModificationTracker
extends SimpleModificationTracker
implements Disposable {
    private State state = new State();
    public static final Logger LOG = Logger.getInstance(OCFileSymbolTableModificationTracker.class);

    public OCFileSymbolTableModificationTracker(@NotNull Project project) {
        project.getMessageBus().connect((Disposable)this).subscribe(OCFileSymbolTableListener.TOPIC, (Object)new OCFileSymbolTableListener(){

            @Override
            public void onFileHasNewSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                OCFileSymbolTableModificationTracker.log("FST add ", virtualFile);
                OCFileSymbolTableModificationTracker.this.addFileWithNewSymbolTable(virtualFile);
            }

            @Override
            public void onFileHasInvalidSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                OCFileSymbolTableModificationTracker.log("FST remove ", virtualFile);
                OCFileSymbolTableModificationTracker.this.addFileWithInvalidTable(virtualFile);
            }

            @Override
            public void onAllSymbolTablesDropped() {
                OCFileSymbolTableModificationTracker.log("FST clear all", new Object[0]);
                OCFileSymbolTableModificationTracker.this.reset();
            }
        });
    }

    public void dispose() {
    }

    synchronized long attachAndReturnCurrentVersion(@NotNull OCGlobalProjectSymbolsCache.OCSymbols symbols) {
        this.state.symbols = symbols;
        return this.getModificationCount();
    }

    synchronized void restoreStateOnCancel(@NotNull State canceledState, @NotNull OCGlobalProjectSymbolsCache.OCSymbols beforeBuildSymbols) {
        this.state.restore(canceledState, beforeBuildSymbols);
    }

    @NotNull
    synchronized State getStateAndReset() {
        State ret = this.state;
        ret.version = this.getModificationCount();
        this.state = new State();
        return ret;
    }

    synchronized void reset() {
        this.state = new State();
        this.incModificationCount();
    }

    synchronized void addFileWithNewSymbolTable(@NotNull VirtualFile file) {
        this.state.filesWithNewSymbolTable.add(file);
        this.incModificationCount();
    }

    synchronized void addFileWithInvalidTable(@NotNull VirtualFile file) {
        this.state.filesWithInvalidSymbolTable.add(file);
        this.incModificationCount();
    }

    public static OCFileSymbolTableModificationTracker getInstance(@NotNull Project project) {
        return (OCFileSymbolTableModificationTracker)((Object)project.getService(OCFileSymbolTableModificationTracker.class));
    }

    public static void log(@NotNull String message, Object ... details) {
        LOG.debug(message, details);
    }

    public static class State {
        public OCGlobalProjectSymbolsCache.OCSymbols symbols = null;
        public final Set<VirtualFile> filesWithNewSymbolTable = new HashSet<VirtualFile>();
        public final Set<VirtualFile> filesWithInvalidSymbolTable = new HashSet<VirtualFile>();
        public long version = -1L;

        public void restore(@NotNull State canceledState, @NotNull OCGlobalProjectSymbolsCache.OCSymbols beforeBuildSymbols) {
            this.filesWithNewSymbolTable.addAll(canceledState.filesWithNewSymbolTable);
            this.filesWithInvalidSymbolTable.addAll(canceledState.filesWithInvalidSymbolTable);
            assert (this.symbols == null);
            this.symbols = beforeBuildSymbols;
            this.version = -1L;
        }
    }
}

