/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPackListener;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class FileSymbolTablesPack {
    @NotNull
    private final ArrayList<FileSymbolTable> myTables = new ArrayList();
    @Nullable
    private transient BatchInterner myInterner;
    private volatile transient boolean myIsChanged;
    private volatile transient boolean myShouldSerialize;
    private transient boolean myFallback;

    public boolean isEmpty() {
        return this.myTables.isEmpty();
    }

    public List<FileSymbolTable> tablesView() {
        return Collections.unmodifiableList(this.myTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.myTables.trimToSize();
            for (FileSymbolTable table : this.myTables) {
                table.compact();
            }
            this.myInterner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompactSynchronized(@NotNull Project project, @NotNull FileSymbolTable table) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            if (!this.myTables.isEmpty()) {
                if (this.myInterner == null) {
                    this.myInterner = new BatchInterner();
                    for (FileSymbolTable t : this.myTables) {
                        this.myInterner.internBatch((Consumer<Function<OCSymbol, OCSymbol>>)((Consumer)i -> {
                            for (OCSymbol symbol : t.getContents()) {
                                i.fun((Object)symbol);
                            }
                        }));
                    }
                }
                Ref internedCount = new Ref();
                this.myInterner.internBatch((Consumer<Function<OCSymbol, OCSymbol>>)((Consumer)i -> internedCount.set((Object)table.internSymbols((UserDataHolder)project, (Function<? super OCSymbol, ? extends OCSymbol>)i))));
                if (table.getContents().size() == ((Integer)internedCount.get()).intValue()) {
                    for (FileSymbolTable t : this.myTables) {
                        if (table.tryReuseContents(t)) break;
                    }
                }
            }
            if (!table.isFallback()) {
                this.myFallback = false;
            }
            this.addTableInternal(project, table);
            table.incUsageCount();
        }
    }

    private void addTableInternal(@NotNull Project project, @NotNull FileSymbolTable table) {
        this.setChanged();
        this.myTables.add(table);
        table.setPackStamp(this.getTimeStamp());
        ((FileSymbolTablesPackListener)project.getMessageBus().syncPublisher(FileSymbolTablesPackListener.TOPIC)).afterTableAddedToPack(table);
    }

    private void setChanged() {
        this.myIsChanged = true;
        this.myShouldSerialize = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerialized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.myShouldSerialize = false;
        }
    }

    public boolean shouldSerialize() {
        return this.myShouldSerialize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJunkTables(@NotNull Project project, boolean includingUnused) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            boolean hasJunkTables = false;
            for (int i = 0; i < this.myTables.size(); ++i) {
                FileSymbolTable table = this.myTables.get(i);
                if (!table.isFallback() && (!includingUnused || table.getUsageCount() != 0)) continue;
                FileSymbolTablesPack.onTableRemove(project, table);
                this.myTables.set(i, null);
                hasJunkTables = true;
            }
            if (hasJunkTables) {
                this.setChanged();
                this.myInterner = null;
                FileSymbolTable[] oldTables = this.myTables.toArray(FileSymbolTable.EMPTY_ARRAY);
                this.myTables.clear();
                for (FileSymbolTable table : oldTables) {
                    if (table == null) continue;
                    this.addTableInternal(project, table);
                }
            }
        }
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    private int getTimeStamp() {
        return this.myTables.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsFallback() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.setChanged();
            this.myFallback = true;
            for (FileSymbolTable table : this.myTables) {
                table.setFallback(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFallback() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myFallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onThaw(@NotNull Project project) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            boolean shouldCompactSymbols = FileSymbolTable.shouldCompactSymbols();
            ReferenceOpenHashSet compacted = shouldCompactSymbols ? new ReferenceOpenHashSet() : null;
            for (FileSymbolTable table : this.myTables) {
                if (shouldCompactSymbols) {
                    for (OCSymbol symbol : table.getContents()) {
                        if (!compacted.add(symbol)) continue;
                        symbol.compact();
                    }
                }
                ((FileSymbolTablesPackListener)project.getMessageBus().syncPublisher(FileSymbolTablesPackListener.TOPIC)).afterTableAddedToPack(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(@NotNull Project project) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                FileSymbolTablesPack.onTableRemove(project, table);
            }
        }
    }

    private static void onTableRemove(@NotNull Project project, FileSymbolTable table) {
        ((FileSymbolTablesPackListener)project.getMessageBus().syncPublisher(FileSymbolTablesPackListener.TOPIC)).beforeTableRemovedFromPack(table);
        table.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public @Unmodifiable List<FileSymbolTable> getTablesSynchronized() {
        Object[] tables;
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            tables = this.myTables.toArray(FileSymbolTable.EMPTY_ARRAY);
        }
        return ContainerUtil.immutableList((Object[])tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTablesCountSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myTables.size();
        }
    }

    @NotNull
    public Object getTablesAccessLock() {
        return this.myTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOffsetsSynchronized(int start, int lengthShift) {
        ReferenceOpenHashSet processed = new ReferenceOpenHashSet();
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                table.updateOffsets(start, lengthShift, (Set<OCSymbol>)processed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTable findConformingTable(@NotNull OCInclusionContext context, int sinceTimeStamp, @Nullable Ref<Integer> outCurrentTimeStamp) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            int timeStamp = this.getTimeStamp();
            if (outCurrentTimeStamp != null) {
                outCurrentTimeStamp.set((Object)timeStamp);
            }
            if (timeStamp > sinceTimeStamp) {
                for (int i = 0; i < this.myTables.size(); ++i) {
                    FileSymbolTable table = this.myTables.get(i);
                    if (table.getPackStamp() <= sinceTimeStamp || !context.checkConformanceAndFillSignatures(table)) continue;
                    int usingCount = table.incUsageCount();
                    if (usingCount < 0) {
                        for (FileSymbolTable t : this.myTables) {
                            t.resetUsageCount();
                        }
                    } else {
                        for (int prev = i - 1; prev >= 0 && this.myTables.get(prev).getUsageCount() + 2 < usingCount; --prev) {
                            Collections.swap(this.myTables, prev, prev + 1);
                        }
                    }
                    table.setFallback(false);
                    this.myFallback = false;
                    return table;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUsedTables() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                if (table.getUsageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static class BatchInterner {
        private DeepEqual.Resolver myEqualityResolver;
        @NotNull
        private final Map<OCSymbol, OCSymbol> mySymbols = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)new HashingStrategy<OCSymbol>(){

            public int hashCode(OCSymbol object) {
                return object == null ? 0 : object.hashCodeExcludingOffset();
            }

            public boolean equals(OCSymbol o1, OCSymbol o2) {
                ProgressManager.checkCanceled();
                return myEqualityResolver.equalObjects(o1, o2);
            }
        });

        private BatchInterner() {
        }

        public void internBatch(@NotNull Consumer<Function<OCSymbol, OCSymbol>> action) {
            this.myEqualityResolver = DeepEqual.newResolver();
            try {
                action.consume(symbol -> {
                    OCSymbol same = this.mySymbols.get(symbol);
                    if (same != null) {
                        return same;
                    }
                    this.mySymbols.put((OCSymbol)symbol, (OCSymbol)symbol);
                    return symbol;
                });
            }
            finally {
                this.myEqualityResolver = null;
            }
        }
    }
}

