/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSynthesizeSymbol
extends OCMemberSymbolImpl {
    private boolean mySynthesize;
    private boolean myStatic;
    private String myIvarName;

    public OCSynthesizeSymbol() {
    }

    public OCSynthesizeSymbol(VirtualFile file, long offset, String name, @NotNull List<String> attributes, OCClassSymbol parent, boolean isSynthesize, boolean isStatic, String ivarName) {
        super(file, offset, name, attributes, parent);
        this.mySynthesize = isSynthesize;
        this.myStatic = isStatic;
        this.myIvarName = ivarName;
    }

    public boolean isSynthesize() {
        return this.mySynthesize;
    }

    @Override
    public boolean isStatic() {
        return this.myStatic;
    }

    public String getIvarName() {
        return this.myIvarName != null ? this.myIvarName : this.myName;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.SYNTHESIZE;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCSynthesizeSymbol f = (OCSynthesizeSymbol)first;
        OCSynthesizeSymbol s = (OCSynthesizeSymbol)second;
        if (f.mySynthesize != s.mySynthesize) {
            return false;
        }
        if (f.myStatic != s.myStatic) {
            return false;
        }
        return Objects.equals(f.myIvarName, s.myIvarName);
    }

    @Nullable
    public OCPropertySymbol getAssociatedProperty(@NotNull Project project) {
        OCInterfaceSymbol interf = this.getParent().getInterface(project);
        if (interf == null) {
            return null;
        }
        final String propertyName = this.getName();
        CommonProcessors.FindFirstProcessor<OCPropertySymbol> processor = new CommonProcessors.FindFirstProcessor<OCPropertySymbol>(){

            protected boolean accept(OCPropertySymbol symbol) {
                return Objects.equals(propertyName, symbol.getName());
            }
        };
        interf.processMembers(propertyName, OCPropertySymbol.class, processor);
        if (!processor.isFound()) {
            interf.processMembers("", propertyName, OCPropertySymbol.class, processor, true, project);
        }
        return (OCPropertySymbol)processor.getFoundValue();
    }

    @Nullable
    public OCInstanceVariableSymbol getIvarSymbol(final @NotNull Project project) {
        OCClassSymbol impl = this.getParent();
        CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol> finder = new CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol>(){

            protected boolean accept(OCInstanceVariableSymbol symbol) {
                return Objects.equals(OCSynthesizeSymbol.this.getIvarName(), symbol.getName()) && !symbol.isClang4ImplicitIvar(project);
            }
        };
        OCCommonProcessors.OrderedProcessor processor = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<? super T>[])new Condition[]{ivar -> ivar.getGeneratedFromProperty() == null, Conditions.alwaysTrue()});
        OCInterfaceSymbol intf = impl.getInterface(project);
        if (intf != null) {
            intf.processMembersInAllCategories(this.getIvarName(), OCInstanceVariableSymbol.class, processor, project);
        }
        impl.processMembers(this.getIvarName(), OCInstanceVariableSymbol.class, processor);
        processor.finish();
        return (OCInstanceVariableSymbol)finder.getFoundValue();
    }
}

