/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCAttributedNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMemberSymbolImpl
extends OCAttributedNamedSymbol
implements OCMemberSymbol {
    @NotNull
    protected OCClassSymbol myParent;

    public OCMemberSymbolImpl() {
    }

    public OCMemberSymbolImpl(VirtualFile file, long offset, @Nullable String name, @NotNull List<String> attributes, @NotNull OCClassSymbol parent) {
        super(file, offset, name, attributes);
        this.myParent = parent;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMemberSymbolImpl f = (OCMemberSymbolImpl)first;
        OCMemberSymbolImpl s = (OCMemberSymbolImpl)second;
        return c.equalObjects(f.myParent, s.myParent);
    }

    @Override
    @NotNull
    public OCClassSymbol getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public String getNameWithParent(@NotNull OCResolveContext context) {
        return this.myParent.getName() + "." + this.myName;
    }

    @Override
    @Nullable
    public OCMemberSymbol getAssociatedSymbol(@NotNull Project project) {
        OCClassSymbol parentAssociate = (OCClassSymbol)this.getParent().getAssociatedSymbol(project);
        if (parentAssociate == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        parentAssociate.processMembers(this.getName(), this.getClass(), processor);
        return (OCMemberSymbol)processor.getFoundValue();
    }

    @Override
    public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor, @NotNull Project project) {
        return this.myParent.processMembersInAllCategories(this.myName, this.getClass(), processor, false, project);
    }

    @Override
    public boolean isSameSymbol(OCSymbol symbol, @NotNull Project project) {
        return symbol instanceof OCMemberSymbol && this.myName.equals(symbol.getName()) && this.myParent.isSameSymbol((OCSymbol)((OCMemberSymbol)symbol).getParent(), project);
    }
}

