/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImplementationSymbol
extends OCClassSymbolImpl {
    public OCImplementationSymbol() {
    }

    public OCImplementationSymbol(@Nullable VirtualFile file, long offset, @NotNull String name, @NotNull List<String> attributes, @Nullable String category, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @Nullable OCReferenceType superType) {
        super(file, offset, name, attributes, category, members, Collections.emptyList(), superType);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.IMPLEMENTATION;
    }

    @Override
    @Nullable
    public OCClassSymbol getInterfaceOrProtocol(@NotNull Project project) {
        return this.getInterface(project);
    }

    @Override
    public boolean isDefinition() {
        return true;
    }

    @Override
    @NotNull
    public OCType getType() {
        return OCReferenceType.fromText(this.getName());
    }

    @Override
    @Nullable
    public OCInterfaceSymbol getInterface(@NotNull Project project) {
        OCInterfaceSymbol symbol = this.getInterface(false, this.getCategoryName(), project);
        if (symbol == null && this.getCategoryName() != null) {
            symbol = this.getInterface(false, null, project);
        }
        return symbol;
    }

    @Nullable
    public OCInterfaceSymbol getInterface(boolean ignoringImports, @Nullable String categoryName, @NotNull Project project) {
        final Condition condition = symbol -> symbol instanceof OCInterfaceSymbol && !symbol.isPredeclaration() && Objects.equals(categoryName, ((OCInterfaceSymbol)symbol).getCategoryName());
        CommonProcessors.FindFirstProcessor<OCSymbol> processor = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return condition.value((Object)symbol);
            }
        };
        PsiFile containingFile = this.getContainingPsiFile(project);
        if (containingFile == null) {
            return null;
        }
        String name = this.getName();
        OCResolveUtil.processGlobalSymbols(name, null, containingFile, this.getOffset(), (Processor<OCSymbol>)processor);
        if (!processor.isFound() && ignoringImports) {
            return (OCInterfaceSymbol)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, name, (Condition<? super OCSymbol>)condition, this.myFile);
        }
        return (OCInterfaceSymbol)processor.getFoundValue();
    }

    @Override
    public OCSymbol getAssociatedSymbol(@NotNull Project project) {
        return this.getInterface(project);
    }

    @Override
    public OCImplementationSymbol getImplementation(@NotNull Project project) {
        return this;
    }
}

