/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCUnnamedSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCExpressionSymbol
extends OCUnnamedSymbol
implements OCInitializerSymbol {
    public OCExpressionSymbol() {
    }

    public OCExpressionSymbol(@Nullable VirtualFile file, long offset) {
        super(file, offset);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.EXPRESSION;
    }

    @Override
    @Nullable
    public PsiElement locateDefinition(@NotNull Project project) {
        PsiElement expression = super.locateDefinition(project);
        if (expression == null) {
            return null;
        }
        PsiElement parent = expression.getParent();
        while (parent instanceof OCExpression && OCSymbolOffsetUtil.getVirtualComplexOffset(parent) == this.myComplexOffset) {
            expression = parent;
            parent = expression.getParent();
        }
        return expression;
    }

    @Nullable
    public OCTypeArgument evaluateToTypeArgument(@NotNull OCResolveContext resolver) {
        Number value = OCExpressionEvaluator.evaluate(this, resolver);
        return value != null ? new OCExpressionTypeArgument(new OCLiteralExpressionSymbol(value, null, null)) : null;
    }

    @Nullable
    public abstract <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> var1);

    @Override
    @NotNull
    public abstract String getPresentableName();

    @Override
    @NotNull
    public List<OCExpressionSymbol> getArguments() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean isListInitializer() {
        return false;
    }
}

