/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCommaExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myHeadExpression;
    private OCExpressionSymbol myTailExpression;

    public OCCommaExpressionSymbol() {
    }

    public OCCommaExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull OCExpressionSymbol headExpression, @NotNull OCExpressionSymbol tailExpression) {
        super(file, offset);
        this.myHeadExpression = headExpression;
        this.myTailExpression = tailExpression;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCommaExpressionSymbol firstSymbol = (OCCommaExpressionSymbol)first;
        OCCommaExpressionSymbol secondSymbol = (OCCommaExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myHeadExpression, secondSymbol.myHeadExpression)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myTailExpression, secondSymbol.myTailExpression);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return this.myTailExpression.evaluate(evaluator);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCType headType;
        if (context.isInSFINAE() && (headType = this.myHeadExpression.getResolvedType(context)).isUnresolved(context)) {
            return OCUnknownType.INSTANCE;
        }
        return this.myTailExpression.getResolvedType(context);
    }

    @NotNull
    public OCExpressionSymbol getHeadExpression() {
        return this.myHeadExpression;
    }

    @NotNull
    public OCExpressionSymbol getTailExpression() {
        return this.myTailExpression;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myHeadExpression.getPresentableName() + ", " + this.myTailExpression.getPresentableName();
    }
}

