/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCUnnamedSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentListSymbol
extends OCUnnamedSymbol
implements OCInitializerSymbol {
    @NotNull
    private List<OCExpressionSymbol> myArguments;

    public OCArgumentListSymbol() {
    }

    public OCArgumentListSymbol(@Nullable VirtualFile file, long offset, @NotNull List<OCExpressionSymbol> arguments) {
        super(file, offset);
        this.myArguments = arguments;
    }

    @Override
    @NotNull
    public List<OCExpressionSymbol> getArguments() {
        return this.myArguments;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCArgumentListSymbol firstSymbol = (OCArgumentListSymbol)first;
        OCArgumentListSymbol secondSymbol = (OCArgumentListSymbol)second;
        return c.equalObjects(firstSymbol.myArguments, secondSymbol.myArguments);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.ARGUMENT_LIST;
    }

    @Override
    public boolean isListInitializer() {
        return false;
    }

    @Override
    public void compact() {
        super.compact();
        this.myArguments = ContainerUtil.trimToSize(this.myArguments);
        for (OCExpressionSymbol argument : this.myArguments) {
            argument.compact();
        }
    }
}

