/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUsingSymbol
extends OCSymbolImpl
implements OCSymbolWithParent,
OCSymbolWithSubstitution {
    private OCSymbolReference mySymbolReference;
    private OCSymbolKind myKind;
    private ComplexTextRange myScope;
    @Nullable
    private OCVisibility myVisibility;
    @Nullable
    private OCSymbolWithQualifiedName myParent;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCUsingSymbol f = (OCUsingSymbol)first;
        OCUsingSymbol s = (OCUsingSymbol)second;
        if (f.myKind != s.myKind) {
            return false;
        }
        ComplexTextRange scope = f.myScope;
        if (scope != null ? !scope.equals(s.myScope) : s.myScope != null) {
            return false;
        }
        if (f.myVisibility != s.myVisibility) {
            return false;
        }
        if (!c.equalObjects(f.myParent, s.myParent)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalObjects(f.mySymbolReference, s.mySymbolReference);
    }

    public OCUsingSymbol() {
    }

    @Override
    @NotNull
    public String getName() {
        return (String)ObjectUtils.coalesce((Object)this.mySymbolReference.getQualifiedName().getName(), (Object)"<unnamed>");
    }

    @Override
    @Nullable
    public OCSymbolWithQualifiedName getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public String getNameWithParent(@NotNull OCResolveContext context) {
        if (this.myParent != null) {
            return this.myParent.getName() + "::" + this.getName();
        }
        return this.getName();
    }

    public OCUsingSymbol(@Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName parent, OCSymbolReference ref, OCSymbolKind kind, OCVisibility visibility, ComplexTextRange scope) {
        super(file, offset);
        this.mySymbolReference = ref;
        this.myKind = kind;
        this.myScope = scope;
        this.myVisibility = visibility;
        this.myParent = parent;
    }

    private OCUsingSymbol(@NotNull OCUsingSymbol origin, @NotNull OCTypeSubstitution substitution) {
        super(origin.getContainingFile(), origin.getComplexOffset());
        this.mySymbolReference = origin.getSymbolReference();
        this.myKind = origin.getKind();
        this.myScope = origin.getScope();
        this.mySubstitution = substitution;
        this.myVisibility = origin.getVisibility();
        this.myParent = origin.getParent();
    }

    @Override
    @NotNull
    public OCUsingSymbol cloneWithSubstitution(@NotNull OCTypeSubstitution substitution) {
        return new OCUsingSymbol(this, substitution);
    }

    @Nullable
    public OCVisibility getVisibility() {
        return this.myVisibility;
    }

    public OCSymbolReference getSymbolReference() {
        return this.mySymbolReference;
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myScope;
    }

    @Override
    public void setScope(@NotNull ComplexTextRange scope) {
        this.myScope = scope;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.myKind;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }
}

