/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMacroSymbol
extends OCNamedSymbol
implements Iconable {
    public static final String VA_ARGS_PARAM_NAME = "__VA_ARGS__...";
    private OCImmutableList<String> myParameterNames;
    private String mySubstitution;
    private boolean myHasParameterList;

    public OCMacroSymbol() {
    }

    public OCMacroSymbol(@Nullable VirtualFile file, long offset, String name, @Nullable OCImmutableList<String> parameterNames, @NotNull String substitution) {
        super(file, offset, name);
        this.myHasParameterList = parameterNames != null;
        this.myParameterNames = this.myHasParameterList ? parameterNames : OCImmutableList.emptyList();
        this.mySubstitution = substitution;
    }

    public static OCMacroSymbol inclusionGuard(@NotNull String name) {
        return new OCMacroSymbol(null, 0L, name, null, "");
    }

    @NotNull
    public OCImmutableList<String> getParameterNames() {
        return this.myParameterNames;
    }

    @NotNull
    public List<String> getUserFriendlyParameterNames() {
        return ContainerUtil.map(this.myParameterNames, name -> VA_ARGS_PARAM_NAME.equals(name) ? "..." : name);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @NotNull
    public String getSubstitution() {
        return this.mySubstitution;
    }

    public int getSubstitutionHash() {
        return this.mySubstitution.hashCode();
    }

    public boolean hasParameterList() {
        return this.myHasParameterList;
    }

    public String getParametersSignature() {
        if (!this.myHasParameterList) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        Iterator iterator = this.myParameterNames.iterator();
        while (iterator.hasNext()) {
            String param = (String)iterator.next();
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param);
            isFirst = false;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean isVararg() {
        return this.myParameterNames.size() > 0 && this.myParameterNames.get(this.myParameterNames.size() - 1).endsWith("...");
    }

    public String getPresentableSignature() {
        return this.getName() + this.getParametersSignature();
    }

    @Override
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("#define ").append(this.myName);
        if (this.myHasParameterList) {
            builder2.append('(');
            StringUtil.join(this.myParameterNames, (String)", ", (StringBuilder)builder2);
            builder2.append(')');
        }
        builder2.append(' ').append(this.mySubstitution);
        return builder2.toString();
    }

    @Nullable
    public static OCMacroSymbol parseFromDirectiveContent(CharSequence content, VirtualFile file, long offset) {
        OCLexer contentLexer = new OCLexer(OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.C).build());
        contentLexer.start(content);
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(contentLexer.getTokenType())) {
            contentLexer.advance();
        }
        IElementType tt = contentLexer.getTokenType();
        if (tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tt)) {
            IElementType t;
            ArrayList<String> params;
            String name = OCNamesInterner.intern((String)LexerUtil.getTokenText((Lexer)contentLexer).toString());
            int nameOffset = contentLexer.getTokenStart();
            contentLexer.getTokenStart();
            contentLexer.advance();
            if (contentLexer.getTokenType() == OCTokenTypes.LPAR) {
                IElementType t2;
                params = new ArrayList<String>();
                contentLexer.advance();
                while ((t2 = contentLexer.getTokenType()) == OCTokenTypes.COMMA || t2 == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(t2) || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(t2) || t2 == OCTokenTypes.ELLIPSIS) {
                    if (t2 == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(t2)) {
                        Object paramName = OCNamesInterner.intern((String)LexerUtil.getTokenText((Lexer)contentLexer).toString());
                        contentLexer.advance();
                        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(contentLexer.getTokenType())) {
                            contentLexer.advance();
                        }
                        if (contentLexer.getTokenType() == OCTokenTypes.ELLIPSIS) {
                            contentLexer.advance();
                            paramName = (String)paramName + "...";
                        }
                        params.add((String)paramName);
                        continue;
                    }
                    if (t2 == OCTokenTypes.ELLIPSIS) {
                        contentLexer.advance();
                        params.add(VA_ARGS_PARAM_NAME);
                        continue;
                    }
                    contentLexer.advance();
                }
                if (contentLexer.getTokenType() == OCTokenTypes.RPAR) {
                    contentLexer.advance();
                }
            } else {
                params = null;
            }
            if (contentLexer.getTokenType() == TokenType.WHITE_SPACE) {
                contentLexer.advance();
            }
            StringBuilder replacement = new StringBuilder();
            while ((t = contentLexer.getTokenType()) != null) {
                CharSequence token = LexerUtil.getTokenText((Lexer)contentLexer);
                if (t != OCTokenTypes.EOL_ESCAPE) {
                    if (OCTokenTypes.WHITESPACES.contains(t)) {
                        replacement.append(' ');
                    } else {
                        replacement.append(token);
                    }
                }
                contentLexer.advance();
            }
            OCImmutableList<String> parameterNames = params == null ? null : new OCImmutableList<String>(params);
            long nameComplexOffset = OCSymbolOffsetUtil.getComplexOffset(OCSymbolOffsetUtil.getTextOffset(offset) + nameOffset, OCSymbolOffsetUtil.getSubstOffset(offset));
            return new OCMacroSymbol(file, nameComplexOffset, name, parameterNames, OCNamesInterner.intern((String)replacement.toString().trim()));
        }
        return null;
    }

    public Icon getIcon(int flags) {
        return this.getBaseIcon();
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.MACRO;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMacroSymbol f = (OCMacroSymbol)first;
        OCMacroSymbol s = (OCMacroSymbol)second;
        if (f.myHasParameterList != s.myHasParameterList) {
            return false;
        }
        if (!Objects.equals(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return Comparing.equal(f.myParameterNames, s.myParameterNames);
    }
}

