/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAliasUsingSymbol
extends OCTemplateSymbolImpl
implements Serializable {
    private OCType myType;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private ComplexTextRange myScope;

    public OCAliasUsingSymbol() {
    }

    public OCAliasUsingSymbol(VirtualFile file, long offset, @NotNull String name, OCSymbolWithQualifiedName parent, @NotNull List<OCTypeParameterSymbol> templateParameters, @NotNull List<String> attributes, @Nullable ComplexTextRange scope, @Nullable OCVisibility visibility) {
        super(file, offset, parent, OCQualifiedName.with(name), templateParameters, attributes, visibility);
        this.myScope = scope;
    }

    private OCAliasUsingSymbol(@NotNull OCAliasUsingSymbol origin, @NotNull OCTypeSubstitution substitution) {
        super(origin.getContainingFile(), origin.getComplexOffset(), origin.getParent(), origin.getQualifiedName(), origin.getTemplateParameters(), Collections.emptyList(), null);
        this.myType = origin.myType;
        this.mySubstitution = substitution;
        this.myScope = origin.myScope;
    }

    @Override
    @NotNull
    public OCAliasUsingSymbol cloneWithSubstitution(@NotNull OCTypeSubstitution substitution) {
        return new OCAliasUsingSymbol(this, substitution);
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.mySubstitution.substitute(this.myType);
    }

    public void setType(OCType type) {
        this.myType = type;
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myScope;
    }

    @Override
    public void setScope(@NotNull ComplexTextRange scope) {
        this.myScope = scope;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return null;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCAliasUsingSymbol f = (OCAliasUsingSymbol)first;
        OCAliasUsingSymbol s = (OCAliasUsingSymbol)second;
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public String toString() {
        return "using " + this.getName() + " " + this.myType.getName();
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.USING_SYMBOL_ALIAS;
    }
}

