/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompatibilityAlias;
import com.jetbrains.cidr.lang.psi.OCConceptDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCGenericParameter;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroParameter;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCUndefDirective;
import com.jetbrains.cidr.lang.psi.OCUnion;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public enum OCSymbolKind {
    CATCH_EXCEPTION_VARIABLE,
    LOCAL_VARIABLE,
    PARAMETER,
    LABEL,
    STRUCT_FIELD,
    PROPERTY,
    INSTANCE_VARIABLE,
    METHOD,
    FUNCTION_PREDECLARATION,
    FUNCTION_DECLARATION,
    TYPEDEF,
    COMPATIBILITY_ALIAS,
    INTERFACE,
    PROTOCOL,
    IMPLEMENTATION,
    STRUCT,
    USING_SYMBOL_ALIAS,
    ENUM,
    UNION,
    NAMESPACE_ALIAS,
    NAMESPACE,
    NAMESPACE_USING_SYMBOL,
    SYMBOL_USING_SYMBOL,
    ENUM_CONST,
    GLOBAL_VARIABLE,
    GLOBAL_VARIABLE_PREDECLARATION,
    CPP_CONSTRUCTOR_PREDECLARATION,
    CPP_CONSTRUCTOR_DECLARATION,
    CPP_DEDUCTION_GUIDE,
    CPP_CTAD_DEDUCTION_CANDIDATE,
    CPP_CONCEPT,
    MACRO,
    MACRO_PARAMETER,
    UNDEF_MACRO,
    TEMPLATE_TYPE_PARAMETER,
    TEMPLATE_VALUE_PARAMETER,
    BUILTIN_SYMBOL,
    SYNTHESIZE,
    BLOCK,
    LAMBDA,
    IMPORT,
    LOCALIZED_STRING,
    EXPRESSION,
    ARGUMENT_LIST,
    GENERIC_PARAMETER,
    EXCEPTION_SPECIFIER,
    FOREIGN_ELEMENT,
    KEYWORD,
    FILE,
    FOLDER,
    UNKNOWN;


    @NotNull
    @Nls
    public String getName() {
        switch (this) {
            case TYPEDEF: {
                return OCBundle.message("symbol.kind.name.uppercase.type", new Object[0]);
            }
            case ENUM_CONST: {
                return OCBundle.message("symbol.kind.name.uppercase.enum.constant", new Object[0]);
            }
            case STRUCT_FIELD: {
                return OCBundle.message("symbol.kind.name.uppercase.field", new Object[0]);
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: {
                return OCBundle.message("symbol.kind.name.uppercase.function", new Object[0]);
            }
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return OCBundle.message("symbol.kind.name.uppercase.constructor", new Object[0]);
            }
            case PARAMETER: {
                return OCBundle.message("symbol.kind.name.uppercase.parameter", new Object[0]);
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: {
                return OCBundle.message("symbol.kind.name.uppercase.global.variable", new Object[0]);
            }
            case BUILTIN_SYMBOL: {
                return OCBundle.message("symbol.kind.name.uppercase.built.in.symbol", new Object[0]);
            }
            case LOCAL_VARIABLE: {
                return OCBundle.message("symbol.kind.name.uppercase.local.variable", new Object[0]);
            }
            case CATCH_EXCEPTION_VARIABLE: {
                return OCBundle.message("symbol.kind.name.uppercase.exception.variable", new Object[0]);
            }
            case IMPLEMENTATION: {
                return OCBundle.message("symbol.kind.name.uppercase.implementation", new Object[0]);
            }
            case INSTANCE_VARIABLE: {
                return OCBundle.message("symbol.kind.name.uppercase.instance.variable", new Object[0]);
            }
            case INTERFACE: {
                return OCBundle.message("symbol.kind.name.uppercase.interface", new Object[0]);
            }
            case LABEL: {
                return OCBundle.message("symbol.kind.name.uppercase.label", new Object[0]);
            }
            case MACRO: 
            case UNDEF_MACRO: {
                return OCBundle.message("symbol.kind.name.uppercase.macro", new Object[0]);
            }
            case MACRO_PARAMETER: {
                return OCBundle.message("symbol.kind.name.uppercase.macro.parameter", new Object[0]);
            }
            case IMPORT: {
                return OCBundle.message("symbol.kind.name.uppercase.import", new Object[0]);
            }
            case COMPATIBILITY_ALIAS: {
                return OCBundle.message("symbol.kind.name.uppercase.compatibility.alias", new Object[0]);
            }
            case METHOD: {
                return OCBundle.message("symbol.kind.name.uppercase.method1", new Object[0]);
            }
            case BLOCK: {
                return OCBundle.message("symbol.kind.name.uppercase.block", new Object[0]);
            }
            case LAMBDA: {
                return OCBundle.message("symbol.kind.name.uppercase.lambda", new Object[0]);
            }
            case PROPERTY: {
                return OCBundle.message("symbol.kind.name.uppercase.property", new Object[0]);
            }
            case SYNTHESIZE: {
                return OCBundle.message("symbol.kind.name.uppercase.synthesize.statement", new Object[0]);
            }
            case PROTOCOL: {
                return OCBundle.message("symbol.kind.name.uppercase.protocol", new Object[0]);
            }
            case STRUCT: {
                return OCBundle.message("symbol.kind.name.uppercase.struct", new Object[0]);
            }
            case UNION: {
                return OCBundle.message("symbol.kind.name.uppercase.union", new Object[0]);
            }
            case ENUM: {
                return OCBundle.message("symbol.kind.name.uppercase.enum", new Object[0]);
            }
            case NAMESPACE: 
            case NAMESPACE_ALIAS: {
                return OCBundle.message("symbol.kind.name.uppercase.namespace", new Object[0]);
            }
            case TEMPLATE_TYPE_PARAMETER: {
                return OCBundle.message("symbol.kind.name.uppercase.type.parameter", new Object[0]);
            }
            case TEMPLATE_VALUE_PARAMETER: {
                return OCBundle.message("symbol.kind.name.uppercase.template.parameter", new Object[0]);
            }
            case SYMBOL_USING_SYMBOL: 
            case NAMESPACE_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return OCBundle.message("symbol.kind.name.uppercase.using", new Object[0]);
            }
            case LOCALIZED_STRING: {
                return OCBundle.message("symbol.kind.name.uppercase.localized.string", new Object[0]);
            }
            case EXPRESSION: {
                return OCBundle.message("symbol.kind.name.uppercase.expression", new Object[0]);
            }
            case GENERIC_PARAMETER: {
                return OCBundle.message("symbol.kind.name.uppercase.generic.parameter", new Object[0]);
            }
            case CPP_CONCEPT: {
                return OCBundle.message("symbol.kind.name.uppercase.concept", new Object[0]);
            }
            case KEYWORD: {
                return OCBundle.message("symbol.kind.name.uppercase.keyword", new Object[0]);
            }
            case FILE: {
                return OCBundle.message("symbol.kind.name.uppercase.file", new Object[0]);
            }
            case FOLDER: {
                return OCBundle.message("symbol.kind.name.uppercase.folder", new Object[0]);
            }
        }
        return OCBundle.message("symbol.kind.name.uppercase.default", new Object[0]);
    }

    @NotNull
    @Nls
    public String getNameLowercase() {
        switch (this) {
            case TYPEDEF: {
                return OCBundle.message("symbol.kind.name.lowercase.type", new Object[0]);
            }
            case ENUM_CONST: {
                return OCBundle.message("symbol.kind.name.lowercase.enum.constant", new Object[0]);
            }
            case STRUCT_FIELD: {
                return OCBundle.message("symbol.kind.name.lowercase.field", new Object[0]);
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: {
                return OCBundle.message("symbol.kind.name.lowercase.function", new Object[0]);
            }
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return OCBundle.message("symbol.kind.name.lowercase.constructor", new Object[0]);
            }
            case PARAMETER: {
                return OCBundle.message("symbol.kind.name.lowercase.parameter", new Object[0]);
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: {
                return OCBundle.message("symbol.kind.name.lowercase.global.variable", new Object[0]);
            }
            case BUILTIN_SYMBOL: {
                return OCBundle.message("symbol.kind.name.lowercase.built.in.symbol", new Object[0]);
            }
            case LOCAL_VARIABLE: {
                return OCBundle.message("symbol.kind.name.lowercase.local.variable", new Object[0]);
            }
            case CATCH_EXCEPTION_VARIABLE: {
                return OCBundle.message("symbol.kind.name.lowercase.exception.variable", new Object[0]);
            }
            case IMPLEMENTATION: {
                return OCBundle.message("symbol.kind.name.lowercase.implementation", new Object[0]);
            }
            case INSTANCE_VARIABLE: {
                return OCBundle.message("symbol.kind.name.lowercase.instance.variable", new Object[0]);
            }
            case INTERFACE: {
                return OCBundle.message("symbol.kind.name.lowercase.interface", new Object[0]);
            }
            case LABEL: {
                return OCBundle.message("symbol.kind.name.lowercase.label", new Object[0]);
            }
            case MACRO: 
            case UNDEF_MACRO: {
                return OCBundle.message("symbol.kind.name.lowercase.macro", new Object[0]);
            }
            case MACRO_PARAMETER: {
                return OCBundle.message("symbol.kind.name.lowercase.macro.parameter", new Object[0]);
            }
            case IMPORT: {
                return OCBundle.message("symbol.kind.name.lowercase.import", new Object[0]);
            }
            case COMPATIBILITY_ALIAS: {
                return OCBundle.message("symbol.kind.name.lowercase.compatibility.alias", new Object[0]);
            }
            case METHOD: {
                return OCBundle.message("symbol.kind.name.lowercase.method1", new Object[0]);
            }
            case BLOCK: {
                return OCBundle.message("symbol.kind.name.lowercase.block", new Object[0]);
            }
            case LAMBDA: {
                return OCBundle.message("symbol.kind.name.lowercase.lambda", new Object[0]);
            }
            case PROPERTY: {
                return OCBundle.message("symbol.kind.name.lowercase.property", new Object[0]);
            }
            case SYNTHESIZE: {
                return OCBundle.message("symbol.kind.name.lowercase.synthesize.statement", new Object[0]);
            }
            case PROTOCOL: {
                return OCBundle.message("symbol.kind.name.lowercase.protocol", new Object[0]);
            }
            case STRUCT: {
                return OCBundle.message("symbol.kind.name.lowercase.struct", new Object[0]);
            }
            case UNION: {
                return OCBundle.message("symbol.kind.name.lowercase.union", new Object[0]);
            }
            case ENUM: {
                return OCBundle.message("symbol.kind.name.lowercase.enum", new Object[0]);
            }
            case NAMESPACE: 
            case NAMESPACE_ALIAS: {
                return OCBundle.message("symbol.kind.name.lowercase.namespace", new Object[0]);
            }
            case TEMPLATE_TYPE_PARAMETER: {
                return OCBundle.message("symbol.kind.name.lowercase.type.parameter", new Object[0]);
            }
            case TEMPLATE_VALUE_PARAMETER: {
                return OCBundle.message("symbol.kind.name.lowercase.template.parameter", new Object[0]);
            }
            case SYMBOL_USING_SYMBOL: 
            case NAMESPACE_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return OCBundle.message("symbol.kind.name.lowercase.using", new Object[0]);
            }
            case LOCALIZED_STRING: {
                return OCBundle.message("symbol.kind.name.lowercase.localized.string", new Object[0]);
            }
            case EXPRESSION: {
                return OCBundle.message("symbol.kind.name.lowercase.expression", new Object[0]);
            }
            case GENERIC_PARAMETER: {
                return OCBundle.message("symbol.kind.name.lowercase.generic.parameter", new Object[0]);
            }
            case CPP_CONCEPT: {
                return OCBundle.message("symbol.kind.name.lowercase.concept", new Object[0]);
            }
            case KEYWORD: {
                return OCBundle.message("symbol.kind.name.lowercase.keyword", new Object[0]);
            }
            case FILE: {
                return OCBundle.message("symbol.kind.name.lowercase.file", new Object[0]);
            }
            case FOLDER: {
                return OCBundle.message("symbol.kind.name.lowercase.folder", new Object[0]);
            }
        }
        return OCBundle.message("symbol.kind.name.lowercase.default", new Object[0]);
    }

    public Class<? extends PsiElement> getPsiElementClass() {
        switch (this) {
            case BUILTIN_SYMBOL: {
                return PsiElement.class;
            }
            case IMPLEMENTATION: {
                return OCImplementation.class;
            }
            case INTERFACE: 
            case PROTOCOL: {
                return OCClassDeclaration.class;
            }
            case LABEL: {
                return OCLabeledStatement.class;
            }
            case MACRO: {
                return OCDefineDirective.class;
            }
            case UNDEF_MACRO: {
                return OCUndefDirective.class;
            }
            case MACRO_PARAMETER: {
                return OCMacroParameter.class;
            }
            case IMPORT: {
                return OCIncludeDirective.class;
            }
            case COMPATIBILITY_ALIAS: {
                return OCCompatibilityAlias.class;
            }
            case METHOD: {
                return OCMethod.class;
            }
            case BLOCK: {
                return OCBlockExpression.class;
            }
            case SYNTHESIZE: {
                return OCSynthesizeProperty.class;
            }
            case STRUCT: {
                return OCStruct.class;
            }
            case UNION: {
                return OCUnion.class;
            }
            case ENUM: {
                return OCEnum.class;
            }
            case NAMESPACE: {
                return OCCppNamespace.class;
            }
            case NAMESPACE_ALIAS: {
                return OCCppNamespaceAlias.class;
            }
            case TEMPLATE_TYPE_PARAMETER: {
                return OCTypeParameterDeclaration.class;
            }
            case SYMBOL_USING_SYMBOL: 
            case NAMESPACE_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return OCCppUsingStatement.class;
            }
            case LOCALIZED_STRING: {
                return OCLocalizedString.class;
            }
            case EXPRESSION: {
                return OCExpression.class;
            }
            case GENERIC_PARAMETER: {
                return OCGenericParameter.class;
            }
            case CPP_CONCEPT: {
                return OCConceptDeclaration.class;
            }
        }
        return OCDeclarator.class;
    }

    public Icon getIcon() {
        switch (this) {
            case NAMESPACE: 
            case NAMESPACE_ALIAS: 
            case NAMESPACE_USING_SYMBOL: {
                return CidrLangIcons.CodeAssistantNamespace;
            }
            case TYPEDEF: 
            case TEMPLATE_TYPE_PARAMETER: 
            case SYMBOL_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return CidrLangIcons.CodeAssistantType;
            }
            case ENUM_CONST: {
                return CidrLangIcons.CodeAssistantEnumConst;
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: 
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return CidrLangIcons.CodeAssistantFunction;
            }
            case STRUCT_FIELD: 
            case INSTANCE_VARIABLE: {
                return CidrLangIcons.CodeAssistantField;
            }
            case IMPLEMENTATION: 
            case INTERFACE: {
                return CidrLangIcons.CodeAssistantClass;
            }
            case MACRO: 
            case UNDEF_MACRO: 
            case MACRO_PARAMETER: 
            case IMPORT: {
                return CidrLangIcons.CodeAssistantMacro;
            }
            case COMPATIBILITY_ALIAS: {
                return CidrLangIcons.CodeAssistantClass;
            }
            case METHOD: {
                return CidrLangIcons.CodeAssistantMember;
            }
            case PROPERTY: {
                return CidrLangIcons.CodeAssistantProperty;
            }
            case PROTOCOL: {
                return CidrLangIcons.CodeAssistantProtocol;
            }
            case STRUCT: {
                return CidrLangIcons.CodeAssistantStruct;
            }
            case UNION: {
                return CidrLangIcons.CodeAssistantUnion;
            }
            case ENUM: {
                return CidrLangIcons.CodeAssistantEnum;
            }
            case PARAMETER: 
            case TEMPLATE_VALUE_PARAMETER: 
            case GENERIC_PARAMETER: {
                return CidrLangIcons.CodeAssistantParameter;
            }
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case LABEL: {
                return CidrLangIcons.CodeAssistantLocal;
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case BUILTIN_SYMBOL: {
                return CidrLangIcons.CodeAssistantGlobal;
            }
            case BLOCK: 
            case LAMBDA: 
            case SYNTHESIZE: 
            case LOCALIZED_STRING: 
            case EXPRESSION: {
                return null;
            }
        }
        return null;
    }

    @NotNull
    @Nls
    public String getNameUppercase() {
        return this.getName();
    }

    public boolean isClass() {
        switch (this) {
            case IMPLEMENTATION: 
            case INTERFACE: 
            case COMPATIBILITY_ALIAS: 
            case PROTOCOL: {
                return true;
            }
        }
        return false;
    }

    public boolean isClassOrTypedef() {
        return this.isClass() || this == TYPEDEF || this == USING_SYMBOL_ALIAS;
    }

    public boolean isType() {
        return this.isClassOrTypedef() || this.isStructLike() || this == TEMPLATE_TYPE_PARAMETER || this == COMPATIBILITY_ALIAS || this == GENERIC_PARAMETER;
    }

    public boolean isStructLike() {
        switch (this) {
            case STRUCT: 
            case UNION: 
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    @NlsSafe
    @NotNull
    public String getStructKeyword() {
        switch (this) {
            case STRUCT: {
                return "struct";
            }
            case UNION: {
                return "union";
            }
            case ENUM: {
                return "enum";
            }
        }
        OCLog.LOG.error("getStructKeyword should be called on isStructLike symbol kind");
        return "";
    }

    public boolean isStructOrUnion() {
        return this == STRUCT || this == UNION;
    }

    public boolean isFunction() {
        return this == FUNCTION_PREDECLARATION || this == FUNCTION_DECLARATION;
    }

    public boolean isFunctionOrConstructor() {
        return this.isFunction() || this.isConstructorOrDestructor();
    }

    public boolean isCallable() {
        return this.isFunction() || this == METHOD || this == BLOCK || this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == LAMBDA;
    }

    public boolean isPredeclaration() {
        return this == FUNCTION_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == STRUCT_FIELD;
    }

    public boolean isLocal() {
        return this == LOCAL_VARIABLE || this == CATCH_EXCEPTION_VARIABLE || this == LABEL || this == PARAMETER;
    }

    public boolean isConst() {
        return this == ENUM_CONST || this == TEMPLATE_VALUE_PARAMETER || this == GENERIC_PARAMETER || this.isFunction();
    }

    public OCSymbolKind toDeclarationKind() {
        switch (this) {
            case FUNCTION_PREDECLARATION: {
                return FUNCTION_DECLARATION;
            }
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return CPP_CONSTRUCTOR_DECLARATION;
            }
            case GLOBAL_VARIABLE_PREDECLARATION: {
                return GLOBAL_VARIABLE;
            }
        }
        return this;
    }

    public boolean isExpression() {
        switch (this) {
            case ENUM_CONST: 
            case STRUCT_FIELD: 
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: 
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: 
            case PARAMETER: 
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case BUILTIN_SYMBOL: 
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case INSTANCE_VARIABLE: 
            case LAMBDA: 
            case PROPERTY: 
            case TEMPLATE_VALUE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public boolean isVariable() {
        switch (this) {
            case ENUM_CONST: 
            case PARAMETER: 
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case INSTANCE_VARIABLE: 
            case PROPERTY: 
            case TEMPLATE_VALUE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalVariable() {
        return this == GLOBAL_VARIABLE || this == GLOBAL_VARIABLE_PREDECLARATION;
    }

    public boolean isConstructorOrDestructor() {
        return this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION;
    }

    public boolean isTemplateParameter() {
        return this == TEMPLATE_VALUE_PARAMETER || this == TEMPLATE_TYPE_PARAMETER || this == GENERIC_PARAMETER;
    }

    public boolean isTypedefOrAlias() {
        return this == TYPEDEF || this == COMPATIBILITY_ALIAS || this == USING_SYMBOL_ALIAS;
    }

    public boolean canBeNamespace() {
        switch (this) {
            case TYPEDEF: 
            case STRUCT: 
            case UNION: 
            case ENUM: 
            case NAMESPACE: 
            case NAMESPACE_ALIAS: 
            case TEMPLATE_TYPE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public static OCSymbolKind parse(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("struct") || name.equals("class")) {
            return STRUCT;
        }
        if (name.equals("enum")) {
            return ENUM;
        }
        if (name.equals("union")) {
            return UNION;
        }
        if (name.equals("concept")) {
            return CPP_CONCEPT;
        }
        return null;
    }

    public boolean isSame(@NotNull OCSymbolKind kind) {
        return this == kind || this == FUNCTION_DECLARATION && kind == FUNCTION_PREDECLARATION || this == FUNCTION_PREDECLARATION && kind == FUNCTION_DECLARATION || this == CPP_CONSTRUCTOR_DECLARATION && kind == CPP_CONSTRUCTOR_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION && kind == CPP_CONSTRUCTOR_DECLARATION || this == GLOBAL_VARIABLE && kind == GLOBAL_VARIABLE_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION && kind == GLOBAL_VARIABLE;
    }
}

