/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.symbols.MaybeVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.OCBestSymbolInSelectedConfiguration;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolBase
implements OCSymbol,
MaybeVirtualFileOwner {
    @Nullable
    protected transient VirtualFile myFile;
    protected long myComplexOffset;

    public OCSymbolBase(@Nullable VirtualFile file, long complexOffset) {
        this.myFile = file;
        this.myComplexOffset = complexOffset;
    }

    public OCSymbolBase() {
    }

    @NotNull
    public static String getSymbolName(@Nullable OCSymbol symbol) {
        return symbol == null ? "<unnamed>" : symbol.getName();
    }

    @NotNull
    public static String getTagOfStructLike(OCSymbol symbol) {
        String kind = symbol.getKind().getNameLowercase() + " ";
        String name = symbol.getPresentableName();
        if (name.startsWith(kind)) {
            return name.substring(kind.length());
        }
        return name;
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(@Nullable String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project, @Nullable VirtualFile context) {
        OCBestSymbolInSelectedConfiguration findBestInSelectedConfiguration = new OCBestSymbolInSelectedConfiguration(project, context);
        OCSymbolBase.findSymbolDefinition(name, symbolKind, project, context, findBestInSelectedConfiguration);
        return findBestInSelectedConfiguration.getBestCandidate();
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(@Nullable String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project, @Nullable VirtualFile context, @Nullable Condition<? super T> condition) {
        return (T)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, name, (Condition<? super OCSymbol>)((Condition)symbol -> symbol.getKind() == symbolKind && !symbol.isPredeclaration() && (condition == null || condition.value(symbol))), context);
    }

    @Override
    public void init(@Nullable VirtualFile file) {
        this.myFile = file;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    @Nullable
    public PsiElement locateDefinition(@NotNull Project project) {
        return OCSymbolBase.doLocateDefinition(this, project, this.getPsiElementClass());
    }

    @Nullable
    public static <T extends PsiElement> T doLocateDefinition(@NotNull OCSymbol symbol, @NotNull Project project, @NotNull Class<T> elementClass) {
        PsiFile file = symbol.getContainingPsiFile(project);
        if (file == null || !file.isValid()) {
            return null;
        }
        return OCSymbolBase.doLocateDefinition(elementClass, symbol.getComplexOffset(), file, symbol.isUnnamed());
    }

    @Nullable
    public static <T extends PsiElement> T doLocateDefinition(@NotNull Class<T> elementClass, long symbolComplexOffset, PsiFile file, boolean unnamed) {
        PsiElement cur = file.findElementAt(OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset));
        if (cur == null) {
            return null;
        }
        cur = PsiTreeUtil.getDeepestLast((PsiElement)cur);
        do {
            long curComplexOffset;
            if ((curComplexOffset = OCSymbolOffsetUtil.getComplexOffset(cur)) == symbolComplexOffset) {
                T definitionAtPrev;
                T definitionAtCur = OCSymbolBase.findParentDefinition(cur, elementClass, symbolComplexOffset);
                if (definitionAtCur != null) {
                    return definitionAtCur;
                }
                if (unnamed && (definitionAtPrev = OCSymbolBase.findParentDefinition(PsiTreeUtil.prevLeaf((PsiElement)cur), elementClass, symbolComplexOffset)) != null) {
                    return definitionAtPrev;
                }
                return null;
            }
            if (OCSymbolOffsetUtil.getTextOffset(curComplexOffset) == OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset)) continue;
            return null;
        } while ((cur = PsiTreeUtil.prevLeaf((PsiElement)cur)) != null);
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T findParentDefinition(@Nullable PsiElement cur, @NotNull Class<T> elementClass, long symbolComplexOffset) {
        if (cur == null) {
            return null;
        }
        PsiElement parent = cur;
        do {
            if (!elementClass.isInstance(parent) || OCSymbolOffsetUtil.getVirtualComplexOffset(parent) != symbolComplexOffset) continue;
            return (T)parent;
        } while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)true)) != null);
        return null;
    }

    public String toString() {
        return this.getKind() + "[" + this.getPresentableName() + "]@" + (String)(this.getContainingFile() != null ? this.getContainingFile().getName() + ":" : "") + this.getOffset();
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public long getComplexOffset() {
        return this.myComplexOffset;
    }

    @Override
    public void setComplexOffset(long complexOffset) {
        this.myComplexOffset = complexOffset;
    }

    public int hashCode() {
        int result = this.hashCodeExcludingOffset();
        result = 31 * result + (int)this.getComplexOffset();
        return result;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return OCLanguage.getInstance();
    }
}

