/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.IconManager;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCSymbol
extends OCTypeOwner,
Serializable,
DeepEqual.Equality,
PsiElementNavigationItem,
Comparable {
    @NlsSafe
    public static final String UNNAMED = "<unnamed>";
    public static final Condition<OCSymbol> NON_PREDEFINITION_CONDITION = symbol -> !symbol.isPredeclaration();
    public static final Condition<OCSymbol> NON_FANTOM_SYMBOL_CONDITION = symbol -> symbol.getContainingFile() != null || symbol.getOffset() != 0;
    public static final Comparator<OCSymbol> PRESENTABLE_NAME_COMPARATOR = Comparator.comparing(OCSymbol::getPresentableName);
    public static final String ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE = "\"not available in automatic reference counting mode\"";

    @NotNull
    @NlsSafe
    public String getName();

    @Nullable
    public VirtualFile getContainingFile();

    @NotNull
    default public Class<? extends PsiElement> getPsiElementClass() {
        return this.getKind().getPsiElementClass();
    }

    @Nullable
    public PsiElement locateDefinition(@NotNull Project var1);

    @NotNull
    public OCSymbolKind getKind();

    public long getComplexOffset();

    public int hashCodeExcludingOffset();

    @NotNull
    default public OCType getType() {
        return OCUnknownType.INSTANCE;
    }

    @Override
    @NotNull
    default public OCType getResolvedType(@NotNull OCResolveContext context) {
        return this.getType().resolve(context);
    }

    default public OCType getResolvedType(@NotNull OCResolveContext context, boolean ignoringImports) {
        return this.getType().resolve(context, ignoringImports);
    }

    public boolean isGlobal();

    default public boolean isCallable() {
        return this.getKind().isCallable();
    }

    default public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    default public boolean isPredeclaration() {
        return this.getKind().isPredeclaration();
    }

    @NotNull
    default public List<String> getAttributes() {
        return Collections.emptyList();
    }

    default public boolean isUnnamed() {
        return UNNAMED.equals(this.getName());
    }

    default public void compact() {
    }

    @NotNull
    default public String getSignature(@NotNull Project project) {
        return this.getPresentableName();
    }

    @NotNull
    @NlsSafe
    default public String getPresentableName() {
        return this.getName();
    }

    @Nullable
    @NlsSafe
    default public String getLocationString() {
        VirtualFile file = this.getContainingFile();
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    default public boolean isSynthetic() {
        return false;
    }

    @NotNull
    @Nls
    default public String getNameWithKindLowercase(@NotNull OCCompilationContext context) {
        return this.getKindLowercase(context) + " '" + this.getPresentableName() + "'";
    }

    @NotNull
    @Nls
    default public String getNameWithKindUppercase(@NotNull OCCompilationContext context) {
        return this.getKindUppercase(context) + " '" + this.getPresentableName() + "'";
    }

    @Nls
    default public String getKindLowercase(@NotNull OCCompilationContext context) {
        return StringUtil.decapitalize((String)this.getKindUppercase(context));
    }

    @NotNull
    @Nls
    default public String getKindUppercase(@NotNull OCCompilationContext context) {
        return this.getKind().getNameUppercase();
    }

    @Nullable
    default public OCSymbol getDefinitionSymbol(@NotNull Project project) {
        if (this.isPredeclaration()) {
            return OCSymbolBase.findSymbolDefinition(this.getName(), this.getKind(), project, this.getContainingFile());
        }
        return this;
    }

    default public boolean processAssociatedSymbols(@NotNull Processor<OCSymbol> processor, @NotNull Project project) {
        OCSymbol associatedSymbol = this.getAssociatedSymbol(project);
        return associatedSymbol == null || processor.process((Object)associatedSymbol);
    }

    @Nullable
    default public OCSymbol getAssociatedSymbol(@NotNull Project project) {
        return null;
    }

    default public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor, @NotNull Project project) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)((Processor)symbol -> symbol.getClass() != this.getClass() || processor.process(symbol)), this.getName());
    }

    @Nullable
    default public PsiFile getContainingPsiFile(@NotNull Project project) {
        VirtualFile containingFile = this.getContainingFile();
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        return OCLanguageUtils.tryGetOCFile(PsiManager.getInstance((Project)project).findFile(containingFile));
    }

    @Nullable
    default public OCFile getContainingOCFile(@NotNull Project project) {
        PsiFile file = this.getContainingPsiFile(project);
        return OCLanguageUtils.asOCFile(file);
    }

    default public int getOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    default public void setComplexOffset(long complexOffset) {
    }

    @Nullable
    default public ComplexTextRange getScope() {
        return null;
    }

    default public void setScope(@NotNull ComplexTextRange scope) {
    }

    default public void updateOffset(int start, int lengthShift) {
        if (this.getOffset() > start) {
            this.setComplexOffset(OCSymbolOffsetUtil.shift(this.getComplexOffset(), lengthShift));
        }
        if (this.getScope() != null) {
            this.setScope(OCSymbolOffsetUtil.shift(this.getScope(), start, lengthShift));
        }
    }

    @Nullable
    default public Icon getIcon(@NotNull Project project) {
        if (Registry.is((String)"psi.deferIconLoading")) {
            return IconManager.getInstance().createDeferredIcon(this.getBaseIcon(), (Object)this, symbol -> this.computeFullIconNow(null, project));
        }
        return this.computeFullIconNow(null, project);
    }

    @Nullable
    default public Icon getBaseIcon() {
        return this.getKind().getIcon();
    }

    @Nullable
    default public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        return this.getBaseIcon();
    }

    default public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull Project project) {
        return this.equals(symbol);
    }

    @NotNull
    default public OCType getEffectiveType(@NotNull Project project) {
        return this.getType();
    }

    @NotNull
    default public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        return this.getResolvedType(context);
    }

    default public boolean isDeprecated() {
        return this.hasAttribute("deprecated");
    }

    @NotNull
    default public String getDeprecatedMessage(@NotNull OCCompilationContext context) {
        String message = this.getNameWithKindUppercase(context) + " is deprecated";
        String parameters = this.getAttributeParameters("deprecated");
        return parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
    }

    default public boolean isUnavailable() {
        return this.hasAttribute("unavailable") && !ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable"));
    }

    default public boolean isUnused() {
        return this.hasAttribute("unused") || this.hasAttribute("used") || this.hasAttribute("maybe_unused");
    }

    @NotNull
    default public String getUnavailableMessage(@NotNull OCCompilationContext context) {
        String message = this.getNameWithKindUppercase(context) + " is unavailable";
        String parameters = this.getAttributeParameters("unavailable");
        return parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
    }

    default public boolean isForbiddenByARC(@NotNull PsiElement context) {
        return this.hasAttribute("unavailable") && ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable")) && OCCompilerFeaturesHelper.isArcEnabled(context.getContainingFile());
    }

    default public boolean isTransparentUnion() {
        return this.hasAttribute("transparent_union");
    }

    default public boolean hasAttribute(@NonNls @NotNull String attribute) {
        return OCAttributes.hasAttribute(this.getAttributes(), (String)attribute);
    }

    @Nullable
    @NlsSafe
    default public String getAttributeParameters(@NotNull String attribute) {
        return OCAttributes.getAttributeParameter(this.getAttributes(), (String)attribute);
    }

    @NotNull
    default public OCSymbol getDelegate() {
        return this;
    }

    @NotNull
    default public String getPresentableText() {
        return this.getPresentableName();
    }

    @Deprecated
    @Nullable
    default public PsiElement getTargetElement() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    @Nullable
    default public ItemPresentation getPresentation() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public void navigate(boolean requestFocus2) {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public boolean canNavigate() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public boolean canNavigateToSource() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public int compareTo(@NotNull Object o) {
        throw new UnsupportedOperationException("Please provide an external comparator to wherever it's used");
    }

    @NotNull
    default public Language getLanguage() {
        throw new UnsupportedOperationException("Symbol: " + this.getClass().getName() + " does not yet define what language it is defined in");
    }
}

