/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.symtable.OCQualifiedNamesInterner;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedName
implements Serializable,
DeepEqual.Equality<OCQualifiedName> {
    @NotNull
    private static final String GLOBAL_NAME = "";
    @NotNull
    public static final OCQualifiedName GLOBAL = new OCQualifiedName(null, "");
    @Nullable
    protected OCQualifiedName myQualifier;
    @Nullable
    protected String myName;

    protected OCQualifiedName() {
    }

    protected OCQualifiedName(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        this.myQualifier = qualifier;
        this.myName = name;
    }

    @NotNull
    public static OCQualifiedName interned(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        OCQualifiedName result = OCQualifiedName.with(qualifier, name);
        return result == GLOBAL ? result : OCQualifiedNamesInterner.intern(result);
    }

    @NotNull
    public static OCQualifiedName with(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        if (qualifier == null && GLOBAL_NAME.equals(name)) {
            return GLOBAL;
        }
        return new OCQualifiedName(qualifier, name);
    }

    @NotNull
    public static OCQualifiedName interned(@Nullable String name) {
        return OCQualifiedName.interned(null, name);
    }

    @NotNull
    public static OCQualifiedName with(@Nullable String name) {
        return OCQualifiedName.with(null, name);
    }

    public static boolean areResolvedNamesEquals(@Nullable OCQualifiedName a, @Nullable OCQualifiedName b, @NotNull OCResolveContext context) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        return a.resolvedEqualsStep(b, context);
    }

    protected boolean resolvedEqualsStep(@NotNull OCQualifiedName other, @NotNull OCResolveContext context) {
        if (!Objects.equals(this.myName, other.myName)) {
            return false;
        }
        return OCQualifiedName.areResolvedNamesEquals(this.myQualifier, other.myQualifier, context);
    }

    @Nullable
    public OCQualifiedName getQualifier() {
        return this.myQualifier;
    }

    @Nullable
    @NlsSafe
    public String getName() {
        return this.myName;
    }

    public OCQualifiedName dropArguments() {
        if (this.myQualifier != null) {
            return OCQualifiedName.with(this.myQualifier.dropArguments(), this.myName);
        }
        return this;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (!Objects.equals(first.myName, second.myName)) {
            return false;
        }
        return c.equalObjects(first.myQualifier, second.myQualifier);
    }

    public boolean canThisNamePartBeInterned() {
        return true;
    }

    public final boolean equals(@Nullable Object o) {
        return DeepEqual.equalObjects(this, o);
    }

    public int hashCode() {
        int result = this.myQualifier != null ? this.myQualifier.hashCode() : 0;
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        return result;
    }

    public String getSuperQualifier() {
        return this.myQualifier == null ? this.myName : this.myQualifier.getSuperQualifier();
    }

    public boolean isAbsolute() {
        if (this == GLOBAL) {
            return true;
        }
        if (this.myQualifier == null) {
            return false;
        }
        return this.myQualifier.isAbsolute();
    }

    @NotNull
    public OCQualifiedName dropSuperQualifier() {
        if (this.myQualifier == null) {
            return this;
        }
        if (this.myQualifier.myQualifier == null) {
            return this.changeQualifier(null);
        }
        return this.changeQualifier(this.myQualifier.dropSuperQualifier());
    }

    @NotNull
    public OCQualifiedName changeName(@Nullable String name) {
        if (Objects.equals(this.myName, name)) {
            return this;
        }
        return OCQualifiedName.with(this.myQualifier, name);
    }

    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        return OCQualifiedName.with(qualifier, this.myName);
    }

    public OCQualifiedName append(OCQualifiedName name) {
        OCQualifiedName appended = OCQualifiedName.with(this, name.getSuperQualifier());
        return name.getQualifier() == null ? appended : appended.append(name.dropSuperQualifier());
    }

    @NlsSafe
    public String getFullName(@NotNull OCResolveContext context) {
        return this.getCanonicalName(OCType.Presentation.FULL, true, context, 0);
    }

    @NlsSafe
    private String doGetShortName() {
        return this.myName != null ? this.myName : "<anonymous>";
    }

    @NlsSafe
    public String getCanonicalName(@NotNull OCType.Presentation presentation, boolean includeGlobalQualifier, @NotNull OCResolveContext context, int templateDepth) {
        String name = this.doGetShortName();
        return this.myQualifier != null && (includeGlobalQualifier || this.myQualifier != GLOBAL) ? this.myQualifier.getCanonicalName(presentation, includeGlobalQualifier, context, templateDepth) + "::" + name : name;
    }

    @NlsSafe
    public String getShortName(int templateDepth) {
        return this.doGetShortName();
    }

    @NlsSafe
    public String getNameWithParent() {
        String name = this.doGetShortName();
        return this.myQualifier != null && this.myQualifier != GLOBAL ? this.myQualifier.doGetShortName() + "::" + name : name;
    }

    public static OCQualifiedName parse(String qualifiedName) {
        OCQualifiedName result = null;
        for (String name : qualifiedName.split("::")) {
            result = OCQualifiedName.with(result, name);
        }
        return result;
    }

    public String toString() {
        String name = this.getShortName(0);
        return this.myQualifier != null && this.myQualifier != GLOBAL ? this.myQualifier.toString() + "::" + name : name;
    }

    public List<String> flatten() {
        ArrayList<String> result = new ArrayList<String>();
        for (OCQualifiedName current = this; current != null; current = current.getQualifier()) {
            result.add(current.getName());
        }
        Collections.reverse(result);
        return result;
    }

    public List<Pair<String, List<OCTypeArgument>>> flattenWithArguments() {
        ArrayList<Pair<String, List<OCTypeArgument>>> result = new ArrayList<Pair<String, List<OCTypeArgument>>>();
        for (OCQualifiedName current = this; current != null; current = current.getQualifier()) {
            result.add((Pair<String, List<OCTypeArgument>>)Pair.create((Object)current.getName(), current instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)current).getArguments() : null));
        }
        Collections.reverse(result);
        return result;
    }

    @Nullable
    public String getLeftmostQualifier() {
        return this.myQualifier == null ? this.myName : this.myQualifier.getLeftmostQualifier();
    }

    public OCQualifiedName cloneWithOffset(@NotNull OCSymbolReference reference) {
        return this.myQualifier != null ? new OCQualifiedName(this.myQualifier.cloneWithOffset(reference), this.myName) : this;
    }

    public int getDepth() {
        return (this.myQualifier != null ? this.myQualifier.getDepth() : 0) + 1;
    }
}

