/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileQualityDetector {
    private static final float MAXIMUM_ERROR_RATIO = 0.25f;
    private static final Key<CachedValue<Ref<Boolean>>> PARSE_WITH_MANY_ERRORS = Key.create((String)"PARSE_WITH_MANY_ERRORS");

    public static boolean containsTooManyErrors(@Nullable PsiFile file) {
        if (file == null || !Registry.is((String)"cidr.enable.filtering.out.files.with.errors")) {
            return false;
        }
        Ref<Boolean> cache = OCFileQualityDetector.getContainsTooManyErrorsCache(file);
        if (!cache.isNull()) {
            return (Boolean)cache.get();
        }
        boolean dirtyFile = OCFileQualityDetector.checkContainsTooManyErrors(file);
        cache.set((Object)dirtyFile);
        return dirtyFile;
    }

    private static boolean checkContainsTooManyErrors(@NotNull PsiFile file) {
        final long[] errorCount = new long[]{0L};
        final long[] linesWithCode = new long[]{1L};
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof PsiErrorElement) {
                    errorCount[0] = errorCount[0] + 1L;
                    return;
                }
                if (element instanceof PsiWhiteSpace) {
                    if (!(element.getPrevSibling() instanceof OCDirective) && element.textContains('\n')) {
                        linesWithCode[0] = linesWithCode[0] + 1L;
                    }
                    return;
                }
                if (element instanceof LazyParseablePsiElement || element instanceof PsiComment || element instanceof OCDirective) {
                    return;
                }
                super.visitElement(element);
            }
        });
        return (float)errorCount[0] / (float)linesWithCode[0] > 0.25f;
    }

    private static Ref<Boolean> getContainsTooManyErrorsCache(@NotNull PsiFile file) {
        return (Ref)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, PARSE_WITH_MANY_ERRORS, () -> new CachedValueProvider.Result((Object)Ref.create(), new Object[]{FileSymbolTablesCache.getInstance(file.getProject()).getOutOfBlockModificationTracker()}), false);
    }
}

