/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public interface OCCompilationContext {
    public boolean isCpp();

    @NotNull
    public Project getProject();

    @NotNull
    public static OCCompilationContext create(final @NotNull OCSymbol s, final @NotNull Project p) {
        return new OCCompilationContext(){

            @Override
            public boolean isCpp() {
                return !OCCodeInsightUtil.isInPlainOldC((PsiElement)s.getContainingPsiFile(p));
            }

            @Override
            @NotNull
            public Project getProject() {
                return p;
            }
        };
    }

    @NotNull
    public static OCCompilationContext create(final @NotNull PsiElement psiContext) {
        return new OCCompilationContext(){

            @Override
            public boolean isCpp() {
                return !OCCodeInsightUtil.isInPlainOldC(psiContext);
            }

            @Override
            @NotNull
            public Project getProject() {
                return psiContext.getProject();
            }
        };
    }
}

