/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationContext<T> {
    private OCSymbolKind declaratorType;
    protected Object parent;
    private int parameterIndex = -1;
    private OCLambdaExpressionSymbol lambda;
    protected OCSymbolWithQualifiedName myParentSymbol;
    private OCVisibility visibility;
    protected boolean isDeclarationWithoutDeclarators;
    protected boolean isDeclarationWithoutType;
    protected boolean isStructuredBindingDeclaration = false;
    protected boolean isDeductionGuide = false;
    protected T myStructuredBindingInitializer = null;
    protected int myDeclaratorIndex = -1;
    private boolean isBaseClause;
    private boolean isTemplateValueParameter;
    private boolean isLambdaInitCapture;
    private boolean isArrayInitializer;
    private List<String> attributes;
    private PsiElement localContext;
    protected T myKRParameterList;
    protected T myDeductionGuideTypeElement;
    private ASTNode forCollection;
    private final Stack<List<Pair<OCSymbolReference, Long>>> referencesInDeclaration = new Stack();
    private final Stack<T> declarations = new Stack();
    private final List<T> myTemplateParameters = new ArrayList<T>();
    private boolean myIsTemplateSymbol;
    private boolean myInsideTemplateArguments;
    private boolean mySpecialization;
    private boolean skipBaseClasses;
    private boolean myAssumeNonNull;
    private int myModifiers = 0;

    public DeclarationContext(OCSymbolKind declaratorType, Object parent, OCSymbolWithQualifiedName parentSymbol, OCVisibility visibility, PsiElement localContext, boolean assumeNonNull) {
        this.declaratorType = declaratorType;
        this.parent = parent;
        this.myParentSymbol = parentSymbol;
        this.visibility = visibility;
        this.localContext = localContext;
        this.myAssumeNonNull = assumeNonNull;
    }

    public DeclarationContext(OCSymbolKind declaratorType) {
        this.declaratorType = declaratorType;
    }

    public DeclarationContext() {
    }

    public OCSymbolKind getDeclaratorType() {
        return this.declaratorType;
    }

    public void setDeclaratorType(OCSymbolKind declaratorType) {
        this.declaratorType = declaratorType;
    }

    public Object getParent() {
        return this.parent;
    }

    public OCSymbolWithQualifiedName getParentSymbol() {
        return this.myParentSymbol;
    }

    public OCVisibility getVisibility() {
        return this.isFriend() ? OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC : this.visibility;
    }

    public boolean isFriend() {
        return this.hasModifier(OCSymbolAttribute.FRIEND);
    }

    public boolean isVirtual() {
        return this.hasModifier(OCSymbolAttribute.VIRTUAL);
    }

    public boolean isConstexpr() {
        return this.hasModifier(OCSymbolAttribute.CONSTEXPR);
    }

    public boolean isBaseClause() {
        return this.isBaseClause;
    }

    public void setBaseClause(boolean isBaseClause) {
        this.isBaseClause = isBaseClause;
    }

    public boolean isTemplateValueParameter() {
        return this.isTemplateValueParameter;
    }

    public void setTemplateValueParameter(boolean isTemplateValueParameter) {
        this.isTemplateValueParameter = isTemplateValueParameter;
    }

    public boolean isArrayInitializer() {
        return this.isArrayInitializer;
    }

    public void setArrayInitializer(boolean arrayInitializer) {
        this.isArrayInitializer = arrayInitializer;
    }

    public void addModifier(@NotNull OCSymbolAttribute modifier) {
        this.myModifiers |= modifier.getMask();
    }

    int getModifiers() {
        return this.myModifiers;
    }

    public boolean hasModifier(@NotNull OCSymbolAttribute modifier) {
        return (this.myModifiers & modifier.getMask()) != 0;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void addAttributes(List<String> attributes) {
        if (this.attributes == null) {
            this.attributes = attributes;
        } else {
            this.attributes.addAll(attributes);
        }
    }

    public PsiElement getLocalContext() {
        return this.localContext;
    }

    public void setLocalContext(@Nullable PsiElement localContext) {
        this.localContext = localContext;
    }

    public List<T> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    public void setDeclarationWithoutDeclarators(boolean declarationWithoutDeclarators) {
        this.isDeclarationWithoutDeclarators = declarationWithoutDeclarators;
    }

    public void setDeclarationWithoutType(boolean declarationWithoutType) {
        this.isDeclarationWithoutType = declarationWithoutType;
    }

    public void setStructuredBindingDeclaration(boolean structuredBindingDeclaration) {
        this.isStructuredBindingDeclaration = structuredBindingDeclaration;
    }

    public void setStructuredBindingInitializer(@Nullable T node) {
        this.myStructuredBindingInitializer = node;
    }

    public void setDeductionGuide(boolean deductionGuide) {
        this.isDeductionGuide = deductionGuide;
    }

    public void setDeclaratorIndex(int declaratorIndex) {
        this.myDeclaratorIndex = declaratorIndex;
    }

    public ASTNode getForCollection() {
        return this.forCollection;
    }

    public void setForCollection(ASTNode forCollection) {
        this.forCollection = forCollection;
    }

    @NotNull
    public List<Pair<OCSymbolReference, Long>> getReferencesInDeclaration() {
        return (List)this.referencesInDeclaration.peek();
    }

    public void addSymbolReference(@NotNull Pair<OCSymbolReference, Long> reference) {
        if (!this.referencesInDeclaration.isEmpty()) {
            ((List)this.referencesInDeclaration.peek()).add(reference);
        }
    }

    public void pushDeclaration(T declaration) {
        this.declarations.push(declaration);
        this.referencesInDeclaration.push(new ArrayList());
    }

    public void popDeclaration() {
        this.referencesInDeclaration.pop();
        this.declarations.pop();
    }

    public T getCurrentDeclaration() {
        if (this.declarations.isEmpty()) {
            return null;
        }
        return (T)this.declarations.peek();
    }

    public boolean isTemplateSymbol() {
        return this.myIsTemplateSymbol;
    }

    public void setTemplateSymbol(boolean templateSymbol) {
        this.myIsTemplateSymbol = templateSymbol;
    }

    public boolean isInsideTemplateArguments() {
        return this.myInsideTemplateArguments;
    }

    public void setInsideTemplateArguments(boolean insideTemplateArguments) {
        this.myInsideTemplateArguments = insideTemplateArguments;
    }

    public boolean isSpecialization() {
        return this.mySpecialization;
    }

    public void setSpecialization(boolean classSpecialization) {
        this.mySpecialization = classSpecialization;
    }

    public boolean skipBaseClasses() {
        return this.skipBaseClasses || this.mySpecialization;
    }

    public void setSkipBaseClasses(boolean skipBaseClasses) {
        this.skipBaseClasses = skipBaseClasses;
    }

    public boolean isAssumeNonNull() {
        return this.myAssumeNonNull;
    }

    public void setAssumeNonNull(boolean assumeNonNull) {
        this.myAssumeNonNull = assumeNonNull;
    }

    @Nullable
    public OCLambdaExpressionSymbol getLambda() {
        return this.lambda;
    }

    public void setLambda(OCLambdaExpressionSymbol lambda2) {
        this.lambda = lambda2;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public void setParameterIndex(int lambdaParameterIndex) {
        this.parameterIndex = lambdaParameterIndex;
    }

    public boolean isLambdaInitCapture() {
        return this.isLambdaInitCapture;
    }

    public void setLambdaInitCapture(boolean lambdaInitCapture) {
        this.isLambdaInitCapture = lambdaInitCapture;
    }
}

