/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages.rules;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OCGroupRuleProviderBase<T extends PsiElement>
implements FileStructureGroupRuleProvider {
    OCGroupRuleProviderBase() {
    }

    @Nullable
    public UsageGroupingRule getUsageGroupingRule(@NotNull Project project) {
        return new SingleParentUsageGroupingRule(){

            @Nullable
            protected UsageGroup getParentGroupFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
                PsiElement psiElement;
                if (usage instanceof PsiElementUsage && (psiElement = ((PsiElementUsage)usage).getElement()).getLanguage().isKindOf(OCLanguageUtils.getSlowLanguage())) {
                    return OCGroupRuleProviderBase.this.createUsageGroupForElement(psiElement);
                }
                return null;
            }
        };
    }

    protected UsageGroup createUsageGroupForElement(PsiElement psiElement) {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)psiElement, this.getUsageClass());
        if (this.isAcceptableElement(element)) {
            return this.createUsageGroup(element);
        }
        return null;
    }

    protected boolean isAcceptableElement(PsiElement element) {
        return element != null;
    }

    protected abstract Class<T> getUsageClass();

    protected abstract UsageGroup createUsageGroup(T var1);
}

