/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.find.findUsages.PersistentFindUsagesOptions;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCFindUsagesOptions
extends PersistentFindUsagesOptions {
    public boolean isSearchForIvars;
    public boolean isSearchForProperties;
    public boolean isSearchForDerivedClasses;

    public OCFindUsagesOptions(@NotNull Project project) {
        super(project);
        this.isUsages = true;
    }

    public final void setDefaults(@NotNull Project project) {
        this.setDefaults(PropertiesComponent.getInstance((Project)project), this.findPrefix());
    }

    protected void setDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        this.isSearchForTextOccurrences = properties.getBoolean(prefix + "isSearchForTextOccurrences", false);
        this.isUsages = properties.getBoolean(prefix + "isUsages", true);
        this.isSearchForIvars = properties.getBoolean(prefix + "isSearchForIvars", false);
        this.isSearchForProperties = properties.getBoolean(prefix + "isSearchForProperties", true);
        this.isSearchForDerivedClasses = properties.getBoolean(prefix + "isSearchForDerivedClasses", false);
    }

    public final void storeDefaults(@NotNull Project project) {
        this.storeDefaults(PropertiesComponent.getInstance((Project)project), this.findPrefix());
    }

    protected void storeDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        properties.setValue(prefix + "isSearchForTextOccurrences", this.isSearchForTextOccurrences, false);
        properties.setValue(prefix + "isUsages", this.isUsages, true);
        properties.setValue(prefix + "isSearchForIvars", this.isSearchForIvars, false);
        properties.setValue(prefix + "isSearchForProperties", this.isSearchForProperties, true);
        properties.setValue(prefix + "isSearchForDerivedClasses", this.isSearchForDerivedClasses, false);
    }

    @NotNull
    private String findPrefix() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ".";
    }

    public static OCFindUsagesOptions getInstance(@NotNull Project project) {
        return (OCFindUsagesOptions)((Object)project.getService(OCFindUsagesOptions.class));
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OCFindUsagesOptions options = (OCFindUsagesOptions)((Object)o);
        if (this.isSearchForDerivedClasses != options.isSearchForDerivedClasses) {
            return false;
        }
        if (this.isSearchForIvars != options.isSearchForIvars) {
            return false;
        }
        return this.isSearchForProperties == options.isSearchForProperties;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isSearchForIvars ? 1 : 0);
        result = 31 * result + (this.isSearchForProperties ? 1 : 0);
        result = 31 * result + (this.isSearchForDerivedClasses ? 1 : 0);
        return result;
    }

    protected void addUsageTypes(@NotNull LinkedHashSet<? super String> to) {
        if (this.isUsages) {
            to.add(AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]));
        }
    }

    @NotNull
    public final String generateUsagesString() {
        LinkedHashSet strings = new LinkedHashSet();
        this.addUsageTypes(strings);
        if (strings.isEmpty()) {
            return AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]);
        }
        return NlsMessages.formatOrList(strings);
    }
}

