/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSourcesScopeProvider
extends CustomScopesProviderEx {
    private final List<NamedScope> myScopes = ContainerUtil.immutableList((Object[])new NamedScope[]{new SourceFilesScope(), new NonSourceFilesScope()});

    @NotNull
    public List<NamedScope> getCustomScopes() {
        return this.myScopes;
    }

    public static class NonSourceFilesScope
    extends NamedScope {
        public static final String NAME = "Project Non-Source Files";

        public NonSourceFilesScope() {
            super(NAME, () -> OCBundle.message("search.scope.project.non.source.files", new Object[0]), AllIcons.Modules.ResourcesRoot, (PackageSet)new AbstractPackageSet(NAME){

                public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                    return OCSearchScope.isInProjectNonSources(project, file);
                }
            });
        }
    }

    public static class SourceFilesScope
    extends NamedScope {
        public static final String NAME = "Project Source Files";

        @NotNull
        @Nls
        public static String presentableName() {
            return OCBundle.message("search.scope.project.source.files", new Object[0]);
        }

        public SourceFilesScope() {
            super(NAME, () -> SourceFilesScope.presentableName(), AllIcons.Modules.SourceRoot, (PackageSet)new AbstractPackageSet(NAME){

                public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                    return OCSearchScope.isInProjectSources(project, file);
                }
            });
        }
    }
}

