/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.search.scopes.OCExplicitSourcesSearchScope;
import com.jetbrains.cidr.lang.search.scopes.ProjectSourcesScopeProvider;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class OCSearchScopeService {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AtomicNotNullLazyValue<GlobalSearchScope> myProjectSearchScope;
    @NotNull
    private final CachedValue<Map<VirtualFile, Boolean>> myImportedHeaders;

    @NotNull
    public static OCSearchScopeService getInstance(@NotNull Project project) {
        return (OCSearchScopeService)project.getService(OCSearchScopeService.class);
    }

    public OCSearchScopeService(@NotNull Project project) {
        this.myProject = project;
        this.myImportedHeaders = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create(new ConcurrentHashMap(), this.getProjectSourcesCacheDependencies()));
        this.myProjectSearchScope = AtomicNotNullLazyValue.createValue(() -> this.createProjectSourcesScope());
    }

    @NotNull
    public GlobalSearchScope getGotoSymbolScope(boolean includeNonProjectFiles) {
        return includeNonProjectFiles ? ProjectScope.getAllScope((Project)this.myProject) : this.getProjectSourcesScope();
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope() {
        return (GlobalSearchScope)this.myProjectSearchScope.getValue();
    }

    @NotNull
    private DelegatingGlobalSearchScope createProjectSourcesScope() {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        final Condition sourceCondition = file -> OCSearchScopeService.isInExplicitProjectSources(index, file);
        final Condition projectCondition = file -> OCSearchScopeService.isInProject(index, file);
        return new DelegatingGlobalSearchScope(ProjectScope.getContentScope((Project)this.myProject)){

            @NotNull
            public String getDisplayName() {
                return ProjectSourcesScopeProvider.SourceFilesScope.presentableName();
            }

            public boolean contains(@NotNull VirtualFile file) {
                return (Boolean)ReadAction.compute(() -> sourceCondition.value((Object)file) || projectCondition.value((Object)file) && OCSearchScopeService.this.isImportedFromSource(file, (Condition<VirtualFile>)sourceCondition));
            }
        };
    }

    private boolean isImportedFromSource(@NotNull VirtualFile header, @NotNull Condition<VirtualFile> sourceCondition) {
        Map cache = (Map)this.myImportedHeaders.getValue();
        if (!cache.containsKey(header)) {
            boolean imported = FileSymbolTableHelper.isSourceFile(header, this.myProject) && !OCImportGraph.getInstance(this.myProject).processIncludingFiles(header, false, true, (Processor<? super VirtualFile>)((Processor)includer -> !sourceCondition.value(includer)));
            cache.put(header, imported);
        }
        return (Boolean)cache.get(header);
    }

    @NotNull
    private Collection<?> getProjectSourcesCacheDependencies() {
        List<ModificationTracker> baseDeps = Arrays.asList(OCExplicitSourcesSearchScope.getProjectSourcesCacheDependenciesExplicitRootsOnly((Project)this.myProject));
        return ContainerUtil.append(baseDeps, (Object[])new ModificationTracker[]{OCImportGraph.getInstance(this.myProject).getModificationTracker()});
    }

    @Contract(value="null -> false")
    public boolean isInProjectSources(@Nullable OCSymbol symbol) {
        return this.isInProjectSources((PsiElement)this.getContainingFile(symbol));
    }

    @Nullable
    private PsiFile getContainingFile(@Nullable OCSymbol symbol) {
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        return symbol.getContainingPsiFile(this.myProject);
    }

    @Contract(value="null->false")
    public boolean isInProjectSources(@Nullable PsiElement element) {
        return element != null && this.isInProjectSources(OCSearchScopeService.getVirtualFile(element));
    }

    public boolean isInProjectSources(@Nullable VirtualFile file) {
        return file != null && this.getProjectSourcesScope().contains(file);
    }

    private static boolean isInExplicitProjectSources(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        return OCExplicitSourcesSearchScope.isInExplicitProjectSources((ProjectFileIndex)index, (VirtualFile)file);
    }

    private static boolean isInProject(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        return index.isInContent(file) && !index.isInLibrary(file);
    }

    public boolean isInProjectNonSources(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return OCSearchScopeService.isInProject(index, file) && !this.getProjectSourcesScope().contains(file);
    }

    public boolean isInProject(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return OCSearchScopeService.isInProject(index, file);
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesOrLibrariesScope() {
        return this.getProjectSourcesScope().uniteWith(ProjectScope.getLibrariesScope((Project)this.myProject));
    }

    @Contract(value="null->false")
    public boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        return element != null && this.isInProjectSourcesOrLibraries(OCSearchScopeService.getVirtualFile(element));
    }

    public boolean isInProjectSourcesOrLibraries(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return this.getProjectSourcesOrLibrariesScope().contains(file);
    }

    public boolean isInProjectSourcesOrLibraries(@Nullable OCSymbol symbol) {
        return this.isInProjectSourcesOrLibraries((PsiElement)this.getContainingFile(symbol));
    }

    @Contract(value="null -> false")
    public boolean isInLibraries(@Nullable OCSymbol symbol) {
        return this.isInLibraries((PsiElement)this.getContainingFile(symbol));
    }

    @Contract(value="null->false")
    public boolean isInLibraries(@Nullable PsiElement element) {
        VirtualFile file = OCSearchScopeService.getVirtualFile(element);
        if (file == null) {
            return false;
        }
        return this.isInLibraries(file);
    }

    public boolean isInLibraries(@NotNull VirtualFile file) {
        return ProjectScope.getLibrariesScope((Project)this.myProject).contains(file);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiCodeFragment) {
            PsiElement context = file.getContext();
            file = context == null ? null : context.getContainingFile();
        }
        return file == null ? null : OCFileUtil.getVirtualFile(file);
    }
}

