/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.lang.search.scopes.OCExplicitSourcesSearchScope;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScopeService;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchScope {
    @NotNull
    public static GlobalSearchScope getGotoSymbolScope(@NotNull Project project, boolean includeNonProjectFiles) {
        return OCSearchScopeService.getInstance(project).getGotoSymbolScope(includeNonProjectFiles);
    }

    @NotNull
    public static GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        return OCSearchScopeService.getInstance(project).getProjectSourcesScope();
    }

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(@NotNull Project project) {
        return OCExplicitSourcesSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)project);
    }

    @Contract(value="null, _->false")
    public static boolean isInProjectSources(@Nullable OCSymbol symbol, @NotNull Project project) {
        return symbol != null && OCSearchScopeService.getInstance(project).isInProjectSources(symbol);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable PsiElement element) {
        return element != null && OCSearchScopeService.getInstance(element.getProject()).isInProjectSources(element);
    }

    public static boolean isInProjectSources(@NotNull Project project, @Nullable VirtualFile file) {
        return file != null && OCSearchScope.getProjectSourcesScope(project).contains(file);
    }

    public static boolean isInProjectNonSources(@NotNull Project project, @Nullable VirtualFile file) {
        return file != null && OCSearchScopeService.getInstance(project).isInProjectNonSources(file);
    }

    public static boolean isInProject(@NotNull Project project, @Nullable VirtualFile file) {
        return file != null && OCSearchScopeService.getInstance(project).isInProject(file);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        return element != null && OCSearchScopeService.getInstance(element.getProject()).isInProjectSourcesOrLibraries(element);
    }

    public static boolean isInProjectSourcesOrLibraries(@NotNull Project project, @Nullable VirtualFile file) {
        return file != null && OCSearchScopeService.getInstance(project).isInProjectSourcesOrLibraries(file);
    }

    public static boolean isInProjectSourcesOrLibraries(@Nullable OCSymbol symbol, @NotNull Project project) {
        return symbol != null && OCSearchScopeService.getInstance(project).isInProjectSourcesOrLibraries(symbol);
    }

    @Contract(value="null, _->false")
    public static boolean isInLibraries(@Nullable OCSymbol symbol, @NotNull Project project) {
        return symbol != null && OCSearchScopeService.getInstance(project).isInLibraries(symbol);
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable PsiElement element) {
        return element != null && OCSearchScopeService.getInstance(element.getProject()).isInLibraries(element);
    }

    public static boolean isInLibraries(@NotNull VirtualFile file, @NotNull Project project) {
        return OCSearchScopeService.getInstance(project).isInLibraries(file);
    }
}

