/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.usages.OCReferencesSearchParameters;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class OCSameSymbolsSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        if (queryParameters instanceof OCReferencesSearchParameters && ((OCReferencesSearchParameters)queryParameters).findDeclarationReferences()) {
            return (Boolean)ReadAction.compute(() -> OCSameSymbolsSearch.doExecute(queryParameters, consumer));
        }
        return true;
    }

    @NotNull
    private static Boolean doExecute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCSymbolDeclarator)) {
            return true;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (symbol == null) {
            return true;
        }
        Project project = element.getProject();
        SearchScope scopeToFindIn = queryParameters.getEffectiveSearchScope();
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)sameSymbol -> {
            if (sameSymbol != null && sameSymbol != symbol) {
                PsiElement def;
                if (sameSymbol.isSynthetic() || sameSymbol instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)sameSymbol).isSyntheticNamespace()) {
                    return true;
                }
                VirtualFile file = sameSymbol.getContainingFile();
                if (file != null && scopeToFindIn.contains(file) && (def = sameSymbol.locateDefinition(project)) != null && element != def) {
                    Optional<PsiElement> refElement;
                    PsiReference reference = def.getReference();
                    if (reference != null) {
                        return consumer.process((Object)reference);
                    }
                    if (def instanceof OCStructLike && !((OCStructLike)def).isDeclaration() && (refElement = Arrays.stream(def.getChildren()).filter(c -> c instanceof OCReferenceElement).findFirst()).isPresent()) {
                        return consumer.process((Object)((OCReferenceElement)refElement.get()));
                    }
                }
            }
            return true;
        }), project);
        return true;
    }
}

