/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import org.jetbrains.annotations.NotNull;

public class OCPropertyReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        return (Boolean)ReadAction.compute(() -> OCPropertyReferencesSearch.doExecute(queryParameters, consumer));
    }

    @NotNull
    private static Boolean doExecute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCSymbolDeclarator)) {
            return true;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (!(symbol instanceof OCPropertySymbol)) {
            return true;
        }
        OCPropertySymbol property = (OCPropertySymbol)symbol;
        return property.getParent().processMembers(OCMethodSymbol.class, method -> {
            if (method.getOriginalSymbol() != property) {
                return true;
            }
            String methodSelector = method.getName();
            TextOccurenceProcessor processor = (place, offsetInElement) -> {
                String selector;
                if (place instanceof OCSendMessageExpression) {
                    selector = ((OCSendMessageExpression)place).getMessageSelector();
                } else if (place instanceof OCSelectorExpression) {
                    selector = ((OCSelectorExpression)place).getSelector();
                } else if (place instanceof OCQualifiedExpression) {
                    selector = ((OCQualifiedExpression)place).getName();
                } else {
                    return true;
                }
                if (!methodSelector.equals(selector)) {
                    return true;
                }
                PsiReference ref = place.getReference();
                if (ref == null || !ref.isReferenceTo(element)) {
                    return true;
                }
                return consumer.process((Object)ref);
            };
            PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)element.getProject());
            return helper.processElementsWithWord(processor, queryParameters.getEffectiveSearchScope(), methodSelector, (short)1, true);
        });
    }
}

